/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.citizen;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.core.util.TeleportHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class RecallSingleCitizenMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"recall_single_citizen", RecallSingleCitizenMessage::new);
    private final int citizenId;

    public RecallSingleCitizenMessage(IBuildingView building, int citizenid) {
        super(TYPE, building);
        this.citizenId = citizenid;
    }

    protected RecallSingleCitizenMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.citizenId = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.citizenId);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        citizenData.setLastPosition(building.getPosition());
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            citizenData.updateEntityIfNecessary();
            optionalEntityCitizen = citizenData.getEntity();
        }
        if (optionalEntityCitizen.isPresent() && optionalEntityCitizen.get().getTicksExisted() == 0) {
            citizenData.updateEntityIfNecessary();
        }
        BlockPos loc = building.getID();
        if (optionalEntityCitizen.isPresent() && !TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), colony.getWorld(), loc)) {
            MessageUtils.format("com.minecolonies.coremod.workerhuts.recallfail", new Object[0]).sendTo(new Player[]{player});
        }
    }
}

