/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AssignFilterableItemMessage
extends AbstractBuildingServerMessage<AbstractBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"assign_filterable_item_message", AssignFilterableItemMessage::new);
    private final boolean assign;
    private final ItemStorage item;
    private final int id;

    public AssignFilterableItemMessage(IBuildingView building, int id, ItemStorage item, boolean assign) {
        super(TYPE, building);
        this.assign = assign;
        this.item = item;
        this.id = id;
    }

    protected AssignFilterableItemMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.assign = buf.readBoolean();
        this.item = new ItemStorage(Utils.deserializeCodecMess(buf));
        this.id = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.assign);
        Utils.serializeCodecMess(buf, this.item.getItemStack());
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, AbstractBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof ItemListModule) {
            ItemListModule module = (ItemListModule)iBuildingModule;
            if (this.assign) {
                module.addItem(this.item);
            } else {
                module.removeItem(this.item);
            }
        }
    }
}

