/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.EntityListModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AssignFilterableEntityMessage
extends AbstractBuildingServerMessage<AbstractBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"assign_filterable_entity", AssignFilterableEntityMessage::new);
    private final boolean assign;
    private final ResourceLocation entity;
    private final int id;

    public AssignFilterableEntityMessage(IBuildingView building, int id, ResourceLocation entity, boolean assign) {
        super(TYPE, building);
        this.assign = assign;
        this.entity = entity;
        this.id = id;
    }

    protected AssignFilterableEntityMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.assign = buf.readBoolean();
        this.entity = buf.readResourceLocation();
        this.id = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.assign);
        buf.writeResourceLocation(this.entity);
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, AbstractBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof EntityListModule) {
            EntityListModule module = (EntityListModule)iBuildingModule;
            if (this.assign) {
                module.addEntity(this.entity);
            } else {
                module.removeEntity(this.entity);
            }
        }
    }
}

