/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.modules.MinimumStockModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AddMinimumStockToBuildingModuleMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"add_minimum_stock_to_building_module", AddMinimumStockToBuildingModuleMessage::new);
    private ItemStack itemStack;
    private int quantity;

    public AddMinimumStockToBuildingModuleMessage(IBuildingView building, ItemStack itemStack, int quantity) {
        super(TYPE, building);
        this.itemStack = itemStack;
        this.quantity = quantity;
    }

    protected AddMinimumStockToBuildingModuleMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.itemStack = Utils.deserializeCodecMess(buf);
        this.quantity = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        Utils.serializeCodecMess(buf, this.itemStack);
        buf.writeInt(this.quantity);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        MinimumStockModule minStockModule = (MinimumStockModule)building.getFirstModuleOccurance(MinimumStockModule.class);
        if (minStockModule != null) {
            minStockModule.addMinimumStock(this.itemStack, this.quantity);
        }
    }
}

