/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ColonyDeleteOwnMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"colony_delete_own", ColonyDeleteOwnMessage::new);

    protected void toBytes(RegistryFriendlyByteBuf buf) {
    }

    protected ColonyDeleteOwnMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
    }

    public ColonyDeleteOwnMessage() {
        super(TYPE);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        if (player == null) {
            return;
        }
        IColony colony = IColonyManager.getInstance().getIColonyByOwner(player.level(), (Player)player);
        if (colony != null) {
            IColonyManager.getInstance().deleteColonyByDimension(colony.getID(), false, colony.getDimension());
            MessageUtils.format("com.minecolonies.core.gui.colony.destroy.success", new Object[0]).sendTo(new Player[]{player});
        } else {
            MessageUtils.format("com.minecolonies.coremod.colony.notfound", new Object[0]).sendTo(new Player[]{player});
        }
    }
}

