/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.items.component.SupplyData;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class MarkStoryReadOnItem
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"mark_story_read", MarkStoryReadOnItem::new);
    private InteractionHand hand;

    public MarkStoryReadOnItem(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(type);
        this.hand = InteractionHand.values()[buf.readInt()];
    }

    public MarkStoryReadOnItem(InteractionHand hand) {
        super(TYPE);
        this.hand = hand;
    }

    public void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.hand.ordinal());
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer sender) {
        SupplyData.updateItemStack(sender.getItemInHand(this.hand), supply -> supply.withSawStory(true));
    }
}

