/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.core.items.ItemClipboard;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ItemSettingMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"item_setting", ItemSettingMessage::new);
    public String settingName;
    public int settingValue;

    public ItemSettingMessage(String name, int value) {
        super(TYPE);
        this.settingName = name;
        this.settingValue = value;
    }

    protected ItemSettingMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.settingName = buf.readUtf();
        this.settingValue = buf.readInt();
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (player == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack == null || !(stack.getItem() instanceof ItemClipboard)) {
            return;
        }
        CustomData current = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = current.copyTag();
        tag.putBoolean(this.settingName, this.settingValue > 0);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        player.getInventory().setChanged();
        player.containerMenu.broadcastChanges();
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.settingName);
        buf.writeInt(this.settingValue);
    }
}

