/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.ClickGuiButtonTrigger;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClickGuiButtonTriggerMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"click_gui_button_trigger", ClickGuiButtonTriggerMessage::new);
    private final String buttonId;
    private final ResourceLocation resource;

    public ClickGuiButtonTriggerMessage(String buttonId, ResourceLocation resource) {
        super(TYPE);
        this.resource = resource;
        this.buttonId = buttonId;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeResourceLocation(this.resource);
        buf.writeUtf(this.buttonId);
    }

    protected ClickGuiButtonTriggerMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.resource = buf.readResourceLocation();
        this.buttonId = buf.readUtf();
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        ((ClickGuiButtonTrigger)((Object)AdvancementTriggers.CLICK_GUI_BUTTON.get())).trigger(player, this.buttonId, this.resource);
    }
}

