/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.core.datalistener.QuestJsonListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class GlobalQuestSyncMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"global_quest_sync", GlobalQuestSyncMessage::new, (boolean)true, (boolean)false);
    private final RegistryFriendlyByteBuf questBuffer;

    public GlobalQuestSyncMessage(RegistryFriendlyByteBuf buf) {
        super(TYPE);
        this.questBuffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(buf.copy()), buf.registryAccess());
    }

    protected GlobalQuestSyncMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.questBuffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray())), buf.registryAccess());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        this.questBuffer.resetReaderIndex();
        buf.writeByteArray(this.questBuffer.array());
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        QuestJsonListener.readGlobalQuestPackets(this.questBuffer);
    }
}

