/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.mobs.barbarians.AbstractEntityBarbarianRaider;
import com.minecolonies.api.items.IChiefSwordItem;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemChiefSword
extends SwordItem
implements IChiefSwordItem {
    private static final int LEVITATION_EFFECT_DURATION = 200;
    private static final int LEVITATION_EFFECT_MULTIPLIER = 2;

    public ItemChiefSword(Item.Properties properties) {
        super((Tier)Tiers.DIAMOND, properties.attributes(SwordItem.createAttributes((Tier)Tiers.WOOD, (int)3, (float)-2.4f)));
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player && isSelected) {
            RaiderMobUtils.getBarbariansCloseToEntity(entityIn, 60.0).forEach(entity -> entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 600, 0)));
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, @NotNull LivingEntity attacker) {
        if (attacker instanceof Player && target instanceof AbstractEntityBarbarianRaider) {
            target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 200, 2));
        }
        return super.hurtEnemy(stack, target, attacker);
    }
}

