/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemScroll
extends AbstractItemMinecolonies {
    public static final int FAIL_RESPONSES_TOTAL = 10;

    public AbstractItemScroll(String name, Item.Properties properties) {
        super(name, properties);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level world, LivingEntity entityLiving) {
        if (!(entityLiving instanceof ServerPlayer) || world.isClientSide) {
            return itemStack;
        }
        ServerPlayer player = (ServerPlayer)entityLiving;
        if (!this.needsColony()) {
            return this.onItemUseSuccess(itemStack, world, player);
        }
        IColony colony = this.getColony(itemStack);
        if (colony == null) {
            player.displayClientMessage((Component)Component.translatableEscape((String)"minecolonies.scroll.needcolony", (Object[])new Object[0]), true);
            return itemStack;
        }
        if (!colony.getPermissions().hasPermission((Player)player, Action.RIGHTCLICK_BLOCK)) {
            MessageUtils.format("minecolonies.scroll.nopermission", new Object[0]).sendTo(new Player[]{player});
            return itemStack;
        }
        return this.onItemUseSuccess(itemStack, world, player);
    }

    protected abstract ItemStack onItemUseSuccess(ItemStack var1, Level var2, ServerPlayer var3);

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide || !ctx.getPlayer().isShiftKeyDown() || !this.needsColony()) {
            return InteractionResult.PASS;
        }
        BlockEntity te = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        ItemStack scroll = ctx.getPlayer().getItemInHand(ctx.getHand());
        if (te instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding colonyBuilding = (TileEntityColonyBuilding)te;
            colonyBuilding.getBuilding().writeToItemStack(scroll);
            MessageUtils.format("minecolonies.scroll.registered", colonyBuilding.getColony().getName()).sendTo(ctx.getPlayer());
        }
        return InteractionResult.SUCCESS;
    }

    protected abstract boolean needsColony();

    @Deprecated(forRemoval=true, since="1.21")
    protected IColony getColony(ItemStack stack) {
        return ColonyId.readColonyFromItemStack(stack);
    }

    @Deprecated(forRemoval=true, since="1.21")
    protected IColony getColonyView(ItemStack stack) {
        return ColonyId.readColonyViewFromItemStack(stack);
    }
}

