/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.items.ModItems;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class DefaultRecruitmentItemsProvider
implements DataProvider {
    private final PackOutput.PathProvider outputProvider;

    public DefaultRecruitmentItemsProvider(@NotNull PackOutput packOutput) {
        this.outputProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "colony/recruitment_items");
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cachedOutput) {
        return CompletableFuture.allOf(this.makeRecruitmentItem(cachedOutput, Items.DRIED_KELP, 1), this.makeRecruitmentItem(cachedOutput, Items.BREAD, 1), this.makeRecruitmentItem(cachedOutput, Items.PAPER, 1), this.makeRecruitmentItem(cachedOutput, Items.APPLE, 1), this.makeRecruitmentItem(cachedOutput, Items.BAKED_POTATO, 1), this.makeRecruitmentItem(cachedOutput, Items.SUGAR, 1), this.makeRecruitmentItem(cachedOutput, Items.EGG, 1), this.makeRecruitmentItem(cachedOutput, Items.MUSHROOM_STEW, 2), this.makeRecruitmentItem(cachedOutput, Items.FEATHER, 2), this.makeRecruitmentItem(cachedOutput, Items.FLINT, 2), this.makeRecruitmentItem(cachedOutput, Items.COPPER_INGOT, 2), this.makeRecruitmentItem(cachedOutput, Items.LEATHER, 2), this.makeRecruitmentItem(cachedOutput, Items.COOKED_COD, 2), this.makeRecruitmentItem(cachedOutput, Items.COOKED_SALMON, 2), this.makeRecruitmentItem(cachedOutput, Items.COOKED_CHICKEN, 3), this.makeRecruitmentItem(cachedOutput, Items.COOKED_PORKCHOP, 3), this.makeRecruitmentItem(cachedOutput, Items.COOKED_MUTTON, 3), this.makeRecruitmentItem(cachedOutput, Items.COOKED_BEEF, 3), this.makeRecruitmentItem(cachedOutput, Items.BOOK, 3), this.makeRecruitmentItem(cachedOutput, Items.IRON_INGOT, 4), this.makeRecruitmentItem(cachedOutput, Items.GOLD_INGOT, 4), this.makeRecruitmentItem(cachedOutput, Items.COOKIE, 4), this.makeRecruitmentItem(cachedOutput, Items.REDSTONE, 4), this.makeRecruitmentItem(cachedOutput, Items.LAPIS_LAZULI, 4), this.makeRecruitmentItem(cachedOutput, Items.QUARTZ, 4), this.makeRecruitmentItem(cachedOutput, Items.AMETHYST_CLUSTER, 4), this.makeRecruitmentItem(cachedOutput, Items.HONEYCOMB, 5), this.makeRecruitmentItem(cachedOutput, Items.HONEY_BOTTLE, 5), this.makeRecruitmentItem(cachedOutput, Items.NETHER_WART, 5), this.makeRecruitmentItem(cachedOutput, ModItems.muffin, 5), this.makeRecruitmentItem(cachedOutput, ModItems.veggie_quiche, 5), this.makeRecruitmentItem(cachedOutput, ModItems.pasta_plain, 5), this.makeRecruitmentItem(cachedOutput, ModItems.pottage, 5), this.makeRecruitmentItem(cachedOutput, Items.INK_SAC, 6), this.makeRecruitmentItem(cachedOutput, Items.BLAZE_POWDER, 6), this.makeRecruitmentItem(cachedOutput, Items.SPIDER_EYE, 6), this.makeRecruitmentItem(cachedOutput, Items.SLIME_BALL, 6), this.makeRecruitmentItem(cachedOutput, ModItems.steak_dinner, 7), this.makeRecruitmentItem(cachedOutput, ModItems.hand_pie, 7), this.makeRecruitmentItem(cachedOutput, ModItems.schnitzel, 7), this.makeRecruitmentItem(cachedOutput, Items.DIAMOND, 8), this.makeRecruitmentItem(cachedOutput, Items.EMERALD, 8), this.makeRecruitmentItem(cachedOutput, Items.ENDER_PEARL, 8), this.makeRecruitmentItem(cachedOutput, Items.CAKE, 8), this.makeRecruitmentItem(cachedOutput, ModItems.lamb_stew, 8), this.makeRecruitmentItem(cachedOutput, ModItems.sushi_roll, 8), this.makeRecruitmentItem(cachedOutput, ModItems.eggplant_dolma, 8), this.makeRecruitmentItem(cachedOutput, ModItems.pita_hummus, 8), this.makeRecruitmentItem(cachedOutput, Items.GHAST_TEAR, 9), this.makeRecruitmentItem(cachedOutput, Items.EXPERIENCE_BOTTLE, 9), this.makeRecruitmentItem(cachedOutput, Items.ENCHANTED_BOOK, 9), this.makeRecruitmentItem(cachedOutput, Items.GOLDEN_APPLE, 9));
    }

    @NotNull
    public String getName() {
        return "Default Recruitment Items Provider";
    }

    private CompletableFuture<?> makeRecruitmentItem(CachedOutput cachedOutput, Item item, int rarity) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        JsonObject object = new JsonObject();
        object.addProperty("item", itemId.toString());
        object.addProperty("rarity", (Number)rarity);
        return DataProvider.saveStable((CachedOutput)cachedOutput, (JsonElement)object, (Path)this.outputProvider.json(new ResourceLocation("minecolonies", itemId.getPath())));
    }
}

