/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.loot.EntityInBiomeTag;
import com.minecolonies.api.loot.ModLootConditions;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import org.jetbrains.annotations.NotNull;

public class DefaultCropsLootProvider
implements LootTableSubProvider {
    public static final ResourceKey<LootTable> DUNGEON_CROPS = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"crops/dungeon"));
    private final HolderLookup.Provider provider;

    public DefaultCropsLootProvider(@NotNull HolderLookup.Provider provider) {
        this.provider = provider;
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> generator) {
        HolderLookup.RegistryLookup enchantments = this.provider.lookupOrThrow(Registries.ENCHANTMENT);
        HashMap<ResourceLocation, List> cropDrops = new HashMap<ResourceLocation, List>();
        for (MinecoloniesCropBlock crop : ModBlocks.getCrops()) {
            for (Block source : crop.getDroppedFrom()) {
                cropDrops.computeIfAbsent(source.getLootTable().location(), t -> new ArrayList()).add(crop);
            }
        }
        for (Map.Entry entry : cropDrops.entrySet()) {
            float chance = ((ResourceLocation)entry.getKey()).equals((Object)Blocks.SHORT_GRASS.getLootTable().location()) ? 0.001f : 0.01f;
            LootTable.Builder table = LootTable.lootTable();
            for (MinecoloniesCropBlock crop : (List)entry.getValue()) {
                LootPool.Builder pool = LootPool.lootPool();
                if (crop.getPreferredBiome() != null) {
                    pool.when(EntityInBiomeTag.of(crop.getPreferredBiome()));
                }
                pool.when(ModLootConditions.doesNotHaveShearsOrSilkTouch((HolderLookup.RegistryLookup<Enchantment>)enchantments));
                pool.add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]).otherwise(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)crop).when(ModLootConditions.HAS_NETHERITE_HOE)).when(LootItemRandomChanceCondition.randomChance((float)(chance * 4.0f)))).otherwise(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)crop).when(ModLootConditions.HAS_DIAMOND_HOE)).when(LootItemRandomChanceCondition.randomChance((float)(chance * 3.5f)))).otherwise(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)crop).when(ModLootConditions.HAS_IRON_HOE)).when(LootItemRandomChanceCondition.randomChance((float)(chance * 3.0f)))).otherwise(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)crop).when(ModLootConditions.HAS_GOLDEN_HOE)).when(LootItemRandomChanceCondition.randomChance((float)(chance * 2.5f)))).otherwise(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)crop).when((LootItemCondition.Builder)ModLootConditions.HAS_HOE.and(ModLootConditions.HAS_NETHERITE_HOE.invert()).and(ModLootConditions.HAS_DIAMOND_HOE.invert()).and(ModLootConditions.HAS_IRON_HOE.invert()).and(ModLootConditions.HAS_GOLDEN_HOE.invert()))).when(LootItemRandomChanceCondition.randomChance((float)(chance * 2.0f)))).otherwise(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)crop).when(ModLootConditions.HAS_HOE.invert())).when(LootItemRandomChanceCondition.randomChance((float)chance))));
                table.withPool(pool);
            }
            generator.accept(DefaultCropsLootProvider.getCropSourceLootTable((ResourceLocation)entry.getKey()), table);
        }
        LootPool.Builder dungeonPool = LootPool.lootPool();
        for (MinecoloniesCropBlock crop : ModBlocks.getCrops()) {
            dungeonPool.add(LootItem.lootTableItem((ItemLike)crop).when(LootItemRandomChanceCondition.randomChance((float)0.005f)));
        }
        generator.accept(DUNGEON_CROPS, LootTable.lootTable().withPool(dungeonPool));
    }

    public static ResourceKey<LootTable> getCropSourceLootTable(@NotNull ResourceLocation source) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)("crops/" + source.getPath())));
    }
}

