/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation;

import com.minecolonies.core.generation.CustomRecipeProvider;
import com.minecolonies.core.generation.SimpleLootTableProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public abstract class CustomRecipeAndLootTableProvider
implements DataProvider {
    private final CompletableFuture<HolderLookup.Provider> providerFuture;
    private final ChildRecipeProvider recipeProvider;
    private final ChildLootTableProvider lootTableProvider;
    protected HolderLookup.Provider provider;

    protected CustomRecipeAndLootTableProvider(@NotNull PackOutput packOutput, @NotNull CompletableFuture<HolderLookup.Provider> providerFuture) {
        this.providerFuture = providerFuture;
        this.recipeProvider = new ChildRecipeProvider(packOutput, providerFuture);
        this.lootTableProvider = new ChildLootTableProvider(packOutput, providerFuture);
    }

    protected CompletableFuture<?> generate(@NotNull HolderLookup.Provider provider) {
        return CompletableFuture.completedFuture(null);
    }

    protected abstract void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> var1);

    @NotNull
    protected abstract List<LootTableProvider.SubProviderEntry> registerTables();

    protected CustomRecipeProvider.CustomRecipeBuilder recipe(String crafter, String module, String id) {
        return this.recipeProvider.recipe(crafter, module, id);
    }

    protected static ResourceKey<LootTable> table(@NotNull ResourceLocation id) {
        return SimpleLootTableProvider.table(id);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return ((CompletableFuture)this.providerFuture.thenComposeAsync(provider -> {
            this.provider = provider;
            return this.generate((HolderLookup.Provider)provider);
        })).thenCompose(x -> CompletableFuture.allOf(this.recipeProvider.run(cache), this.lootTableProvider.run(cache)));
    }

    private class ChildRecipeProvider
    extends CustomRecipeProvider {
        public ChildRecipeProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
            super(packOutput, provider);
        }

        @NotNull
        public String getName() {
            return CustomRecipeAndLootTableProvider.this.getName() + " recipes";
        }

        @Override
        protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
            CustomRecipeAndLootTableProvider.this.registerRecipes(consumer);
        }
    }

    private class ChildLootTableProvider
    extends SimpleLootTableProvider {
        public ChildLootTableProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
            super(packOutput, provider);
        }

        @NotNull
        public List<LootTableProvider.SubProviderEntry> getTables() {
            return CustomRecipeAndLootTableProvider.this.registerTables();
        }
    }
}

