/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.configuration.ClientConfiguration;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.client.gui.WindowBuildingBrowser;
import com.minecolonies.core.client.gui.containers.WindowCitizenInventory;
import com.minecolonies.core.client.render.worldevent.ColonyBorderRenderer;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.crafting.CustomRecipe;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.util.DomumOrnamentumUtils;
import com.minecolonies.core.util.SchemAnalyzerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Lazy<Map<String, BuildingEntry>> crafterToBuilding = Lazy.of(ClientEventHandler::buildCrafterToBuildingMap);
    public static Map<Item, Component> extraItemTooltips = new HashMap<Item, Component>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderWorldLastEvent(@NotNull RenderLevelStageEvent event) {
        WorldEventContext.INSTANCE.renderWorldLastEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onwWorldTick(@NotNull LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide && ColonyConstants.rand.nextInt(20) == 0) {
            WorldEventContext.INSTANCE.checkNearbyColony(event.getLevel());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(@NotNull ClientPlayerNetworkEvent.LoggingOut event) {
        ColonyBorderRenderer.cleanup();
        WindowBuildingBrowser.clearCache();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        ResourceLocation soundLocation = event.getSound().getLocation();
        if (!((Boolean)((ClientConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getClient()).citizenVoices.get()).booleanValue() && soundLocation.getNamespace().equals("minecolonies") && soundLocation.getPath().startsWith("citizen.")) {
            event.setSound(null);
        }
    }

    @SubscribeEvent
    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        IColony colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColony(event.getEntity().level(), event.getEntity().blockPosition());
        ItemStack stack = event.getItemStack();
        if (extraItemTooltips.containsKey(stack.getItem())) {
            event.getToolTip().add(extraItemTooltips.get(stack.getItem()));
        }
        if (colony == null) {
            colony = IMinecoloniesAPI.getInstance().getColonyManager().getIColonyByOwner(event.getEntity().level(), event.getEntity());
        }
        ClientEventHandler.handleCrafterRecipeTooltips(colony, event.getToolTip(), stack.getItem());
        if (stack.getItem() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)stack.getItem();
            if (blockItem.getBlock() instanceof AbstractBlockHut) {
                ClientEventHandler.handleHutBlockResearchUnlocks(colony, event.getToolTip(), blockItem.getBlock());
            }
            if (event.getEntity().isCreative() && InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((Container)event.getEntity().getInventory()), (Item)ModItems.scanTool.get())) {
                int tier = SchemAnalyzerUtil.getBlockTier(blockItem.getBlock());
                if (DomumOrnamentumUtils.isDoBlock(blockItem.getBlock())) {
                    for (Block block : MaterialTextureData.readFromItemStack((ItemStack)event.getItemStack()).getTexturedComponents().values()) {
                        tier = Math.max(tier, SchemAnalyzerUtil.getBlockTier(block));
                    }
                }
                event.getToolTip().add(Component.translatableEscape((String)"com.minecolonies.coremod.tooltip.schematic.tier", (Object[])new Object[]{tier}));
            }
        }
        if (WindowCitizenInventory.activeCitizenInventory != null && ItemStackUtils.ISFOOD.test(stack)) {
            int homeBuildingLevel;
            if (!FoodUtils.EDIBLE.test(stack)) {
                event.getToolTip().add(Component.translatable((String)"com.minecolonies.coremod.item.tooltip.wrongfood").withStyle(ChatFormatting.RED));
                return;
            }
            double foodValue = FoodUtils.getFoodValue(stack, (FoodProperties)stack.get(DataComponents.FOOD), colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATURATION));
            int foodTier = FoodUtils.getFoodTier(foodValue);
            ICitizenDataView citizenData = (ICitizenDataView)WindowCitizenInventory.activeCitizenInventory.getCitizenData();
            IColonyView colonyView = citizenData.getColony();
            IBuildingView cookBuilding = null;
            for (IBuildingView buildingView : colonyView.getBuildings()) {
                if (buildingView.getBuildingType() != ModBuildings.cook.get() || cookBuilding != null && !(cookBuilding.getID().distSqr((Vec3i)citizenData.getPosition()) > buildingView.getID().distSqr((Vec3i)citizenData.getPosition()))) continue;
                cookBuilding = buildingView;
            }
            int n = homeBuildingLevel = colonyView.getBuilding(citizenData.getHomeBuilding()) == null ? 0 : colonyView.getBuilding(citizenData.getHomeBuilding()).getBuildingLevel();
            if (FoodUtils.canEatLevel(event.getItemStack(), homeBuildingLevel)) {
                event.getToolTip().add(Component.translatable((String)("com.minecolonies.core.item.food.tooltip.tier." + foodTier)).withStyle(ChatFormatting.GRAY));
                if (cookBuilding != null && !cookBuilding.getModuleView(BuildingModules.RESTAURANT_MENU).getMenu().contains(new ItemStorage(event.getItemStack()))) {
                    event.getToolTip().add(Component.translatable((String)"com.minecolonies.coremod.item.tooltip.nomenu").withStyle(ChatFormatting.RED));
                }
            } else {
                event.getToolTip().add(Component.translatable((String)"com.minecolonies.coremod.item.tooltip.needbetterfood").withStyle(ChatFormatting.RED));
            }
        }
    }

    private static void handleCrafterRecipeTooltips(@Nullable IColony colony, List<Component> toolTip, Item item) {
        List<CustomRecipe> recipes = CustomRecipeManager.getInstance().getRecipeByOutput(item);
        if (recipes.isEmpty()) {
            return;
        }
        HashMap<BuildingEntry, Integer> minimumBuildingLevels = new HashMap<BuildingEntry, Integer>();
        for (CustomRecipe customRecipe : recipes) {
            BuildingEntry craftingBuilding;
            if (!customRecipe.getShowTooltip() || customRecipe.getCrafter().length() < 2 || (craftingBuilding = (BuildingEntry)((Map)crafterToBuilding.get()).get(customRecipe.getCrafter())) == null) continue;
            minimumBuildingLevels.putIfAbsent(craftingBuilding, null);
            if (minimumBuildingLevels.get(craftingBuilding) == null || customRecipe.getMinBuildingLevel() < (Integer)minimumBuildingLevels.get(craftingBuilding)) {
                minimumBuildingLevels.put(craftingBuilding, customRecipe.getMinBuildingLevel());
            }
            for (ResourceLocation id : customRecipe.getRequiredResearchIds()) {
                Set<Object> researches;
                if (IMinecoloniesAPI.getInstance().getGlobalResearchTree().hasResearch(id)) {
                    researches = new HashSet<IGlobalResearch>();
                    researches.add(IMinecoloniesAPI.getInstance().getGlobalResearchTree().getResearch(id));
                } else {
                    researches = IMinecoloniesAPI.getInstance().getGlobalResearchTree().getResearchForEffect(id);
                }
                if (researches == null) continue;
                ChatFormatting researchFormat = colony != null && (colony.getResearchManager().getResearchTree().hasCompletedResearch(id) || colony.getResearchManager().getResearchEffects().getEffectStrength(id) > 0.0) ? ChatFormatting.AQUA : ChatFormatting.RED;
                for (IGlobalResearch iGlobalResearch : researches) {
                    toolTip.add((Component)Component.translatableEscape((String)"com.minecolonies.coremod.item.requiresresearch.gui", (Object[])new Object[]{MutableComponent.create((ComponentContents)iGlobalResearch.getName())}).setStyle(Style.EMPTY.withColor(researchFormat)));
                }
            }
        }
        for (Map.Entry entry : minimumBuildingLevels.entrySet()) {
            Component craftingBuildingName = ClientEventHandler.getFullBuildingName((BuildingEntry)entry.getKey());
            Integer minimumLevel = (Integer)entry.getValue();
            if (minimumLevel > 0) {
                ResourceLocation schematicName = ((BuildingEntry)entry.getKey()).getRegistryName();
                MutableComponent reqLevelText = Component.translatableEscape((String)"com.minecolonies.coremod.item.buildlevel.gui", (Object[])new Object[]{craftingBuildingName, minimumLevel});
                if (colony != null && colony.hasBuilding(schematicName, minimumLevel, true)) {
                    reqLevelText.setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA));
                } else {
                    reqLevelText.setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
                }
                toolTip.add((Component)reqLevelText);
                continue;
            }
            MutableComponent reqBuildingTxt = Component.translatableEscape((String)"com.minecolonies.coremod.item.available.gui", (Object[])new Object[]{craftingBuildingName}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY));
            toolTip.add((Component)reqBuildingTxt);
        }
    }

    private static Component getFullBuildingName(@NotNull BuildingEntry building) {
        String namespace = building.getBuildingBlock().getRegistryName().getNamespace();
        String modName = ModList.get().getModContainerById(namespace).map(m -> m.getModInfo().getDisplayName()).orElse(namespace);
        MutableComponent buildingName = building.getBuildingBlock().getName();
        return Component.literal((String)(modName + " ")).append((Component)buildingName);
    }

    private static Map<String, BuildingEntry> buildCrafterToBuildingMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            for (BuildingEntry.ModuleProducer moduleProducer : building.getModuleProducers()) {
                ICraftingBuildingModule craftingBuildingModule;
                IBuildingModule module = BuildingEntry.produceModuleWithoutBuilding(moduleProducer.key);
                if (!(module instanceof ICraftingBuildingModule) || (craftingBuildingModule = (ICraftingBuildingModule)module).getCraftingJob() == null) continue;
                builder.put((Object)craftingBuildingModule.getCustomRecipeKey(), (Object)building);
            }
        }
        return builder.build();
    }

    private static void handleHutBlockResearchUnlocks(IColony colony, List<Component> tooltip, Block block) {
        if (colony == null) {
            return;
        }
        ResourceLocation effectId = colony.getResearchManager().getResearchEffectIdFrom(block);
        if (colony.getResearchManager().getResearchEffects().getEffectStrength(effectId) > 0.0) {
            return;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearchForEffect(effectId) != null) {
            tooltip.add((Component)Component.translatableEscape((String)"com.minecolonies.coremod.research.item1", (Object[])new Object[]{block.getName()}));
            tooltip.add((Component)Component.translatableEscape((String)"com.minecolonies.coremod.research.item2", (Object[])new Object[]{block.getName()}));
        }
    }

    @SubscribeEvent
    public static void onDebugOverlay(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        LocalPlayer player = mc.player;
        BlockPos pos = player.blockPosition();
        IColony colony = IColonyManager.getInstance().getIColony((Level)world, pos);
        if (colony == null) {
            if (IColonyManager.getInstance().isFarEnoughFromColonies((Level)world, pos)) {
                event.getLeft().add(Component.translatableEscape((String)"com.minecolonies.coremod.gui.debugscreen.noclosecolony", (Object[])new Object[0]).getString());
                return;
            }
            colony = IColonyManager.getInstance().getClosestIColony((Level)world, pos);
            if (colony == null) {
                return;
            }
            event.getLeft().add(Component.translatableEscape((String)"com.minecolonies.coremod.gui.debugscreen.nextcolony", (Object[])new Object[]{(int)Math.sqrt(colony.getDistanceSquared(pos)), IColonyManager.getInstance().getMinimumDistanceBetweenTownHalls()}).getString());
            return;
        }
        event.getLeft().add(colony.getName() + " : " + Component.translatableEscape((String)"com.minecolonies.coremod.gui.debugscreen.blocksfromcenter", (Object[])new Object[]{(int)Math.sqrt(colony.getDistanceSquared(pos))}).getString());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onUseItem(@NotNull PlayerInteractEvent.RightClickItem event) {
        Item item;
        if (!event.getLevel().isClientSide()) {
            return;
        }
        if (event.getHand() == InteractionHand.MAIN_HAND && (item = event.getItemStack().getItem()) instanceof BlockItem) {
            IBuildingBrowsableBlock browsable;
            BlockItem blockItem = (BlockItem)item;
            if (Minecraft.getInstance().hitResult != null && Minecraft.getInstance().hitResult.getType() != HitResult.Type.MISS) {
                return;
            }
            Block block = blockItem.getBlock();
            if (block instanceof IBuildingBrowsableBlock && (browsable = (IBuildingBrowsableBlock)block).shouldBrowseBuildings(event)) {
                MinecoloniesAPIProxy.getInstance().getBuildingDataManager().openBuildingBrowser(block);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

