/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.navigation;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveCloseToXNearY;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobRandomPos;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Mob;

public class EntityNavigationUtils {
    public static int BUILDING_REACH_DIST = 4;
    public static int WOKR_IN_BUILDING_DIST = 7;
    public static double REACHED_DIST = 1.5;

    public static boolean walkCloseToXNearY(AbstractFastMinecoloniesEntity entity, BlockPos desiredPosition, BlockPos nearbyPosition, int distToDesired, boolean safeDestination) {
        return EntityNavigationUtils.walkCloseToXNearY(entity, desiredPosition, nearbyPosition, distToDesired, safeDestination, 1.0);
    }

    public static boolean walkCloseToXNearY(AbstractFastMinecoloniesEntity entity, BlockPos desiredPosition, BlockPos nearbyPosition, int distToDesired, boolean safeDestination, double speedFactor) {
        boolean isOnRightTask;
        MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)entity.getNavigation();
        boolean bl = isOnRightTask = nav.getPathResult() != null && PathJobMoveCloseToXNearY.isJobFor(nav.getPathResult().getJob(), desiredPosition, nearbyPosition, 1);
        if (nav.isDone() || !isOnRightTask) {
            if (isOnRightTask) {
                if (BlockPosUtil.dist(entity.blockPosition(), desiredPosition) <= (double)distToDesired) {
                    nav.stop();
                    return true;
                }
            } else if (BlockPosUtil.dist(entity.blockPosition(), desiredPosition) <= REACHED_DIST) {
                nav.stop();
                return true;
            }
            nav.walkCloseToXNearY(desiredPosition, nearbyPosition, 1, speedFactor, safeDestination);
        }
        return false;
    }

    public static boolean walkToPosInBuilding(AbstractFastMinecoloniesEntity entity, BlockPos destination, IBuilding building, int reachDistance) {
        if (building == null) {
            return EntityNavigationUtils.walkToPos(entity, destination, reachDistance, true);
        }
        Tuple<BlockPos, BlockPos> corners = building.getCorners();
        BlockPos center = new BlockPos((((BlockPos)corners.getA()).getX() + ((BlockPos)corners.getB()).getX()) / 2, building.getPosition().getY(), (((BlockPos)corners.getA()).getZ() + ((BlockPos)corners.getB()).getZ()) / 2);
        return EntityNavigationUtils.walkCloseToXNearY(entity, destination, center, reachDistance, true);
    }

    public static boolean walkToBuilding(AbstractFastMinecoloniesEntity entity, IBuilding building) {
        if (building == null) {
            return true;
        }
        return EntityNavigationUtils.walkToPosInBuilding(entity, building.getPosition(), building, BUILDING_REACH_DIST);
    }

    public static boolean walkToPos(AbstractFastMinecoloniesEntity entity, BlockPos desiredPosition, boolean safeDestination) {
        return EntityNavigationUtils.walkToPos(entity, desiredPosition, BUILDING_REACH_DIST, safeDestination, 1.0);
    }

    public static boolean walkToPos(AbstractFastMinecoloniesEntity entity, BlockPos desiredPosition, int distToDesired, boolean safeDestination) {
        return EntityNavigationUtils.walkToPos(entity, desiredPosition, distToDesired, safeDestination, 1.0);
    }

    public static <T extends Mob> boolean walkToPos(T entity, BlockPos desiredPosition, int distToDesired, boolean safeDestination, double speedFactor) {
        boolean isOnRightTask;
        MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)entity.getNavigation();
        boolean bl = isOnRightTask = nav.getPathResult() != null && PathJobMoveToLocation.isJobFor(nav.getPathResult().getJob(), desiredPosition);
        if (nav.isDone() || !isOnRightTask) {
            if (isOnRightTask) {
                if (BlockPosUtil.dist(entity.blockPosition(), desiredPosition) <= (double)distToDesired) {
                    nav.stop();
                    return true;
                }
            } else if (BlockPosUtil.dist(entity.blockPosition(), desiredPosition) <= REACHED_DIST) {
                nav.stop();
                return true;
            }
            nav.walkTo(desiredPosition, speedFactor, safeDestination);
        }
        return false;
    }

    public static boolean walkAwayFrom(AbstractFastMinecoloniesEntity entity, BlockPos avoid, int distance, double speed) {
        boolean isOnRightTask;
        MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)entity.getNavigation();
        boolean bl = isOnRightTask = nav.getPathResult() != null && PathJobMoveAwayFromLocation.isJobFor(nav.getPathResult().getJob(), distance, avoid);
        if (nav.isDone() || !isOnRightTask) {
            if (isOnRightTask && BlockPosUtil.dist(entity.blockPosition(), avoid) >= (double)distance) {
                nav.stop();
                return true;
            }
            nav.walkAwayFrom(avoid, distance, speed, false);
        }
        return false;
    }

    public static boolean walkToRandomPos(AbstractFastMinecoloniesEntity entity, int range, double speedFactor) {
        boolean isOnRightTask;
        MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)entity.getNavigation();
        boolean bl = isOnRightTask = nav.getPathResult() != null && nav.getPathResult().getJob() instanceof PathJobRandomPos;
        if (nav.isDone() || !isOnRightTask) {
            if (isOnRightTask) {
                nav.stop();
                return true;
            }
            nav.walkToRandomPos(range, speedFactor);
        }
        return false;
    }

    public static boolean walkToRandomPosWithin(AbstractFastMinecoloniesEntity entity, int range, double speedFactor, Tuple<BlockPos, BlockPos> corners, boolean preferInside) {
        boolean isOnRightTask;
        MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)entity.getNavigation();
        boolean bl = isOnRightTask = nav.getPathResult() != null && nav.getPathResult().getJob() instanceof PathJobRandomPos;
        if (nav.isDone() || !isOnRightTask) {
            if (isOnRightTask) {
                nav.stop();
                return true;
            }
            nav.walkToRandomPos(range, speedFactor, corners, preferInside);
        }
        return false;
    }

    public static boolean walkToRandomPosWithin(AbstractFastMinecoloniesEntity entity, int range, double speedFactor, Tuple<BlockPos, BlockPos> corners) {
        return EntityNavigationUtils.walkToRandomPosWithin(entity, range, speedFactor, corners, false);
    }

    public static boolean walkToRandomPosAround(AbstractFastMinecoloniesEntity entity, BlockPos center, int range, double speedFactor) {
        MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)entity.getNavigation();
        return EntityNavigationUtils.walkToRandomPosHelper(nav, center, range, speedFactor);
    }

    public static <T extends Mob> boolean walkToRandomPosAround(T entity, BlockPos center, int range, double speedFactor) {
        MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)entity.getNavigation();
        return EntityNavigationUtils.walkToRandomPosHelper(nav, center, range, speedFactor);
    }

    protected static boolean walkToRandomPosHelper(MinecoloniesAdvancedPathNavigate nav, BlockPos center, int range, double speedFactor) {
        boolean isOnRightTask;
        boolean bl = isOnRightTask = nav.getPathResult() != null && PathJobRandomPos.isJobFor(nav.getPathResult().getJob(), center, range);
        if (nav.isDone() || !isOnRightTask) {
            if (isOnRightTask) {
                nav.stop();
                return true;
            }
            nav.walkToRandomPosAround(range, speedFactor, center);
        }
        return false;
    }
}

