/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.util;

import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.core.blocks.decorative.BlockConstructionTape;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstructionTapeHelper {
    private ConstructionTapeHelper() {
    }

    public static void placeConstructionTape(@NotNull IWorkOrder workOrder, @NotNull Level world, IColony colony) {
        AABB box = workOrder.getBoundingBox();
        if (box != null && box != Constants.EMPTY_AABB) {
            ConstructionTapeHelper.placeConstructionTape(ColonyUtils.calculateCorners(box), colony);
        }
    }

    public static void placeConstructionTape(@NotNull IBuilding building) {
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData((Future)StructurePacks.getBlueprintFuture((String)building.getStructurePack(), (String)building.getBlueprintPath(), (HolderLookup.Provider)building.getColony().getWorld().registryAccess()), building.getColony().getWorld(), blueprint -> {
            Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(building.getPosition(), building.getColony().getWorld(), blueprint, building.getRotationMirror());
            building.setCorners((BlockPos)corners.getA(), (BlockPos)corners.getB());
            ConstructionTapeHelper.placeConstructionTape(corners, building.getColony());
        }));
    }

    public static void placeConstructionTape(Tuple<BlockPos, BlockPos> orgCorners, IColony colony) {
        BlockPos working;
        if (colony instanceof Colony && !((Colony)colony).getSettings().getSetting(BuildingTownHall.CONSTRUCTION_TAPE).getValue().booleanValue()) {
            return;
        }
        Level world = colony.getWorld();
        Tuple corners = new Tuple((Object)((BlockPos)orgCorners.getA()).offset(-1, 0, -1), (Object)((BlockPos)orgCorners.getB()).offset(1, 0, 1));
        BlockState constructionTape = ModBlocks.blockConstructionTape.defaultBlockState();
        int x = Math.min(((BlockPos)corners.getA()).getX(), ((BlockPos)corners.getB()).getX());
        int y = Math.max(((BlockPos)corners.getA()).getY(), ((BlockPos)corners.getB()).getY());
        int z = Math.min(((BlockPos)corners.getA()).getZ(), ((BlockPos)corners.getB()).getZ());
        int sizeX = Math.abs(((BlockPos)corners.getA()).getX() - ((BlockPos)corners.getB()).getX());
        int sizeZ = Math.abs(((BlockPos)corners.getA()).getZ() - ((BlockPos)corners.getB()).getZ());
        int sizeY = Math.abs(((BlockPos)corners.getA()).getY() - ((BlockPos)corners.getB()).getY());
        BlockPos place = new BlockPos(x, y, z);
        while (place.getX() < x + sizeX || place.getZ() < z + sizeZ) {
            if (place.getX() < x + sizeX) {
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(place.getX(), y, z), world, sizeY);
                if (working != null) {
                    world.setBlockAndUpdate(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.setValue((Property)BlockConstructionTape.CORNER, (Comparable)Boolean.valueOf(place.getX() == x)), (BlockGetter)world, working, Direction.SOUTH));
                }
                if ((working = ConstructionTapeHelper.firstValidPosition(new BlockPos(place.getX(), y, z + sizeZ), world, sizeY)) != null) {
                    world.setBlockAndUpdate(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.setValue((Property)BlockConstructionTape.CORNER, (Comparable)Boolean.valueOf(place.getX() == x)), (BlockGetter)world, working, Direction.NORTH));
                }
            }
            if (place.getZ() < z + sizeZ) {
                working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x, y, place.getZ()), world, sizeY);
                if (working != null) {
                    world.setBlockAndUpdate(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.setValue((Property)BlockConstructionTape.CORNER, (Comparable)Boolean.valueOf(place.getZ() == z)), (BlockGetter)world, working, Direction.EAST));
                }
                if ((working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x + sizeX, y, place.getZ()), world, sizeY)) != null) {
                    world.setBlockAndUpdate(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.setValue((Property)BlockConstructionTape.CORNER, (Comparable)Boolean.valueOf(place.getZ() == z)), (BlockGetter)world, working, place.getZ() == z ? Direction.SOUTH : Direction.WEST));
                }
            }
            place = place.south().east();
        }
        working = ConstructionTapeHelper.firstValidPosition(new BlockPos(x + sizeX, y, z + sizeZ), world, sizeY);
        if (working != null) {
            world.setBlockAndUpdate(working, BlockConstructionTape.getPlacementState((BlockState)constructionTape.setValue((Property)BlockConstructionTape.CORNER, (Comparable)Boolean.valueOf(true)), (BlockGetter)world, working, Direction.WEST));
        }
    }

    @Nullable
    public static BlockPos firstValidPosition(@NotNull BlockPos target, @NotNull Level world, int height) {
        for (int i = 0; i <= height + 5; ++i) {
            BlockPos tempTarget = new BlockPos(target.getX(), target.getY() - i, target.getZ());
            BlockState state = world.getBlockState(tempTarget);
            BlockState upState = world.getBlockState(tempTarget.above());
            if (!state.isSolid() || upState.isSolid() || !upState.canBeReplaced() && !upState.isAir()) continue;
            return tempTarget.above();
        }
        return null;
    }

    public static void removeConstructionTape(@NotNull IWorkOrder workOrder, @NotNull Level world) {
        AABB box = workOrder.getBoundingBox();
        if (box != null && box != Constants.EMPTY_AABB) {
            ConstructionTapeHelper.removeConstructionTape(ColonyUtils.calculateCorners(box), world);
        }
    }

    public static void removeConstructionTape(Tuple<BlockPos, BlockPos> orgCorners, @NotNull Level world) {
        BlockPos block2;
        BlockPos block1;
        int i;
        Tuple corners = new Tuple((Object)((BlockPos)orgCorners.getA()).offset(-1, 0, -1), (Object)((BlockPos)orgCorners.getB()).offset(1, 0, 1));
        int x1 = ((BlockPos)corners.getA()).getX();
        int x3 = ((BlockPos)corners.getB()).getX();
        int z1 = ((BlockPos)corners.getA()).getZ();
        int z3 = ((BlockPos)corners.getB()).getZ();
        int minHeight = Math.min(((BlockPos)corners.getB()).getY(), ((BlockPos)corners.getA()).getY()) - 5;
        int maxHeight = Math.max(((BlockPos)corners.getB()).getY(), ((BlockPos)corners.getA()).getY()) + 1;
        if (x1 < x3) {
            for (i = x1; i <= x3; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        } else {
            for (i = x3; i <= x1; ++i) {
                block1 = new BlockPos(i, 0, z1);
                block2 = new BlockPos(i, 0, z3);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        }
        if (z1 < z3) {
            for (i = z1; i <= z3; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        } else {
            for (i = z3; i <= z1; ++i) {
                block1 = new BlockPos(x1, 0, i);
                block2 = new BlockPos(x3, 0, i);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
                ConstructionTapeHelper.removeTapeIfNecessary(world, block2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
            }
        }
        BlockPos corner1 = new BlockPos(x1, 0, z1);
        BlockPos corner2 = new BlockPos(x1, 0, z3);
        BlockPos corner3 = new BlockPos(x3, 0, z1);
        BlockPos corner4 = new BlockPos(x3, 0, z3);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner1, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner2, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner3, ModBlocks.blockConstructionTape, minHeight, maxHeight);
        ConstructionTapeHelper.removeTapeIfNecessary(world, corner4, ModBlocks.blockConstructionTape, minHeight, maxHeight);
    }

    public static void removeTapeIfNecessary(@NotNull Level world, @NotNull BlockPos block, @NotNull Block tapeOrTapeCorner, int minHeight, int maxHeight) {
        for (int y = minHeight; y <= maxHeight; ++y) {
            BlockPos newBlock = new BlockPos(block.getX(), y, block.getZ());
            if (world.getBlockState(newBlock).getBlock() != tapeOrTapeCorner) continue;
            world.removeBlock(newBlock, false);
            break;
        }
    }
}

