/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.DeepMineTrigger;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobMiner;
import com.minecolonies.core.colony.workorders.WorkOrderMiner;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import com.minecolonies.core.entity.ai.workers.util.BuildingStructureHandler;
import com.minecolonies.core.entity.ai.workers.util.MineNode;
import com.minecolonies.core.entity.ai.workers.util.MinerLevel;
import com.minecolonies.core.util.AdvancementUtils;
import com.minecolonies.core.util.WorkerUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureMiner
extends AbstractEntityAIStructureWithWorkOrder<JobMiner, BuildingMiner> {
    public static final LootContextParamSet LUCKY_ORE_PARAM_SET = new LootContextParamSet.Builder().required(LootContextParams.ORIGIN).required(LootContextParams.THIS_ENTITY).required(LootContextParams.TOOL).build();
    public static final ResourceLocation LUCKY_ORE_LOOT_TABLE = new ResourceLocation("minecolonies", "miner/lucky_ore");
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private static final int COBBLE_REQUEST_BATCHES = 32;
    private static final int LADDER_REQUEST_BATCHES = 10;
    public static final String RENDER_META_TORCH = "torch";
    public static final String RENDER_META_STONE = "stone";
    public static final String RENDER_META_SHOVEL = "shovel";
    public static final String RENDER_META_PICKAXE = "pickaxe";
    private static final int NODE_DISTANCE = 7;
    private static final int MAX_BLOCKS_MINED = 64;
    public static final int SHAFT_RADIUS = 3;
    private static final int SAFE_CHECK_RANGE = 5;
    private static final int SHAFT_BASE_DEPTH = 8;
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int ROTATE_FOUR_TIMES = 4;
    private static final int LIQUID_CHECK_RANGE = 5;
    private static final VisibleCitizenStatus MINING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/miner.png"), "com.minecolonies.gui.visiblestatus.miner");
    @Nullable
    private BlockPos minerWorkingLocation;
    @Nullable
    private BlockPos currentStandingPosition;
    @Nullable
    private MineNode workingNode = null;

    public EntityAIStructureMiner(@NotNull JobMiner job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.PREPARING, AIWorkerState.MINER_CHECK_MINESHAFT, 1), new AITarget<Object>(AIWorkerState.MINER_WALKING_TO_LADDER, this::goToLadder, 20), new AITarget<Object>(AIWorkerState.MINER_REPAIRING_LADDER, this::repairLadder, 5), new AITarget<Object>(AIWorkerState.MINER_CHECK_MINESHAFT, this::checkMineShaft, 20), new AITarget<Object>(AIWorkerState.MINER_MINING_SHAFT, this::doShaftMining, 5), new AITarget<Object>(AIWorkerState.MINER_BUILDING_SHAFT, this::doShaftBuilding, 5), new AITarget<Object>(AIWorkerState.MINER_MINING_NODE, this::executeNodeMining, 5));
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    public Class<BuildingMiner> getExpectedBuildingClass() {
        return BuildingMiner.class;
    }

    @Override
    @NotNull
    protected IAIState startWorkingAtOwnBuilding() {
        List<WorkOrderMiner> list;
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if ((((BuildingMiner)this.building).getLadderLocation() == null || this.worker.getY() >= (double)((BuildingMiner)this.building).getPosition().getY()) && !this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((BuildingMiner)this.building).getLadderLocation() == null || ((BuildingMiner)this.building).getCobbleLocation() == null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"entity.miner.invalidmineshaft", (Object[])new Object[0]), ChatPriority.BLOCKING));
            return AIWorkerState.START_WORKING;
        }
        if (!((BuildingMiner)this.building).hasWorkOrder() && !(list = ((BuildingMiner)this.building).getColony().getWorkManager().getOrderedList(WorkOrderMiner.class, ((BuildingMiner)this.building).getPosition())).isEmpty()) {
            ((BuildingMiner)this.building).setWorkOrder(list.get(0));
            return AIWorkerState.LOAD_STRUCTURE;
        }
        IAIState nextState = super.startWorkingAtOwnBuilding();
        if (nextState != AIWorkerState.IDLE) {
            return nextState;
        }
        return AIWorkerState.PREPARING;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return ((BuildingMiner)this.building).getBuildingLevel() * 64;
    }

    @Override
    protected void updateRenderMetaData() {
        StringBuilder renderData = new StringBuilder(this.getState() == AIWorkerState.MINER_MINING_SHAFT || this.getState() == AIWorkerState.MINE_BLOCK || this.getState() == AIWorkerState.BUILDING_STEP ? "working" : "");
        ItemStack block = new ItemStack((ItemLike)this.getMainFillBlock());
        for (int slot = 0; slot < this.worker.getInventoryCitizen().getSlots(); ++slot) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            if (stack.getItem() == Items.TORCH && renderData.indexOf(RENDER_META_TORCH) == -1) {
                renderData.append(RENDER_META_TORCH);
                continue;
            }
            if (stack.getItem() == block.getItem() && renderData.indexOf(RENDER_META_STONE) == -1) {
                renderData.append(RENDER_META_STONE);
                continue;
            }
            if (stack.canPerformAction(ItemAbilities.PICKAXE_DIG) && renderData.indexOf(RENDER_META_PICKAXE) == -1) {
                renderData.append(RENDER_META_PICKAXE);
                continue;
            }
            if (!stack.canPerformAction(ItemAbilities.SHOVEL_DIG) || renderData.indexOf(RENDER_META_SHOVEL) != -1) continue;
            renderData.append(RENDER_META_SHOVEL);
        }
        this.worker.setRenderMetadata(renderData.toString());
    }

    @Override
    public IAIState doMining() {
        if (this.blockToMine == null) {
            return AIWorkerState.BUILDING_STEP;
        }
        BlockState blockState = this.world.getBlockState(this.blockToMine);
        if (!IColonyManager.getInstance().getCompatibilityManager().isOre(blockState)) {
            this.blockToMine = this.getSurroundingOreOrDefault(this.blockToMine);
        }
        if (this.world.getBlockState(this.blockToMine).getBlock() instanceof AirBlock) {
            return AIWorkerState.BUILDING_STEP;
        }
        if (!this.mineBlock(this.blockToMine, this.getCurrentWorkingPosition())) {
            this.worker.swing(InteractionHand.MAIN_HAND);
            return this.getState();
        }
        this.blockToMine = this.getSurroundingOreOrDefault(this.blockToMine);
        if (IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.getBlockState(this.blockToMine))) {
            return this.getState();
        }
        this.worker.decreaseSaturationForContinuousAction();
        return AIWorkerState.BUILDING_STEP;
    }

    @Override
    public boolean shouldSilkTouchBlock(BlockState curBlockState) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(curBlockState);
    }

    private BlockPos getSurroundingOreOrDefault(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.relative(direction);
            if (!IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.getBlockState(offset))) continue;
            return offset;
        }
        return pos;
    }

    @NotNull
    private IAIState goToLadder() {
        if (!this.walkToLadder()) {
            return AIWorkerState.MINER_WALKING_TO_LADDER;
        }
        return AIWorkerState.MINER_REPAIRING_LADDER;
    }

    private boolean walkToLadder() {
        return this.walkToWorkPos(((BuildingMiner)this.building).getLadderLocation());
    }

    @Override
    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition(currentBlock);
        }
        return this.walkWithProxy(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.blockPosition(), this.workFrom) < 12.0;
    }

    @NotNull
    private IAIState repairLadder() {
        @NotNull BlockPos nextCobble = new BlockPos(((BuildingMiner)this.building).getCobbleLocation().getX(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), (Level)this.world) - 1, ((BuildingMiner)this.building).getCobbleLocation().getZ());
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.building).getLadderLocation().getX(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), (Level)this.world) - 1, ((BuildingMiner)this.building).getLadderLocation().getZ());
        @NotNull BlockPos safeStand = new BlockPos(((BuildingMiner)this.building).getLadderLocation().getX(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), (Level)this.world), ((BuildingMiner)this.building).getLadderLocation().getZ());
        if (!this.world.getBlockState(nextCobble).isSolid()) {
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)this.getSolidSubstitution(nextCobble, pos -> null).getBlock()), 32, 1)) {
                return this.getState();
            }
            if (!this.world.getBlockState(nextCobble).isAir() && !this.mineBlock(nextCobble, safeStand)) {
                return this.getState();
            }
            this.setBlockFromInventory(nextCobble, this.getLadderBackFillBlock());
            return this.getState();
        }
        if (!this.world.getBlockState(nextLadder).isLadder((LevelReader)this.world, nextLadder, (LivingEntity)this.worker) && !this.world.getBlockState(nextLadder).isSolid()) {
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)Blocks.LADDER), 10, 1)) {
                return this.getState();
            }
            if (!this.world.getBlockState(nextLadder).isAir() && !this.mineBlock(nextLadder, safeStand)) {
                return this.getState();
            }
            BlockState metadata = (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)BlockPosUtil.directionFromDelta(nextLadder.getX() - nextCobble.getX(), 0, nextLadder.getZ() - nextCobble.getZ()));
            this.setBlockFromInventory(nextLadder, Blocks.LADDER, metadata);
            return this.getState();
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private Block getMainFillBlock() {
        return ((BuildingMiner)this.building).getSetting(BuildingMiner.FILL_BLOCK).getValue().getBlock();
    }

    private Block getLadderBackFillBlock() {
        if (WorldUtil.isNetherType((Level)this.world)) {
            return Blocks.NETHERRACK;
        }
        return Blocks.COBBLESTONE;
    }

    @NotNull
    private IAIState checkMineShaft() {
        BuildingMiner buildingMiner = (BuildingMiner)this.building;
        if (WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), (Level)this.world) < this.world.getMinBuildHeight() + 8) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(((JobMiner)this.job).getColony(), ((DeepMineTrigger)((Object)AdvancementTriggers.DEEP_MINE.get()))::trigger);
        }
        if (WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), (Level)this.world) < buildingMiner.getDepthLimit((Level)this.world)) {
            if (((MinerLevelManagementModule)buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class)).getNumberOfLevels() == 0) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"entity.miner.messagerequiresbetterhut", (Object[])new Object[0]), ChatPriority.BLOCKING));
                return AIWorkerState.IDLE;
            }
            this.worker.getCitizenData().setVisibleStatus(MINING);
            return AIWorkerState.MINER_MINING_NODE;
        }
        this.worker.getCitizenData().setVisibleStatus(MINING);
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    @Override
    public ItemStack getTotalAmount(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return null;
        }
        ItemStack copy = stack.copy();
        copy.setCount(Math.max(super.getTotalAmount(stack).getCount(), copy.getMaxStackSize() / 2));
        return copy;
    }

    private IAIState doShaftMining() {
        this.minerWorkingLocation = this.getNextBlockInShaftToMine();
        if (this.minerWorkingLocation == null) {
            return this.advanceLadder(AIWorkerState.MINER_MINING_SHAFT);
        }
        if (this.mineBlock(this.minerWorkingLocation, this.currentStandingPosition)) {
            this.worker.decreaseSaturationForContinuousAction();
        }
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    private IAIState advanceLadder(IAIState state) {
        if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)this.getLadderBackFillBlock()), 32, 1) || !this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)Blocks.LADDER), 10, 1)) {
            return state;
        }
        if (this.ladderDamaged()) {
            return AIWorkerState.MINER_REPAIRING_LADDER;
        }
        BlockPos vector = ((BuildingMiner)this.building).getLadderLocation().subtract((Vec3i)((BuildingMiner)this.building).getCobbleLocation());
        int xOffset = 3 * vector.getX();
        int zOffset = 3 * vector.getZ();
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.building).getLadderLocation().getX(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), (Level)this.world) - 1, ((BuildingMiner)this.building).getLadderLocation().getZ());
        @NotNull BlockPos safeCobble = new BlockPos(((BuildingMiner)this.building).getLadderLocation().getX(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), (Level)this.world) - 2, ((BuildingMiner)this.building).getLadderLocation().getZ());
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                @NotNull BlockPos curBlock = new BlockPos(safeCobble.getX() + x + xOffset, safeCobble.getY(), safeCobble.getZ() + z + zOffset);
                if (this.secureBlock(curBlock, this.currentStandingPosition)) continue;
                return state;
            }
        }
        @NotNull BlockPos safeStand = new BlockPos(((BuildingMiner)this.building).getLadderLocation().getX(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), (Level)this.world), ((BuildingMiner)this.building).getLadderLocation().getZ());
        @NotNull BlockPos nextCobble = new BlockPos(((BuildingMiner)this.building).getCobbleLocation().getX(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), (Level)this.world) - 1, ((BuildingMiner)this.building).getCobbleLocation().getZ());
        MinerLevelManagementModule module = (MinerLevelManagementModule)((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (module.getStartingLevelShaft() == 0) {
            module.setStartingLevelShaft(nextCobble.getY() - 4);
        }
        if (nextCobble.getY() < module.getStartingLevelShaft()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        if (!this.world.getBlockState(nextCobble).canBeReplaced() && !this.mineBlock(nextCobble, safeStand) || !this.world.getBlockState(nextLadder).canBeReplaced() && !this.mineBlock(nextLadder, safeStand)) {
            return state;
        }
        BlockState metadata = this.getBlockState(safeStand);
        this.setBlockFromInventory(nextCobble, this.getLadderBackFillBlock());
        this.setBlockFromInventory(nextLadder, Blocks.LADDER, metadata);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private BlockState getBlockState(@NotNull BlockPos pos) {
        return this.world.getBlockState(pos);
    }

    @Nullable
    private BlockPos getNextBlockInShaftToMine() {
        double distance;
        BlockPos curBlock;
        int z;
        int x;
        BlockState block;
        BlockPos ladderPos = ((BuildingMiner)this.building).getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, (Level)this.world);
        if (this.minerWorkingLocation == null) {
            this.minerWorkingLocation = new BlockPos(ladderPos.getX(), lastLadder + 1, ladderPos.getZ());
        }
        if (!(block = this.getBlockState(this.minerWorkingLocation)).isAir() && block.getBlock() != Blocks.LADDER && block.getFluidState().isEmpty()) {
            if (this.currentStandingPosition == null) {
                this.currentStandingPosition = this.minerWorkingLocation;
            }
            return this.minerWorkingLocation;
        }
        this.currentStandingPosition = this.minerWorkingLocation;
        BlockPos nextBlockToMine = null;
        double bestDistance = Double.MAX_VALUE;
        BlockPos vector = ((BuildingMiner)this.building).getLadderLocation().subtract((Vec3i)((BuildingMiner)this.building).getCobbleLocation());
        int xOffset = 3 * vector.getX();
        int zOffset = 3 * vector.getZ();
        for (x = 3 + xOffset + 2; x >= -3 + xOffset - 2; --x) {
            for (z = -3 + zOffset - 2; z <= 3 + zOffset + 2; ++z) {
                if (x == 0 && 0 == z || (block = this.getBlockState(curBlock = new BlockPos(ladderPos.getX() + x, lastLadder, ladderPos.getZ() + z))).getFluidState().isEmpty()) continue;
                BlockUtils.removeFluid((Level)this.world, (BlockPos)curBlock);
                this.setBlockFromInventory(curBlock, this.getMainFillBlock());
            }
        }
        for (x = 3 + xOffset; x >= -3 + xOffset; --x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                curBlock = new BlockPos(ladderPos.getX() + x, lastLadder, ladderPos.getZ() + z);
                distance = curBlock.distSqr((Vec3i)ladderPos) + Math.pow(curBlock.distSqr((Vec3i)this.minerWorkingLocation), 2.0);
                block = this.getBlockState(curBlock);
                if (!(distance < bestDistance) || this.world.isEmptyBlock(curBlock)) continue;
                if (!block.getFluidState().isEmpty()) {
                    BlockUtils.removeFluid((Level)this.world, (BlockPos)curBlock);
                    this.setBlockFromInventory(curBlock, this.getMainFillBlock());
                }
                nextBlockToMine = curBlock;
                bestDistance = distance;
            }
        }
        bestDistance = Double.MAX_VALUE;
        if (nextBlockToMine != null) {
            for (x = 1; x >= -1; --x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && 0 == z || !((distance = (curBlock = new BlockPos(nextBlockToMine.getX() + x, lastLadder, nextBlockToMine.getZ() + z)).distSqr((Vec3i)ladderPos)) < bestDistance) || !this.world.isEmptyBlock(curBlock)) continue;
                    this.currentStandingPosition = curBlock;
                    bestDistance = distance;
                }
            }
        }
        return nextBlockToMine;
    }

    @NotNull
    private IAIState doShaftBuilding() {
        if (!this.walkToBuilding()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        BlockPos ladderPos = ((BuildingMiner)this.building).getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, (Level)this.world) + 1;
        BlockPos vector = ladderPos.subtract((Vec3i)((BuildingMiner)this.building).getCobbleLocation());
        int xOffset = 3 * vector.getX();
        int zOffset = 3 * vector.getZ();
        BuildingMiner.initStructure(null, new BlockPos(ladderPos.getX() + xOffset, lastLadder + 1, ladderPos.getZ() + zOffset), (BuildingMiner)this.building, (Level)this.world, (JobMiner)this.job);
        return AIWorkerState.LOAD_STRUCTURE;
    }

    @NotNull
    private IAIState executeNodeMining() {
        MinerLevelManagementModule module = (MinerLevelManagementModule)((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class);
        @Nullable MinerLevel currentLevel = module.getCurrentLevel();
        if (currentLevel == null) {
            module.setCurrentLevel(module.getNumberOfLevels() - 1);
            return this.executeNodeMining();
        }
        return this.searchANodeToMine(currentLevel);
    }

    private IAIState searchANodeToMine(@NotNull MinerLevel currentLevel) {
        BlockPos standingPosition;
        int vectorZ;
        BuildingMiner buildingMiner = (BuildingMiner)this.building;
        if (buildingMiner == null) {
            return AIWorkerState.IDLE;
        }
        MinerLevelManagementModule module = (MinerLevelManagementModule)((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (this.workingNode == null || this.workingNode.getStatus() == MineNode.NodeStatus.COMPLETED) {
            int levelId;
            this.workingNode = module.getActiveNode();
            module.setActiveNode(this.workingNode);
            if (this.workingNode == null && (levelId = module.getLevelId(currentLevel)) > 0) {
                module.setCurrentLevel(levelId - 1);
            }
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        RotationMirror rotMir = RotationMirror.NONE;
        int workingNodeX = this.workingNode.getX() > this.workingNode.getParent().getX() ? 1 : 0;
        int workingNodeZ = this.workingNode.getZ() > this.workingNode.getParent().getZ() ? 1 : 0;
        int vectorX = this.workingNode.getX() < this.workingNode.getParent().getX() ? -1 : workingNodeX;
        int n = vectorZ = this.workingNode.getZ() < this.workingNode.getParent().getZ() ? -1 : workingNodeZ;
        if (vectorX == -1) {
            rotMir = RotationMirror.R180;
        } else if (vectorZ == -1) {
            rotMir = RotationMirror.R270;
        } else if (vectorZ == 1) {
            rotMir = RotationMirror.R90;
        }
        MineNode parentNode = currentLevel.getNode(this.workingNode.getParent());
        if (parentNode != null && parentNode.getStyle() != MineNode.NodeType.SHAFT && parentNode.getStatus() != MineNode.NodeStatus.COMPLETED) {
            this.workingNode = parentNode;
            this.workingNode.setStatus(MineNode.NodeStatus.AVAILABLE);
            module.setActiveNode(parentNode);
            buildingMiner.markDirty();
            if (this.workingNode.getRotationMirror().isPresent() && this.workingNode.getRotationMirror().get() != rotMir) {
                Log.getLogger().warn("Calculated rotation doesn't match recorded: x:" + workingNodeX + " z:" + workingNodeZ + " at: " + ((BuildingMiner)this.building).getColony().getID());
            }
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        this.currentStandingPosition = standingPosition = new BlockPos(this.workingNode.getParent().getX(), currentLevel.getDepth(), this.workingNode.getParent().getZ());
        if (this.workingNode != null && currentLevel.getNode(new Vec2i(this.workingNode.getX(), this.workingNode.getZ())) == null) {
            module.setActiveNode(null);
            module.setOldNode(null);
            return AIWorkerState.MINER_MINING_SHAFT;
        }
        if (!(this.workingNode.getStatus() != MineNode.NodeStatus.AVAILABLE && this.workingNode.getStatus() != MineNode.NodeStatus.IN_PROGRESS || this.walkWithProxy(standingPosition))) {
            this.workingNode.setRotationMirror(rotMir);
            return this.executeStructurePlacement(this.workingNode, standingPosition);
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private boolean secureBlock(@NotNull BlockPos curBlock, @NotNull BlockPos safeStand) {
        BlockState stateAtPos = this.getBlockState(curBlock);
        if (!stateAtPos.blocksMotion() && this.getBlock(curBlock) != Blocks.TORCH || !stateAtPos.getFluidState().isEmpty() || IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.getBlockState(curBlock))) {
            if (!this.mineBlock(curBlock, safeStand)) {
                this.setDelay(1);
                return false;
            }
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((ItemLike)this.getMainFillBlock()), 32, 1)) {
                return false;
            }
            this.setBlockFromInventory(curBlock, this.getMainFillBlock());
            return false;
        }
        return true;
    }

    private IAIState executeStructurePlacement(@NotNull MineNode mineNode, @NotNull BlockPos standingPosition) {
        mineNode.setStatus(MineNode.NodeStatus.IN_PROGRESS);
        ((BuildingMiner)this.building).markDirty();
        if (((BuildingMiner)this.building).getWorkOrder() == null || ((BuildingMiner)this.building).getWorkOrder().getBlueprint() == null) {
            BuildingMiner.initStructure(mineNode, new BlockPos(mineNode.getX(), ((MinerLevelManagementModule)((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class)).getCurrentLevel().getDepth(), mineNode.getZ()), (BuildingMiner)this.building, (Level)this.world, (JobMiner)this.job);
            return AIWorkerState.LOAD_STRUCTURE;
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = -1; y <= 5; ++y) {
                    @NotNull BlockPos curBlock = new BlockPos(mineNode.getX() + x, standingPosition.getY() + y, mineNode.getZ() + z);
                    BlockState block = this.getBlockState(curBlock);
                    if (!block.getFluidState().isSource()) continue;
                    BlockUtils.removeFluid((Level)this.world, (BlockPos)curBlock);
                    this.setBlockFromInventory(curBlock, this.getMainFillBlock());
                }
            }
        }
        this.workingNode = null;
        if (((BuildingMiner)this.building).getWorkOrder().getBlueprint() != null) {
            return AIWorkerState.LOAD_STRUCTURE;
        }
        return AIWorkerState.MINER_MINING_NODE;
    }

    @Override
    public IAIState afterStructureLoading() {
        return AIWorkerState.BUILDING_STEP;
    }

    private void setBlockFromInventory(@NotNull BlockPos location, @NotNull Block block) {
        this.worker.swing(this.worker.getUsedItemHand());
        this.setBlockFromInventory(location, block, block.defaultBlockState());
    }

    private void setBlockFromInventory(@NotNull BlockPos location, Block block, BlockState metadata) {
        int slot = block instanceof LadderBlock ? this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block) : this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block);
        if (slot != -1 && WorldUtil.setBlockState((LevelAccessor)this.world, location, metadata)) {
            this.getInventory().extractItem(slot, 1, false);
        }
    }

    private Block getBlock(@NotNull BlockPos loc) {
        return this.world.getBlockState(loc).getBlock();
    }

    @Override
    public void executeSpecificCompleteActions() {
        BuildingMiner minerBuilding = (BuildingMiner)this.building;
        MinerLevelManagementModule module = (MinerLevelManagementModule)((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (((BuildingMiner)this.building).getWorkOrder() != null && ((BuildingMiner)this.building).getWorkOrder().getBlueprint() != null) {
            if (((BuildingMiner)this.building).getWorkOrder().getBlueprint().getFileName().contains("minermainshaft")) {
                int depth = ((BuildingMiner)this.building).getWorkOrder().getLocation().getY();
                boolean exists = false;
                for (MinerLevel level : module.getLevels()) {
                    if (level.getDepth() != depth) continue;
                    exists = true;
                    break;
                }
                @Nullable BlockPos levelSignPos = WorkerUtil.findFirstLevelSign(((BuildingMiner)this.building).getWorkOrder().getBlueprint(), ((BuildingMiner)this.building).getWorkOrder().getLocation(), this.worker.level());
                @NotNull MinerLevel currentLevel = new MinerLevel(minerBuilding, ((BuildingMiner)this.building).getWorkOrder().getLocation().getY(), levelSignPos);
                if (!exists) {
                    module.addLevel(currentLevel);
                    module.setCurrentLevel(module.getNumberOfLevels());
                }
                WorkerUtil.updateLevelSign((Level)this.world, currentLevel, module.getLevelId(currentLevel));
            } else {
                MinerLevel currentLevel = module.getCurrentLevel();
                if (currentLevel == null) {
                    Log.getLogger().error("The mine state of the mine at: " + ((BuildingMiner)this.building).getID().toShortString() + " got corrupted. Trying to recover from this somehow....");
                } else {
                    currentLevel.closeNextNode(((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getRotationMirror(), module.getActiveNode(), (Level)this.world);
                    module.setActiveNode(null);
                    module.setOldNode(this.workingNode);
                    WorkerUtil.updateLevelSign((Level)this.world, currentLevel, module.getLevelId(currentLevel));
                }
            }
        }
        super.executeSpecificCompleteActions();
        ((BuildingMiner)this.building).markDirty();
        if (((BuildingMiner)this.building).getWorkOrder() != null) {
            ((BuildingMiner)this.building).getWorkOrder().clearBlueprint();
        }
    }

    @Override
    public void onBlockDropReception(List<ItemStack> blockDrops) {
        super.onBlockDropReception(blockDrops);
        for (ItemStack stack : blockDrops) {
            ((BuildingMiner)this.building).getModule(BuildingModules.STATS_MODULE).incrementBy("item_obtained;" + stack.getItem().getDescriptionId(), stack.getCount());
        }
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getNodeMiningPosition(targetPosition);
    }

    private BlockPos getNodeMiningPosition(BlockPos blockToMine) {
        BuildingMiner buildingMiner = (BuildingMiner)this.building;
        MinerLevelManagementModule module = (MinerLevelManagementModule)buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (module.getCurrentLevel() == null || module.getActiveNode() == null) {
            return blockToMine;
        }
        Vec2i parentPos = module.getActiveNode().getParent();
        BlockPos vector = ((BuildingMiner)this.building).getLadderLocation().subtract((Vec3i)((BuildingMiner)this.building).getCobbleLocation());
        if (parentPos != null && module.getCurrentLevel().getNode(parentPos) != null && module.getCurrentLevel().getNode(parentPos).getStyle() == MineNode.NodeType.SHAFT) {
            BlockPos ladderPos = buildingMiner.getLadderLocation();
            return new BlockPos(ladderPos.getX() + vector.getX() * 6, module.getCurrentLevel().getDepth(), ladderPos.getZ() + vector.getZ() * 6);
        }
        Vec2i pos = module.getActiveNode().getParent();
        return new BlockPos(pos.getX(), module.getCurrentLevel().getDepth(), pos.getZ());
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(worldMetadata);
    }

    @Override
    protected void triggerMinedBlock(@NotNull BlockPos position, @NotNull BlockState blockToMine) {
        super.triggerMinedBlock(position, blockToMine);
        if (IColonyManager.getInstance().getCompatibilityManager().isLuckyBlock(blockToMine.getBlock())) {
            boolean canGetLuckyBlock;
            double chance = 1.0 + this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MORE_ORES);
            boolean bl = canGetLuckyBlock = this.worker.getRandom().nextDouble() * 100.0 <= (double)((Integer)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).luckyBlockChance.get()).intValue() * chance;
            if (canGetLuckyBlock) {
                ResourceKey lootTableId = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LUCKY_ORE_LOOT_TABLE.withSuffix(String.valueOf(((BuildingMiner)this.building).getBuildingLevel())));
                LootParams lootParams = new LootParams.Builder(this.world).withParameter(LootContextParams.ORIGIN, (Object)position.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)this.worker).withParameter(LootContextParams.TOOL, (Object)this.worker.getMainHandItem()).create(LUCKY_ORE_PARAM_SET);
                ObjectArrayList randomItems = this.worker.level().getServer().reloadableRegistries().getLootTable(lootTableId).getRandomItems(lootParams);
                for (ItemStack stack : randomItems) {
                    InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(stack, (IItemHandler)this.worker.getInventoryCitizen());
                }
            }
        }
        if (IColonyManager.getInstance().getCompatibilityManager().isOre(blockToMine)) {
            ((BuildingMiner)this.building).getColony().getStatisticsManager().increment("ores_mined", ((BuildingMiner)this.building).getColony().getDay());
        }
        ((BuildingMiner)this.building).getColony().getStatisticsManager().increment("blocks_mined", ((BuildingMiner)this.building).getColony().getDay());
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((BuildingMiner)this.building).getWorkOrder() == null && this.structurePlacer != null || this.structurePlacer != null && !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint() || ((BuildingMiner)this.building).getWorkOrder() != null && ((BuildingMiner)this.building).getWorkOrder().getStructurePath().contains("quarry")) {
            if (((BuildingMiner)this.building).hasWorkOrder()) {
                ((BuildingMiner)this.building).getWorkOrder().clearBlueprint();
                ((JobMiner)this.job).getColony().getWorkManager().removeWorkOrder(((BuildingMiner)this.building).getWorkOrder());
            }
            ((BuildingMiner)this.building).setWorkOrder(null);
            this.resetCurrentStructure();
            ((BuildingMiner)this.building).cancelAllRequestsOfCitizenOrBuilding(this.worker.getCitizenData());
            ((BuildingMiner)this.building).setProgressPos(null, BuildingProgressStage.CLEAR);
            return true;
        }
        if (!this.isThereAStructureToBuild()) {
            switch ((AIWorkerState)this.getState()) {
                case BUILDING_STEP: {
                    return true;
                }
            }
            return false;
        }
        return ((BuildingMiner)this.building).getWorkOrder() != null && !WorldUtil.isBlockLoaded((LevelAccessor)this.world, ((BuildingMiner)this.building).getWorkOrder().getLocation());
    }

    private boolean ladderDamaged() {
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.building).getLadderLocation().getX(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), (Level)this.world) - 1, ((BuildingMiner)this.building).getLadderLocation().getZ());
        return !this.world.getBlockState(nextLadder).isLadder((LevelReader)this.world, nextLadder, (LivingEntity)this.worker) && !this.world.getBlockState(nextLadder).isSolid();
    }
}

