/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard;

import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.jobs.JobRanger;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.ai.workers.guard.RangerCombatAI;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobWalkRandomEdge;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIRanger
extends AbstractEntityAIGuard<JobRanger, AbstractBuildingGuards> {
    public static final String RENDER_META_ARROW = "arrow";

    public EntityAIRanger(@NotNull JobRanger job) {
        super(job);
        this.toolsNeeded.add((EquipmentTypeEntry)ModEquipmentTypes.bow.get());
        new RangerCombatAI((EntityCitizen)this.worker, this.getStateAI(), this);
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.ARROW)) {
            renderMeta = (String)renderMeta + RENDER_META_ARROW;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    protected void atBuildingActions() {
        super.atBuildingActions();
        if (this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_USE_ARROWS) > 0.0) {
            InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.building, item -> item.getItem() instanceof ArrowItem, 64, (IItemHandler)this.worker.getInventoryCitizen());
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.getItem() instanceof ArrowItem) < 16) {
                this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.ARROW), 64, 16);
            }
        }
    }

    @Override
    public void guardMovement() {
        if (this.worker.getRandom().nextInt(30) < 1) {
            this.walkToSafePos(this.buildingGuards.getGuardPos(this.worker));
            return;
        }
        if (!this.worker.getNavigation().isDone()) {
            return;
        }
        BlockPos guardPos = this.buildingGuards.getGuardPos(this.worker);
        if (BlockPosUtil.dist(guardPos, this.worker.blockPosition()) <= 10.0 || this.walkToSafePos(guardPos)) {
            ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(new PathJobWalkRandomEdge((Level)this.world, guardPos, 10, (Mob)this.worker), null, 1.0, true);
        }
    }
}

