/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.FurnaceUserModule;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingSmeltery;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobSmelter;
import com.minecolonies.core.colony.requestable.SmeltableOre;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIUsesFurnace;
import com.minecolonies.core.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.core.util.WorkerUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSmelter
extends AbstractEntityAIUsesFurnace<JobSmelter, BuildingSmeltery> {
    private static final double BASE_XP_GAIN = 5.0;
    public static final String ORE_LIST = "ores";

    public EntityAIWorkSmelter(@NotNull JobSmelter job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.BREAK_ORES, this::breakOres, 20));
        this.worker.setCanPickUpLoot(true);
    }

    private IAIState breakOres() {
        BuildingSmeltery.OreBreakingModule module = ((BuildingSmeltery)this.building).getModule(BuildingModules.SMELTER_OREBREAK);
        IRecipeStorage currentRecipeStorage = module.getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
        if (currentRecipeStorage == null) {
            return AIWorkerState.IDLE;
        }
        ItemStack inputItem = currentRecipeStorage.getCleanedInput().stream().map(ItemStorage::getItemStack).findFirst().orElse(ItemStack.EMPTY);
        if (inputItem.isEmpty()) {
            return AIWorkerState.IDLE;
        }
        Component statsName = inputItem.getHoverName();
        int quantity = inputItem.getCount();
        WorkerUtil.faceBlock(((BuildingSmeltery)this.building).getPosition(), this.worker);
        if (!module.fullFillRecipe(currentRecipeStorage)) {
            return AIWorkerState.IDLE;
        }
        this.worker.decreaseSaturationForContinuousAction();
        StatsUtil.trackStatByName((IBuilding)this.building, "ores_broken", statsName, quantity);
        this.worker.getCitizenExperienceHandler().addExperience(0.2);
        new LocalizedParticleEffectMessage(inputItem, ((BuildingSmeltery)this.building).getID()).sendToTrackingEntity((Entity)this.worker);
        new LocalizedParticleEffectMessage(inputItem, ((BuildingSmeltery)this.building).getID().below()).sendToTrackingEntity((Entity)this.worker);
        this.worker.setItemInHand(InteractionHand.MAIN_HAND, inputItem);
        this.worker.swing(InteractionHand.MAIN_HAND);
        SoundUtils.playSoundAtCitizen((Level)this.world, ((BuildingSmeltery)this.building).getID(), SoundEvents.LEASH_KNOT_BREAK);
        return this.getState();
    }

    @Override
    public Class<BuildingSmeltery> getExpectedBuildingClass() {
        return BuildingSmeltery.class;
    }

    @Override
    protected void extractFromFurnace(FurnaceBlockEntity furnace) {
        StatsUtil.trackStatFromFurnace(this.building, "items_smelted_detail", furnace, 2);
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((Container)furnace), 2, (IItemHandler)this.worker.getInventoryCitizen());
        this.worker.getCitizenExperienceHandler().addExperience(5.0);
        this.incrementActionsDoneAndDecSaturation();
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        return new SmeltableOre(64 * ((FurnaceUserModule)((BuildingSmeltery)this.building).getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces().size());
    }

    @Override
    protected IAIState checkForImportantJobs() {
        if (!ItemStackUtils.isEmpty(this.worker.getMainHandItem())) {
            this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        if (!this.worker.getInventoryCitizen().hasSpace()) {
            return AIWorkerState.INVENTORY_FULL;
        }
        ICraftingBuildingModule module = (ICraftingBuildingModule)((BuildingSmeltery)this.building).getFirstModuleOccurance(BuildingSmeltery.OreBreakingModule.class);
        IRecipeStorage currentRecipeStorage = module.getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
        if (currentRecipeStorage == null) {
            return super.checkForImportantJobs();
        }
        return AIWorkerState.BREAK_ORES;
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack) || !ItemStackUtils.IS_SMELTABLE.and(itemStack -> IColonyManager.getInstance().getCompatibilityManager().isOre(stack)).test(stack)) {
            return false;
        }
        if (IColonyManager.getInstance().getCompatibilityManager().isBreakableOre(stack)) {
            return false;
        }
        return !((ItemListModule)((BuildingSmeltery)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals(ORE_LIST))).isItemInList(new ItemStorage(stack));
    }

    @Override
    public void requestSmeltable() {
        if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, s -> new SmeltableOre(1).matches((ItemStack)s), 1) <= 0 && !((BuildingSmeltery)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(this.getSmeltAbleClass().getClass())) && !((BuildingSmeltery)this.building).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), req -> req.getShortDisplayString().getSiblings().contains(Component.translatable((String)"com.minecolonies.coremod.request.smeltableore")))) {
            ImmutableList<ItemStorage> allowedItems = ((ItemListModule)((BuildingSmeltery)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals(ORE_LIST))).getList();
            if (allowedItems.isEmpty()) {
                this.worker.getCitizenData().createRequestAsync(this.getSmeltAbleClass());
            } else {
                List<ItemStack> requests = IColonyManager.getInstance().getCompatibilityManager().getSmeltableOres().stream().filter(storage -> !allowedItems.contains(storage)).map(ItemStorage::getItemStack).collect(Collectors.toList());
                if (requests.isEmpty()) {
                    if (this.worker.getCitizenData() != null) {
                        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.furnaceuser.noore", (Object[])new Object[0]), ChatPriority.BLOCKING));
                    }
                } else {
                    this.worker.getCitizenData().createRequestAsync(new StackList(requests, "com.minecolonies.coremod.request.smeltableore", 64 * ((FurnaceUserModule)((BuildingSmeltery)this.building).getFirstModuleOccurance(FurnaceUserModule.class)).getFurnaces().size(), 1));
                }
            }
        }
    }
}

