/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.IStateSupplier;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingAlchemist;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobAlchemist;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.network.messages.client.BlockParticleEffectMessage;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkAlchemist
extends AbstractEntityAICrafting<JobAlchemist, BuildingAlchemist> {
    private static final double BASE_XP_GAIN = 5.0;
    private static final int DELAY_TO_HARVEST_NETHERWART = 30;
    private static final int DELAY_TO_HARVEST_MISTLETOE = 30;
    private BlockPos fuelPos = null;
    private IAIState preFuelState = null;
    private BlockPos walkTo;

    public EntityAIWorkAlchemist(@NotNull JobAlchemist alchemistJob) {
        super(alchemistJob);
        super.registerTargets(new AIEventTarget<IStateSupplier<Object>>(AIBlockingEventType.EVENT, this::isFuelNeeded, this::checkBrewingStandFuel, 200), new AIEventTarget<IStateSupplier<Object>>(AIBlockingEventType.EVENT, this::accelerateBrewingStand, this::getState, 20), new AITarget<Object>(AIWorkerState.START_USING_BREWINGSTAND, this::fillUpBrewingStand, 20), new AITarget<Object>(AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD, this::retrieveBrewableFromBrewingStand, 20), new AITarget<Object>(AIWorkerState.RETRIEVING_USED_FUEL_FROM_BREWINGSTAND, this::retrieveUsedFuel, 20), new AITarget<Object>(AIWorkerState.ADD_FUEL_TO_BREWINGSTAND, this::addFuelToBrewingStand, 20), new AITarget<Object>(AIWorkerState.HARVEST_MISTLETOE, this::harvestMistleToe, 20), new AITarget<Object>(AIWorkerState.HARVEST_NETHERWART, this::harvestNetherWart, 20));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAIState harvestNetherWart() {
        if (this.walkTo == null) {
            List<BlockPos> soilList = ((BuildingAlchemist)this.building).getAllSoilPositions();
            if (soilList.isEmpty()) {
                return AIWorkerState.IDLE;
            }
            BlockPos randomSoil = soilList.get(this.worker.getRandom().nextInt(soilList.size()));
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.world, randomSoil)) return AIWorkerState.HARVEST_NETHERWART;
            if (this.world.getBlockState(randomSoil).getBlock() == Blocks.SOUL_SAND) {
                if (this.world.getBlockState(randomSoil.above()).getBlock() == Blocks.NETHER_WART) {
                    this.walkTo = randomSoil;
                    return AIWorkerState.HARVEST_NETHERWART;
                }
                if (this.world.isEmptyBlock(randomSoil.above()) && !this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.NETHER_WART, 1), 16, 1)) {
                    return AIWorkerState.IDLE;
                }
                this.walkTo = randomSoil;
                return AIWorkerState.HARVEST_NETHERWART;
            } else {
                ((BuildingAlchemist)this.building).removeSoilPosition(randomSoil);
            }
            return AIWorkerState.HARVEST_NETHERWART;
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, this.walkTo) && this.world.getBlockState(this.walkTo).getBlock() == Blocks.SOUL_SAND) {
            if (!this.walkToWorkPos(this.walkTo)) {
                return AIWorkerState.HARVEST_NETHERWART;
            }
            BlockState aboveState = this.world.getBlockState(this.walkTo.above());
            if (!(aboveState.getBlock() instanceof AirBlock)) {
                if (aboveState.getBlock() == Blocks.NETHER_WART && (Integer)aboveState.getValue((Property)NetherWartBlock.AGE) < 2) {
                    this.walkTo = null;
                    return AIWorkerState.IDLE;
                }
                List<ItemStack> netherwartDrops = this.getNetherwartDrops(this.walkTo.above());
                if (!this.mineBlock(this.walkTo.above())) return AIWorkerState.HARVEST_NETHERWART;
                for (ItemStack netherwartDrop : netherwartDrops) {
                    StatsUtil.trackStatByName((IBuilding)this.building, "ingredients_harvested", netherwartDrop.getDescriptionId(), netherwartDrop.getCount());
                }
                this.walkTo = null;
                this.worker.decreaseSaturationForContinuousAction();
                return AIWorkerState.IDLE;
            }
            if (!this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.NETHER_WART, 1), 16, 1)) {
                this.walkTo = null;
                return AIWorkerState.IDLE;
            }
            int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(Items.NETHER_WART);
            if (slot == -1) {
                this.walkTo = null;
                return AIWorkerState.IDLE;
            }
            this.world.setBlockAndUpdate(this.walkTo.above(), Blocks.NETHER_WART.defaultBlockState());
            this.worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
            this.walkTo = null;
            return AIWorkerState.IDLE;
        }
        this.walkTo = null;
        return AIWorkerState.IDLE;
    }

    private List<ItemStack> getNetherwartDrops(BlockPos blockToMine) {
        ArrayList<ItemStack> localItems = new ArrayList<ItemStack>();
        ItemStack tool = this.worker.getMainHandItem();
        localItems.addAll(BlockPosUtil.getBlockDrops((Level)this.world, blockToMine, ItemStackUtils.getFortuneOf(tool, this.worker.level()), tool, (LivingEntity)this.worker));
        return localItems;
    }

    private IAIState harvestMistleToe() {
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.shears.get())) {
            return AIWorkerState.IDLE;
        }
        if (this.walkTo == null) {
            List<BlockPos> leaveList = ((BuildingAlchemist)this.building).getAllLeavePositions();
            if (leaveList.isEmpty()) {
                return AIWorkerState.IDLE;
            }
            BlockPos randomLeaf = leaveList.get(this.worker.getRandom().nextInt(leaveList.size()));
            if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, randomLeaf)) {
                if (this.world.getBlockState(randomLeaf).getBlock() instanceof LeavesBlock) {
                    this.walkTo = randomLeaf;
                } else {
                    ((BuildingAlchemist)this.building).removeLeafPosition(randomLeaf);
                }
            }
            return AIWorkerState.HARVEST_MISTLETOE;
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, this.walkTo) && this.world.getBlockState(this.walkTo).getBlock() instanceof LeavesBlock) {
            if (!this.walkToWorkPos(this.walkTo)) {
                return AIWorkerState.HARVEST_MISTLETOE;
            }
            BlockState state = this.world.getBlockState(this.walkTo);
            int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.worker.getInventoryCitizen(), (EquipmentTypeEntry)ModEquipmentTypes.shears.get(), 0, ((BuildingAlchemist)this.building).getMaxEquipmentLevel());
            CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, slot);
            this.worker.swing(InteractionHand.MAIN_HAND);
            this.world.playSound(null, this.walkTo, state.getSoundType((LevelReader)this.world, this.walkTo, (Entity)this.worker).getBreakSound(), SoundSource.BLOCKS, state.getSoundType((LevelReader)this.world, this.walkTo, (Entity)this.worker).getVolume(), state.getSoundType((LevelReader)this.world, this.walkTo, (Entity)this.worker).getPitch());
            new BlockParticleEffectMessage(this.walkTo, state, this.worker.getRandom().nextInt(7) - 1).sendToTrackingEntity((Entity)this.worker);
            if (this.worker.getRandom().nextInt(40) <= 0) {
                this.worker.decreaseSaturationForContinuousAction();
                ItemStack mistletoe = new ItemStack((ItemLike)ModItems.mistletoe, 1);
                StatsUtil.trackStatByName((IBuilding)this.building, "ingredients_harvested", mistletoe.getDescriptionId(), mistletoe.getCount());
                InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), mistletoe);
                this.walkTo = null;
                CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
                return AIWorkerState.INVENTORY_FULL;
            }
        } else {
            this.walkTo = null;
            return AIWorkerState.IDLE;
        }
        return AIWorkerState.HARVEST_MISTLETOE;
    }

    @Override
    protected IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((JobAlchemist)this.job).getTaskQueue().isEmpty() || ((JobAlchemist)this.job).getCurrentTask() == null) {
            if (this.worker.getNavigation().isDone()) {
                if (this.worker.getRandom().nextInt(30) <= 1) {
                    return AIWorkerState.HARVEST_NETHERWART;
                }
                if (this.worker.getRandom().nextInt(30) <= 1) {
                    return AIWorkerState.HARVEST_MISTLETOE;
                }
                if (((BuildingAlchemist)this.building).isInBuilding(this.worker.blockPosition())) {
                    this.setDelay(400);
                    EntityNavigationUtils.walkToRandomPosWithin(this.worker, 10, 0.6, ((BuildingAlchemist)this.building).getCorners());
                } else {
                    this.walkToBuilding();
                }
            }
            return AIWorkerState.IDLE;
        }
        if (!this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobAlchemist)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        return this.getNextCraftingState();
    }

    @Override
    public Class<BuildingAlchemist> getExpectedBuildingClass() {
        return BuildingAlchemist.class;
    }

    @Override
    protected int getExtendedCount(ItemStack stack) {
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.BREWING_STAND) {
            int count = 0;
            for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.world, pos)) continue;
                BlockEntity entity = this.world.getBlockEntity(pos);
                if (entity instanceof BrewingStandBlockEntity) {
                    BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
                    for (int slot = 0; slot < 4; ++slot) {
                        ItemStack stackInSlot = brewingStand.getItem(slot);
                        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, stackInSlot).booleanValue()) continue;
                        count += stackInSlot.getCount();
                    }
                    continue;
                }
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
            }
            return count;
        }
        return 0;
    }

    @Override
    protected IAIState getRecipe() {
        IRequest currentTask = ((JobAlchemist)this.job).getCurrentTask();
        if (currentTask == null) {
            this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.START_WORKING;
        }
        ((JobAlchemist)this.job).setMaxCraftingCount(((PublicCrafting)currentTask.getRequest()).getCount());
        BlockPos brewingStandPos = this.getPositionOfBrewingStandToRetrieveFrom();
        if (brewingStandPos != null) {
            this.currentRequest = currentTask;
            this.walkTo = brewingStandPos;
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD;
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.BREWING_STAND) {
            for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
                BlockEntity entity = this.world.getBlockEntity(pos);
                if (entity instanceof BrewingStandBlockEntity) {
                    BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
                    if (brewingStand.brewTime <= 0 && ItemStackUtils.isEmpty(brewingStand.getItem(3))) continue;
                    return AIWorkerState.CRAFT;
                }
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
            }
        }
        return super.getRecipe();
    }

    private int countOfBubblingBrewingStands() {
        int count = 0;
        Level world = ((BuildingAlchemist)this.building).getColony().getWorld();
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof BrewingStandBlockEntity) {
                BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
                if (brewingStand.brewTime <= 0) continue;
                ++count;
                continue;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        return count;
    }

    private boolean accelerateBrewingStand() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getSecondarySkill()) / 10 * 2;
        Level world = ((BuildingAlchemist)this.building).getColony().getWorld();
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || !((entity = world.getBlockEntity(pos)) instanceof BrewingStandBlockEntity)) continue;
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (brewingStand.brewTime <= 0) continue;
                BrewingStandBlockEntity.serverTick((Level)entity.getLevel(), (BlockPos)entity.getBlockPos(), (BlockState)entity.getBlockState(), (BrewingStandBlockEntity)brewingStand);
            }
        }
        return false;
    }

    private boolean isFuelNeeded() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.BREWING_STAND) {
            return false;
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.world, pos)) continue;
            BlockEntity entity = this.world.getBlockEntity(pos);
            if (!(entity instanceof BrewingStandBlockEntity)) {
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
                continue;
            }
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
            if (brewingStand.brewTime > 0 || !ItemStackUtils.hasBrewableAndNoFuel(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) continue;
            return this.getState() != AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return false;
    }

    private IAIState checkBrewingStandFuel() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.BREWING_STAND) {
            return this.getState();
        }
        Level world = ((BuildingAlchemist)this.building).getColony().getWorld();
        if (!(InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.BLAZE_POWDER) || InventoryUtils.hasItemInProvider((IItemHandlerCapProvider)this.building, Items.BLAZE_POWDER) || ((BuildingAlchemist)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(Stack.class)))) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((ItemLike)Items.BLAZE_POWDER), 8 * ((BuildingAlchemist)this.building).getAllBrewingStandPositions().size(), 1));
            return this.getState();
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof BrewingStandBlockEntity) {
                BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
                if (brewingStand.brewTime > 0 || !ItemStackUtils.hasBrewableAndNoFuel(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) continue;
                if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.BLAZE_POWDER)) {
                    if (InventoryUtils.hasItemInProvider((IItemHandlerCapProvider)this.building, Items.BLAZE_POWDER)) {
                        this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(item -> item.getItem() == Items.BLAZE_POWDER, 8);
                        this.walkTo = null;
                        return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                    }
                    return this.getState();
                }
                this.fuelPos = pos;
                if (this.preFuelState == null) {
                    this.preFuelState = this.getState();
                }
                return AIWorkerState.ADD_FUEL_TO_BREWINGSTAND;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        return this.getState();
    }

    private IAIState addFuelToBrewingStand() {
        BlockEntity entity;
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.BLAZE_POWDER)) {
            if (InventoryUtils.hasItemInProvider((IItemHandlerCapProvider)this.building, Items.BLAZE_POWDER)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(item -> item.getItem() == Items.BLAZE_POWDER, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.preFuelState = null;
            this.fuelPos = null;
            return AIWorkerState.START_WORKING;
        }
        if (this.fuelPos == null || !this.walkToWorkPos(this.fuelPos)) {
            return this.getState();
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, this.fuelPos) && (entity = this.world.getBlockEntity(this.fuelPos)) instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.BLAZE_POWDER) && (ItemStackUtils.hasBrewableAndNoFuel(brewingStand) || ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.getItem() == Items.BLAZE_POWDER, 8, (IItemHandler)new InvWrapper((Container)brewingStand), 4);
                if (this.preFuelState != null && this.preFuelState != AIWorkerState.ADD_FUEL_TO_BREWINGSTAND) {
                    IAIState returnState = this.preFuelState;
                    this.preFuelState = null;
                    this.fuelPos = null;
                    return returnState;
                }
            }
        }
        this.preFuelState = null;
        this.fuelPos = null;
        return AIWorkerState.START_WORKING;
    }

    private int getMaxUsableBrewingStands() {
        int maxSkillBrewingStand = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill()) / 10 + 1;
        return Math.min(maxSkillBrewingStand, ((BuildingAlchemist)this.building).getAllBrewingStandPositions().size());
    }

    private BlockPos getPositionOfBrewingStandToRetrieveFrom() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.BREWING_STAND) {
            return null;
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            BlockEntity entity = this.world.getBlockEntity(pos);
            if (!(entity instanceof BrewingStandBlockEntity)) continue;
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)entity;
            int countInResultSlot = 0;
            for (int slot = 0; slot < 3; ++slot) {
                if (ItemStackUtils.isEmpty(brewingStand.getItem(slot)) || !ItemStackUtils.compareItemStacksIgnoreStackSize(this.currentRecipeStorage.getPrimaryOutput(), brewingStand.getItem(slot)).booleanValue()) continue;
                countInResultSlot = brewingStand.getItem(slot).getCount();
            }
            if (brewingStand.brewTime > 0 || countInResultSlot <= 0 || !ItemStackUtils.isEmpty(brewingStand.getItem(3))) continue;
            return pos;
        }
        return null;
    }

    @Override
    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        if (storage.getIntermediate() != Blocks.BREWING_STAND) {
            return super.checkForItems(storage);
        }
        List<ItemStorage> input = storage.getCleanedInput();
        int countInBewingStand = this.getExtendedCount(storage.getPrimaryOutput());
        int outputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, storage.getPrimaryOutput()));
        for (ItemStorage inputStorage : input) {
            int inputInInv;
            Predicate<ItemStack> predicate = stack -> !ItemStackUtils.isEmpty(stack) && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, inputStorage.getItemStack()) != false;
            int inputInBrewingStand = this.getExtendedCount(inputStorage.getItemStack());
            if (countInBewingStand + inputInBrewingStand + (inputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate)) + outputInInv < inputStorage.getAmount() * ((JobAlchemist)this.job).getMaxCraftingCount() && InventoryUtils.hasItemInProvider((IItemHandlerCapProvider)this.building, predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, inputStorage.getAmount() * (((JobAlchemist)this.job).getMaxCraftingCount() - countInBewingStand - inputInBrewingStand));
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            int countOfInput = inputInInv + InventoryUtils.getCountFromBuilding((IBuilding)this.building, predicate) + countInBewingStand + inputInBrewingStand + outputInInv;
            if (countOfInput >= inputStorage.getAmount() * ((JobAlchemist)this.job).getMaxCraftingCount()) continue;
            ((JobAlchemist)this.job).finishRequest(false);
            this.resetValues();
        }
        return AIWorkerState.CRAFT;
    }

    private IAIState retrieveBrewableFromBrewingStand() {
        if (this.walkTo == null || this.currentRequest == null) {
            return AIWorkerState.START_WORKING;
        }
        BlockEntity entity = this.world.getBlockEntity(this.walkTo);
        if (!(entity instanceof BrewingStandBlockEntity)) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.walkTo)) {
            return this.getState();
        }
        this.walkTo = null;
        int preExtractCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack));
        for (int slot = 0; slot < 3; ++slot) {
            if (ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).getItem(slot))) continue;
            this.extractFromBrewingStandSlot((BrewingStandBlockEntity)entity, slot);
        }
        int resultCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack)) - preExtractCount;
        if (resultCount > 0) {
            ItemStack stack2 = ((PublicCrafting)this.currentRequest.getRequest()).getStack().copy();
            stack2.setCount(resultCount);
            this.currentRequest.addDelivery(stack2);
            int step = resultCount / this.currentRecipeStorage.getPrimaryOutput().getCount();
            ((JobAlchemist)this.job).setCraftCounter(((JobAlchemist)this.job).getCraftCounter() + step);
            ((JobAlchemist)this.job).setProgress(((JobAlchemist)this.job).getProgress() - step);
            if (((JobAlchemist)this.job).getMaxCraftingCount() == 0) {
                ((JobAlchemist)this.job).setMaxCraftingCount(((PublicCrafting)this.currentRequest.getRequest()).getCount());
            }
            if (((JobAlchemist)this.job).getCraftCounter() >= ((JobAlchemist)this.job).getMaxCraftingCount() && ((JobAlchemist)this.job).getProgress() <= 0) {
                ((JobAlchemist)this.job).finishRequest(true);
                this.resetValues();
                this.currentRecipeStorage = null;
                this.incrementActionsDoneAndDecSaturation();
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private IAIState retrieveUsedFuel() {
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.walkTo)) {
            return this.getState();
        }
        BlockEntity entity = this.world.getBlockEntity(this.walkTo);
        if (!(entity instanceof BrewingStandBlockEntity) || ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).getItem(4))) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFromBrewingStandSlot((BrewingStandBlockEntity)entity, 4);
        return AIWorkerState.START_WORKING;
    }

    private void extractFromBrewingStandSlot(BrewingStandBlockEntity brewingStand, int slot) {
        InvWrapper standWrapper = new InvWrapper((Container)brewingStand);
        String extractName = standWrapper.getStackInSlot(slot).getDescriptionId();
        int extractQty = standWrapper.getStackInSlot(slot).getCount();
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)standWrapper, slot, (IItemHandler)this.worker.getInventoryCitizen());
        if (slot <= 3 && slot >= 0) {
            StatsUtil.trackStatByName((IBuilding)this.building, "items_brewed", extractName, extractQty);
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
        }
    }

    private IAIState checkIfAbleToSmelt() {
        int burning = this.countOfBubblingBrewingStands();
        if (burning > 0 && (burning >= this.getMaxUsableBrewingStands() || ((JobAlchemist)this.job).getCraftCounter() + ((JobAlchemist)this.job).getProgress() >= ((JobAlchemist)this.job).getMaxCraftingCount())) {
            this.setDelay(20);
            return this.getState();
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            BlockEntity entity = this.world.getBlockEntity(pos);
            if (entity instanceof BrewingStandBlockEntity) {
                if (!ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).getItem(3))) continue;
                this.walkTo = pos;
                return AIWorkerState.START_USING_BREWINGSTAND;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        if (burning > 0) {
            this.setDelay(20);
        }
        return this.getState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private IAIState fillUpBrewingStand() {
        block17: {
            Predicate<ItemStack> potion;
            int maxBrewingStands;
            BrewingStandBlockEntity brewingStand;
            BlockEntity entity;
            int burningCount;
            block18: {
                block14: {
                    int amountOfIngredientInInv;
                    int amountOfIngredientInBuilding;
                    int targetCount;
                    Predicate<ItemStack> ingredient;
                    block19: {
                        int resultInCitizenInv;
                        int resultInBrewingStand;
                        block15: {
                            int amountOfPotionInInv;
                            int amountOfPotionInBuilding;
                            int targetCount2;
                            block16: {
                                if (((BuildingAlchemist)this.building).getAllBrewingStandPositions().isEmpty()) {
                                    if (this.worker.getCitizenData() != null) {
                                        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.bakery.nofurnace", (Object[])new Object[0]), ChatPriority.BLOCKING));
                                    }
                                    this.setDelay(5);
                                    return AIWorkerState.START_WORKING;
                                }
                                if (this.walkTo == null || this.world.getBlockState(this.walkTo).getBlock() != Blocks.BREWING_STAND) {
                                    this.walkTo = null;
                                    this.setDelay(5);
                                    return AIWorkerState.START_WORKING;
                                }
                                burningCount = this.countOfBubblingBrewingStands();
                                entity = this.world.getBlockEntity(this.walkTo);
                                if (!(entity instanceof BrewingStandBlockEntity) || this.currentRecipeStorage == null) break block14;
                                brewingStand = (BrewingStandBlockEntity)entity;
                                maxBrewingStands = this.getMaxUsableBrewingStands();
                                resultInBrewingStand = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
                                resultInCitizenInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
                                if (!ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).getItem(0)) && !ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).getItem(1)) && !ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).getItem(2))) break block15;
                                ItemStack potionStack = this.currentRecipeStorage.getCleanedInput().get(0).getItemStack();
                                potion = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(potionStack, stack);
                                int potionInBrewingStand = this.getExtendedCount(potionStack);
                                targetCount2 = ((PublicCrafting)this.currentRequest.getRequest()).getCount() * this.currentRecipeStorage.getPrimaryOutput().getCount() - potionInBrewingStand - resultInBrewingStand - resultInCitizenInv;
                                if (targetCount2 <= 0) {
                                    return AIWorkerState.START_WORKING;
                                }
                                amountOfPotionInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, potion);
                                amountOfPotionInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), potion);
                                if (this.worker.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                                    this.worker.setItemInHand(InteractionHand.MAIN_HAND, potionStack.copy());
                                }
                                if (amountOfPotionInInv <= 0) break block16;
                                if (!ItemStackUtils.hasFuelAndNoBrewable(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) break block17;
                                break block18;
                            }
                            if (amountOfPotionInBuilding >= targetCount2 - amountOfPotionInInv && this.currentRecipeStorage.getIntermediate() == Blocks.BREWING_STAND) {
                                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(potion, targetCount2);
                                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                            }
                            ((JobAlchemist)this.job).finishRequest(false);
                            this.resetValues();
                            this.walkTo = null;
                            return AIWorkerState.IDLE;
                        }
                        if (!ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).getItem(3))) break block17;
                        ItemStack ingredientStack = this.currentRecipeStorage.getCleanedInput().get(1).getItemStack();
                        ingredient = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(ingredientStack, stack);
                        int ingredientInBrewingStand = this.getExtendedCount(ingredientStack);
                        targetCount = ((PublicCrafting)this.currentRequest.getRequest()).getCount() * this.currentRecipeStorage.getPrimaryOutput().getCount() - ingredientInBrewingStand * 3 - resultInBrewingStand - resultInCitizenInv;
                        if (targetCount <= 0) {
                            return AIWorkerState.START_WORKING;
                        }
                        amountOfIngredientInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, ingredient);
                        amountOfIngredientInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ingredient);
                        if (this.worker.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                            this.worker.setItemInHand(InteractionHand.MAIN_HAND, ingredientStack.copy());
                        }
                        if (amountOfIngredientInInv <= 0) break block19;
                        if (!ItemStackUtils.hasFuelAndNoBrewable(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) break block17;
                        int toTransfer = 0;
                        if (burningCount < maxBrewingStands) {
                            toTransfer = 1;
                        }
                        if (toTransfer <= 0) break block17;
                        if (!this.walkToWorkPos(this.walkTo)) {
                            return this.getState();
                        }
                        CitizenItemUtils.hitBlockWithToolInHand(this.worker, this.walkTo);
                        InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ingredient, toTransfer, (IItemHandler)new InvWrapper((Container)brewingStand), 3);
                        break block17;
                    }
                    if (amountOfIngredientInBuilding >= targetCount - amountOfIngredientInInv && this.currentRecipeStorage.getIntermediate() == Blocks.BREWING_STAND) {
                        this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(ingredient, targetCount);
                        return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                    }
                    ((JobAlchemist)this.job).finishRequest(false);
                    this.resetValues();
                    this.walkTo = null;
                    return AIWorkerState.IDLE;
                }
                if (this.world.getBlockState(this.walkTo).getBlock() instanceof BrewingStandBlock) break block17;
                ((BuildingAlchemist)this.building).removeBrewingStand(this.walkTo);
                break block17;
            }
            for (int slot = 0; slot < 3; ++slot) {
                if (!ItemStackUtils.isEmpty(((BrewingStandBlockEntity)entity).getItem(slot))) continue;
                int toTransfer = 0;
                if (burningCount < maxBrewingStands) {
                    toTransfer = 1;
                }
                if (toTransfer <= 0) continue;
                if (!this.walkToWorkPos(this.walkTo)) {
                    return this.getState();
                }
                CitizenItemUtils.hitBlockWithToolInHand(this.worker, this.walkTo);
                InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), potion, toTransfer, (IItemHandler)new InvWrapper((Container)brewingStand), slot);
            }
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IAIState craft() {
        if (!this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        if (this.currentRecipeStorage != null && this.currentRequest == null) {
            this.currentRequest = ((JobAlchemist)this.job).getCurrentTask();
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() != Blocks.BREWING_STAND) {
            return super.craft();
        }
        if (((BuildingAlchemist)this.building).getAllBrewingStandPositions().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.bakery.nofurnace", (Object[])new Object[0]), ChatPriority.BLOCKING));
            }
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        BlockPos posOfOven = this.getPositionOfBrewingStandToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD;
        }
        if (this.currentRequest != null && ((JobAlchemist)this.job).getMaxCraftingCount() > 0 && ((JobAlchemist)this.job).getCraftCounter() >= ((JobAlchemist)this.job).getMaxCraftingCount()) {
            ((JobAlchemist)this.job).finishRequest(true);
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        return this.checkIfAbleToSmelt();
    }

    @Override
    public boolean hasWorkToDo() {
        return true;
    }
}

