/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.builder;

import com.ldtteam.structurize.placement.StructurePlacer;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.jobs.JobBuilder;
import com.minecolonies.core.colony.workorders.WorkOrderBuilding;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import com.minecolonies.core.entity.ai.workers.util.BuildingStructureHandler;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveCloseToXNearY;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructureWithWorkOrder<JobBuilder, BuildingBuilder> {
    private static final double SPEED_BUFF_0 = 0.5;
    private static final int ACTIONS_UNTIL_DUMP = 4096;
    private static final int LEVEL_TO_PURGE_MOBS = 4;
    PathResult gotoPath = null;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public Class<BuildingBuilder> getExpectedBuildingClass() {
        return BuildingBuilder.class;
    }

    private boolean checkForWorkOrder() {
        if (!((BuildingBuilder)this.building).hasWorkOrder()) {
            ((BuildingBuilder)this.building).setProgressPos(null, BuildingProgressStage.CLEAR);
            this.worker.getCitizenData().setStatusPosition(null);
            return false;
        }
        IBuilderWorkOrder wo = ((BuildingBuilder)this.building).getWorkOrder();
        if (wo == null) {
            ((BuildingBuilder)this.building).setWorkOrder(null);
            ((BuildingBuilder)this.building).setProgressPos(null, null);
            this.worker.getCitizenData().setStatusPosition(null);
            return false;
        }
        IBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getLocation());
        if (building == null && wo instanceof WorkOrderBuilding && wo.getWorkOrderType() != WorkOrderType.REMOVE) {
            ((BuildingBuilder)this.building).complete(this.worker.getCitizenData());
            return false;
        }
        return true;
    }

    @Override
    public void setStructurePlacer(BuildingStructureHandler<JobBuilder, BuildingBuilder> structure) {
        if (((BuildingBuilder)this.building).getWorkOrder().getIteratorType().isEmpty()) {
            String mode = BuilderModeSetting.getActualValue(this.building);
            ((BuildingBuilder)this.building).getWorkOrder().setIteratorType(mode);
        }
        this.structurePlacer = new Tuple<StructurePlacer, BuildingStructureHandler<JobBuilder, BuildingBuilder>>(new StructurePlacer(structure, ((BuildingBuilder)this.building).getWorkOrder().getIteratorType()), structure);
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return !this.checkForWorkOrder();
    }

    @Override
    protected IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        if (this.checkForWorkOrder()) {
            IAIState state = super.startWorkingAtOwnBuilding();
            if (state == AIWorkerState.IDLE) {
                return AIWorkerState.LOAD_STRUCTURE;
            }
            return state;
        }
        return AIWorkerState.IDLE;
    }

    private void killMobs() {
        if (((BuildingBuilder)this.building).getBuildingLevel() >= 4 && ((BuildingBuilder)this.building).getWorkOrder() != null && ((BuildingBuilder)this.building).getWorkOrder().getWorkOrderType() == WorkOrderType.BUILD) {
            BlockPos buildingPos = ((BuildingBuilder)this.building).getWorkOrder().getLocation();
            IBuilding building = this.worker.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getBuilding(buildingPos);
            if (building != null) {
                WorldUtil.getEntitiesWithinBuilding((Level)this.world, Monster.class, building, null).forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
            }
        }
    }

    @Override
    public void checkForExtraBuildingActions() {
        if (!((BuildingBuilder)this.building).hasPurgedMobsToday()) {
            this.killMobs();
            ((BuildingBuilder)this.building).setPurgedMobsToday(true);
        }
    }

    @Override
    protected boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        return this.mineBlock(blockToMine, safeStand, true, !IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.getBlockState(blockToMine)), null);
    }

    @Override
    public IAIState afterRequestPickUp() {
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PICK_UP;
    }

    @Override
    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom != null && this.workFrom.getX() == currentBlock.getX() && this.workFrom.getZ() == currentBlock.getZ() && this.workFrom.getY() >= currentBlock.getY()) {
            this.workFrom = null;
        }
        if (this.workFrom == null) {
            if (this.gotoPath == null || this.gotoPath.isCancelled()) {
                PathJobMoveCloseToXNearY pathJob = new PathJobMoveCloseToXNearY((Level)this.world, currentBlock, ((BuildingBuilder)this.building).getWorkOrder().getLocation(), 4, (Mob)this.worker);
                this.gotoPath = ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(pathJob, currentBlock, 1.0, false);
                pathJob.getPathingOptions().canDrop = false;
                pathJob.extraNodes = 0;
            } else if (this.gotoPath.isDone()) {
                if (this.gotoPath.getPath() != null) {
                    this.workFrom = this.gotoPath.getPath().getTarget();
                }
                this.gotoPath = null;
            }
            if (this.prevBlockPosition != null) {
                return BlockPosUtil.dist(this.prevBlockPosition, currentBlock) <= 10.0;
            }
            return false;
        }
        if (!this.walkToSafePos(this.workFrom)) {
            MinecoloniesAdvancedPathNavigate pathNavigate;
            AbstractAdvancedPathNavigate abstractAdvancedPathNavigate = this.worker.getNavigation();
            if (abstractAdvancedPathNavigate instanceof MinecoloniesAdvancedPathNavigate && (pathNavigate = (MinecoloniesAdvancedPathNavigate)abstractAdvancedPathNavigate).isStuck()) {
                this.workFrom = null;
            }
            return false;
        }
        if (BlockPosUtil.getDistance2D(this.worker.blockPosition(), currentBlock) > 5L) {
            if (BlockPosUtil.dist(this.workFrom, ((BuildingBuilder)this.building).getWorkOrder().getLocation()) < 100.0) {
                this.prevBlockPosition = currentBlock;
                this.workFrom = null;
                return true;
            }
            this.workFrom = null;
            return false;
        }
        this.prevBlockPosition = currentBlock;
        return true;
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return false;
    }

    @Override
    public int getBlockMiningTime(@NotNull BlockState state, @NotNull BlockPos pos) {
        return (int)((double)super.getBlockMiningTime(state, pos) * 0.5);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 4096;
    }

    @Override
    protected void sendCompletionMessage(IWorkOrder wo) {
        super.sendCompletionMessage(wo);
        BlockPos position = wo.getLocation();
        boolean showManualSuffix = false;
        if (((BuildingBuilder)this.building).getManualMode()) {
            showManualSuffix = true;
            for (IWorkOrder iWorkOrder : ((BuildingBuilder)this.building).getColony().getWorkManager().getWorkOrders().values()) {
                if (iWorkOrder.getID() == wo.getID() || !((BuildingBuilder)this.building).getID().equals((Object)iWorkOrder.getClaimedBy())) continue;
                showManualSuffix = false;
            }
        }
        MutableComponent message = Component.translatableEscape((String)wo.getWorkOrderType().getCompletionMessageID(), (Object[])new Object[]{wo.getDisplayName(), BlockPosUtil.calcDirection(((BuildingBuilder)this.building).getColony().getCenter(), position).getLongText()}).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"message.positiondist", (Object[])new Object[]{position.getX(), position.getY(), position.getZ(), (int)BlockPosUtil.dist(((BuildingBuilder)this.building).getColony().getCenter(), position)})))).withStyle(ChatFormatting.GREEN);
        if (showManualSuffix) {
            message.append((Component)Component.translatableEscape((String)"entity.builder.messagebuildmanualfinish", (Object[])new Object[0]));
        }
        MessageUtils.forCitizen(this.worker, (Component)message).sendTo(this.worker.getCitizenColonyHandler().getColonyOrRegister().getImportantMessageEntityPlayers());
    }

    @Override
    public boolean canGoIdle() {
        return !((BuildingBuilder)this.building).hasWorkOrder();
    }
}

