/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobEscapeWater;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class EntityAIFloat
extends FloatGoal {
    private final Mob owner;
    private PathResult waterPathing = null;

    public EntityAIFloat(Mob mob) {
        super(mob);
        this.owner = mob;
        if (!(mob.getNavigation() instanceof MinecoloniesAdvancedPathNavigate)) {
            Log.getLogger().error("Unsupported entity for EntityAIFloat goal:" + String.valueOf(mob));
        }
    }

    public void tick() {
        if (!this.owner.getEyeInFluidType().isAir() && this.owner.getEyeInFluidType().canSwim((Entity)this.owner)) {
            PathNavigation pathNavigation;
            if (this.owner.level().getBlockState(BlockPos.containing((Position)this.owner.getEyePosition()).above()).isAir()) {
                if (this.owner.tickCount % 3 == 0) {
                    this.owner.getJumpControl().jump();
                }
                return;
            }
            if ((this.waterPathing == null || !this.waterPathing.isInProgress()) && (pathNavigation = this.owner.getNavigation()) instanceof MinecoloniesAdvancedPathNavigate) {
                MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)pathNavigation;
                nav.setPauseTicks(0);
                nav.stop();
                this.waterPathing = nav.setPathJob(new PathJobEscapeWater(CompatibilityUtils.getWorldFromEntity((Entity)this.owner), this.owner.blockPosition(), (int)this.owner.getAttribute(Attributes.FOLLOW_RANGE).getValue() * 5, this.owner), null, 1.0, false);
                nav.setPauseTicks(300);
            }
        } else {
            if (this.waterPathing != null) {
                this.waterPathing = null;
                PathNavigation pathNavigation = this.owner.getNavigation();
                if (pathNavigation instanceof MinecoloniesAdvancedPathNavigate) {
                    MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)pathNavigation;
                    nav.setPauseTicks(0);
                }
            }
            if (this.owner.tickCount % 3 == 0) {
                this.owner.getJumpControl().jump();
            }
        }
    }
}

