/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.command;

import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.debug.messages.DebugEnableMessage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CommandToggleDebug
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        GameProfile profile;
        try {
            profile = GameProfileArgument.getGameProfiles(context, (String)"playername").stream().findFirst().orElse(null);
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        boolean enabled = DebugPlayerManager.toggleDebugModeFor(profile.getId());
        if (enabled) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Enabled minecolonies debugging for:" + profile.getName())).withStyle(ChatFormatting.GREEN), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Disabled minecolonies debugging for:" + profile.getName())).withStyle(ChatFormatting.RED), true);
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(profile.getId());
        if (player != null) {
            if (enabled) {
                new DebugEnableMessage(true).sendToPlayer(player);
                player.sendSystemMessage((Component)Component.literal((String)"Enabled minecolonies debugging").withStyle(ChatFormatting.GREEN));
            } else {
                new DebugEnableMessage(false).sendToPlayer(player);
                player.sendSystemMessage((Component)Component.literal((String)"Disabled minecolonies debugging").withStyle(ChatFormatting.RED));
            }
        }
        return 1;
    }

    @Override
    public String getName() {
        return "toggleDebugging";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("playername", GameProfileArgument.gameProfile()).executes(this::checkPreConditionAndExecute));
    }
}

