/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.colony.interactionhandling.RecruitmentInteraction;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;

public class CustomVisitorListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String VISITOR_TEXTURE = "texture";
    public static final String VISITOR_NAME = "name";
    public static final String VISITOR_STORYKEY = "storylangkey";
    public static final String VISITOR_CHANCE = "chance";
    public static final String VISITOR_CITIZEN_SUFFIX = "citizensuffix";
    public static final String VISITOR_RECRUITCOST = "recruitcost";
    public static final String VISITOR_RECRUITCOSTCOUNT = "recruitcostcount";
    public static final String VISITOR_GENDER = "gender";
    public static final String VISITOR_VOICE_PROFILE = "voiceprofile";
    public static final String VISITOR_PRIMARY_SKILL = "primaryskill";
    public static final String VISITOR_SECONDARY_SKILL = "secondaryskill";
    public static ImmutableList<CustomVisitorData> visitorDataPack = ImmutableList.of();
    private static final Random rand = new Random();

    public CustomVisitorListener() {
        super(GSON, "visitors");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        visitorDataPack = ImmutableList.of();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            this.tryParse(entry);
        }
    }

    private void tryParse(Map.Entry<ResourceLocation, JsonElement> entry) {
        try {
            JsonObject data = (JsonObject)entry.getValue();
            CustomVisitorData dataEntry = new CustomVisitorData(this);
            if (data.has(VISITOR_TEXTURE)) {
                dataEntry.texture = UUID.fromString(data.get(VISITOR_TEXTURE).getAsString());
            }
            if (data.has(VISITOR_NAME)) {
                dataEntry.name = data.get(VISITOR_NAME).getAsString();
            }
            if (data.has(VISITOR_STORYKEY)) {
                dataEntry.storykey = data.get(VISITOR_STORYKEY).getAsString();
            }
            if (data.has(VISITOR_CHANCE)) {
                dataEntry.chance = data.get(VISITOR_CHANCE).getAsDouble();
            }
            if (data.has(VISITOR_CITIZEN_SUFFIX)) {
                dataEntry.citizenSuffix = data.get(VISITOR_CITIZEN_SUFFIX).getAsString();
            }
            if (data.has(VISITOR_RECRUITCOST)) {
                dataEntry.recruitCost = ItemStackUtils.idToItemStack(data.get(VISITOR_RECRUITCOST).getAsString(), this.getRegistryLookup());
            }
            if (data.has(VISITOR_RECRUITCOSTCOUNT) && dataEntry.recruitCost != null) {
                dataEntry.recruitCost.setCount(data.get(VISITOR_RECRUITCOSTCOUNT).getAsInt());
            }
            if (data.has(VISITOR_VOICE_PROFILE)) {
                dataEntry.voiceProfile = data.get(VISITOR_VOICE_PROFILE).getAsInt();
            }
            if (data.has(VISITOR_PRIMARY_SKILL)) {
                dataEntry.primarySkill = data.get(VISITOR_PRIMARY_SKILL).getAsString();
            }
            if (data.has(VISITOR_SECONDARY_SKILL)) {
                dataEntry.secondarySkill = data.get(VISITOR_SECONDARY_SKILL).getAsString();
            }
            if (data.has(VISITOR_GENDER)) {
                dataEntry.gender = data.get(VISITOR_GENDER).getAsString().substring(0, 1);
                if (!dataEntry.gender.equals("m") && !dataEntry.gender.equals("f")) {
                    Log.getLogger().warn("Could not parse visitor gender(m/f) for:" + String.valueOf(entry.getKey()));
                    return;
                }
            }
            visitorDataPack = ImmutableList.builder().addAll(visitorDataPack).add((Object)dataEntry).build();
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not parse visitor for:" + String.valueOf(entry.getKey()), (Throwable)e);
        }
    }

    public static boolean chanceCustomVisitors(IVisitorData original) {
        for (CustomVisitorData customVisitorData : visitorDataPack) {
            if (!(rand.nextDouble() < customVisitorData.chance)) continue;
            customVisitorData.applyToVisitor(original);
            return true;
        }
        return false;
    }

    class CustomVisitorData {
        private UUID texture = null;
        private String name = null;
        private String storykey = null;
        private double chance = 0.0;
        private String citizenSuffix = null;
        private ItemStack recruitCost;
        private String gender = null;
        private int voiceProfile = -1;
        private String primarySkill = null;
        private String secondarySkill = null;

        CustomVisitorData(CustomVisitorListener this$0) {
        }

        public void applyToVisitor(IVisitorData visitorData) {
            if (this.texture != null) {
                visitorData.setCustomTexture(this.texture);
            }
            if (this.gender != null) {
                visitorData.setGender(this.gender.equals("f"));
            }
            if (this.name != null) {
                visitorData.setName(this.name);
                visitorData.getEntity().ifPresent(entity -> entity.setCustomName((Component)Component.literal((String)this.name)));
            }
            if (this.citizenSuffix != null) {
                visitorData.setSuffix(this.citizenSuffix);
            }
            if (this.recruitCost != null) {
                visitorData.setRecruitCosts(this.recruitCost);
            }
            if (this.storykey != null) {
                visitorData.triggerInteraction(new RecruitmentInteraction((Component)Component.translatableEscape((String)this.storykey, (Object[])new Object[]{visitorData.getName().split(" ")[0]}), ChatPriority.IMPORTANT));
            }
            if (this.primarySkill != null) {
                visitorData.getCitizenSkillHandler().incrementLevel(Skill.valueOf(this.primarySkill), MathUtils.RANDOM.nextInt(20));
            }
            if (this.secondarySkill != null) {
                visitorData.getCitizenSkillHandler().incrementLevel(Skill.valueOf(this.secondarySkill), MathUtils.RANDOM.nextInt(20));
            }
            if (this.voiceProfile >= 0) {
                visitorData.getVoiceProfile();
            }
            visitorData.markDirty(0);
        }
    }
}

