/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.generalcommands;

import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;

public class CommandResetPlayerSupplies
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        String username = StringArgumentType.getString(context, (String)"playername");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(username);
        if (player == null) {
            if (((CommandSourceStack)context.getSource()).getEntity() instanceof Player) {
                MessageUtils.format("com.minecolonies.command.playernotfound", username).sendTo((Player)((CommandSourceStack)context.getSource()).getEntity());
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.playernotfound", (Object[])new Object[]{username}), true);
            }
            return 0;
        }
        player.awardStat(Stats.ITEM_USED.get((Object)ModItems.supplyChest), -1);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.resetsupply", (Object[])new Object[0]), true);
        MessageUtils.format("com.minecolonies.command.resetsupply", new Object[0]).sendTo(new Player[]{player});
        return 1;
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("playername", StringArgumentType.string()).executes(this::checkPreConditionAndExecute));
    }

    @Override
    public String getName() {
        return "resetsupplies";
    }
}

