/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractCraftingRequestResolver;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicWorkerCraftingRequestResolver
extends AbstractCraftingRequestResolver {
    public PublicWorkerCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token, JobEntry entry) {
        super(location, token, entry, true);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        WorkerBuildingModuleView moduleView;
        IRequester requester = manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation());
        if (requester instanceof IBuildingView && (moduleView = ((IBuildingView)requester).getModuleViewMatching(WorkerBuildingModuleView.class, m -> m.getJobEntry() == this.getJobEntry())) != null) {
            return Component.translatableEscape((String)moduleView.getJobEntry().getTranslationKey(), (Object[])new Object[0]);
        }
        if (requester instanceof IBuilding) {
            WorkerBuildingModule module = (WorkerBuildingModule)((IBuilding)requester).getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.getJobEntry());
            return Component.translatableEscape((String)module.getJobEntry().getTranslationKey(), (Object[])new Object[0]);
        }
        return super.getRequesterDisplayName(manager, request);
    }

    @Override
    public int getPriority() {
        return 125;
    }

    @Override
    public boolean canBuildingCraftRecipe(@NotNull AbstractBuilding building, IRecipeStorage recipeStorage) {
        return recipeStorage != null;
    }

    @Override
    protected IRequestable createNewRequestableForStack(ItemStack stack, int count, int minCount, IToken<?> recipeStorage) {
        return new PublicCrafting(stack, count, minCount, recipeStorage);
    }
}

