/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractCraftingProductionResolver;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateWorkerCraftingProductionResolver
extends AbstractCraftingProductionResolver<PrivateCrafting> {
    public PrivateWorkerCraftingProductionResolver(@NotNull ILocation location, @NotNull IToken<?> token, @NotNull JobEntry entry) {
        super(location, token, entry, PrivateCrafting.class);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends PrivateCrafting> completedRequest) {
        return null;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends PrivateCrafting> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends PrivateCrafting> request) {
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends PrivateCrafting> request, @NotNull AbstractBuilding building) {
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.FINALIZING);
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(request.getRequest().getRecipeID());
        if (storage == null) {
            manager.updateRequestState((IToken<?>)request.getId(), RequestState.FAILED);
            return;
        }
        ICraftingBuildingModule module = building.getCraftingModuleForRecipe(request.getRequest().getRecipeID());
        if (module == null) {
            manager.updateRequestState((IToken<?>)request.getId(), RequestState.FAILED);
            return;
        }
        for (int i = 0; i < request.getRequest().getCount(); ++i) {
            module.fullFillRecipe(storage);
        }
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
    }
}

