/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.workorders.IServerWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.ColonyView;
import com.minecolonies.core.colony.permissions.Permissions;
import com.minecolonies.core.network.messages.PermissionsMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewWorkOrderMessage;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class ColonyPackageManager
implements IColonyPackageManager {
    @NotNull
    private Set<ServerPlayer> closeSubscribers = new HashSet<ServerPlayer>();
    private Set<ServerPlayer> importantColonyPlayers = new HashSet<ServerPlayer>();
    private Set<ServerPlayer> newSubscribers = new HashSet<ServerPlayer>();
    private boolean isDirty = false;
    private int ticksPassed = 0;
    private int lastContactInHours = 0;
    private final Colony colony;

    public ColonyPackageManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public void setLastContactInHours(int lastContactInHours) {
        this.lastContactInHours = lastContactInHours;
    }

    @Override
    public Set<ServerPlayer> getCloseSubscribers() {
        return this.closeSubscribers;
    }

    @Override
    public void updateSubscribers() {
        ServerLevel world = this.colony.getWorld();
        if (world == null || world.getServer() == null) {
            return;
        }
        this.updateClosePlayers();
        this.updateColonyViews();
    }

    private void updateClosePlayers() {
        Iterator<ServerPlayer> iterator = this.closeSubscribers.iterator();
        while (iterator.hasNext()) {
            ServerPlayer player = iterator.next();
            if (!player.isAlive() || this.colony.getWorld() != player.level() || !WorldUtil.isChunkLoaded((LevelAccessor)player.level(), player.chunkPosition().x, player.chunkPosition().z)) {
                iterator.remove();
                continue;
            }
            LevelChunk chunk = this.colony.getWorld().getChunk(player.chunkPosition().x, player.chunkPosition().z);
            if (chunk.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (ColonyUtils.getOwningColony((ChunkAccess)chunk) == this.colony.getID()) continue;
            iterator.remove();
        }
    }

    @Override
    public void updateAwayTime() {
        if (this.importantColonyPlayers.isEmpty()) {
            if (this.ticksPassed >= 72000) {
                this.ticksPassed = 0;
                ++this.lastContactInHours;
                this.colony.markDirty();
            }
            this.ticksPassed += 100;
        } else if (this.lastContactInHours != 0) {
            this.lastContactInHours = 0;
            this.ticksPassed = 0;
            this.colony.markDirty();
        }
    }

    public void updateColonyViews() {
        if (!this.closeSubscribers.isEmpty() || !this.newSubscribers.isEmpty()) {
            this.sendColonyViewPackets();
            this.sendPermissionsPackets();
            this.sendWorkOrderPackets();
            this.colony.getCitizenManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.colony.getVisitorManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.colony.getBuildingManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.colony.getResearchManager().sendPackets(this.closeSubscribers, this.newSubscribers);
        }
        if (this.newSubscribers.isEmpty()) {
            this.isDirty = false;
        }
        this.colony.getPermissions().clearDirty();
        this.colony.getBuildingManager().clearDirty();
        this.colony.getCitizenManager().clearDirty();
        this.colony.getVisitorManager().clearDirty();
        this.colony.getResearchManager().clearDirty();
        this.newSubscribers = new HashSet<ServerPlayer>();
    }

    @Override
    public void sendColonyViewPackets() {
        if (this.isDirty || !this.newSubscribers.isEmpty()) {
            RegistryFriendlyByteBuf colonyFriendlyByteBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), this.colony.getWorld().registryAccess());
            ColonyView.serializeNetworkData(this.colony, colonyFriendlyByteBuf, !this.newSubscribers.isEmpty());
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isDirty) {
                players.addAll(this.closeSubscribers);
            }
            players.addAll(this.newSubscribers);
            for (ServerPlayer player : players) {
                new ColonyViewMessage(this.colony, colonyFriendlyByteBuf, this.newSubscribers.contains(player)).sendToPlayer(player);
            }
        }
        this.colony.getRequestManager().setDirty(false);
    }

    @Override
    public void sendPermissionsPackets() {
        Permissions permissions = this.colony.getPermissions();
        if (permissions.isDirty() || !this.newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isDirty) {
                players.addAll(this.closeSubscribers);
            }
            players.addAll(this.newSubscribers);
            players.forEach(player -> new PermissionsMessage.View(this.colony, permissions.getRank((Player)player)).sendToPlayer((ServerPlayer)player));
        }
    }

    @Override
    public void sendWorkOrderPackets() {
        IWorkManager workManager = this.colony.getWorkManager();
        if (workManager.isDirty() || !this.newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            players.addAll(this.closeSubscribers);
            players.addAll(this.newSubscribers);
            ArrayList<IServerWorkOrder> workOrders = new ArrayList<IServerWorkOrder>(workManager.getWorkOrders().values());
            new ColonyViewWorkOrderMessage(this.colony, workOrders).sendToPlayer(players);
            workManager.setDirty(false);
        }
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public void addCloseSubscriber(@NotNull ServerPlayer subscriber) {
        if (subscriber instanceof FakePlayer) {
            Log.getLogger().warn("Adding fakeplayer as subscriber: this should not happen", (Throwable)new Exception());
            return;
        }
        if (!this.closeSubscribers.contains(subscriber)) {
            this.closeSubscribers.add(subscriber);
            this.newSubscribers.add(subscriber);
            this.updateColonyViews();
        }
    }

    @Override
    public void removeCloseSubscriber(@NotNull ServerPlayer player) {
        this.newSubscribers.remove(player);
        this.closeSubscribers.remove(player);
    }

    @Override
    public void addImportantColonyPlayer(@NotNull ServerPlayer subscriber) {
        if (subscriber instanceof FakePlayer) {
            Log.getLogger().warn("Adding fakeplayer as important subscriber: this should not happen", (Throwable)new Exception());
            return;
        }
        this.importantColonyPlayers.add(subscriber);
        this.newSubscribers.add(subscriber);
    }

    @Override
    public void removeImportantColonyPlayer(@NotNull ServerPlayer subscriber) {
        this.importantColonyPlayers.remove(subscriber);
        this.newSubscribers.remove(subscriber);
    }

    @Override
    public Set<ServerPlayer> getImportantColonyPlayers() {
        return this.importantColonyPlayers;
    }
}

