/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.constant.CitizenConstants;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.LumberjackAssignmentModule;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.entity.ai.workers.production.EntityAIWorkLumberjack;
import com.minecolonies.core.entity.ai.workers.util.Tree;
import com.minecolonies.core.util.AttributeModifierUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLumberjack
extends AbstractJobCrafter<EntityAIWorkLumberjack, JobLumberjack> {
    public static final double BONUS_SPEED_PER_LEVEL = 0.003;
    @Nullable
    private Tree tree;

    public JobLumberjack(ICitizenData entity) {
        super(entity);
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        @NotNull CompoundTag treeTag = new CompoundTag();
        if (this.tree != null) {
            this.tree.write(provider, treeTag);
        }
        compound.put("Tree", (Tag)treeTag);
        return compound;
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.LUMBERJACK_ID;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        if (compound.contains("Tree")) {
            this.tree = Tree.read(provider, compound.getCompound("Tree"));
            if (!this.tree.isTree()) {
                this.tree = null;
            }
        }
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            AttributeModifier speedModifier = new AttributeModifier(CitizenConstants.SKILL_BONUS_ADD_NAME, (double)this.getCitizen().getCitizenSkillHandler().getLevel(((LumberjackAssignmentModule)this.getCitizen().getWorkBuilding().getModule(BuildingModules.FORESTER_WORK)).getSecondarySkill()) / 2.0 * 0.003, AttributeModifier.Operation.ADD_VALUE);
            AttributeModifierUtils.addModifier((LivingEntity)worker, speedModifier, (Holder<Attribute>)Attributes.MOVEMENT_SPEED);
        }
    }

    @Nullable
    public Tree getTree() {
        return this.tree;
    }

    public void setTree(@Nullable Tree tree) {
        this.tree = tree;
    }

    @Override
    @NotNull
    public EntityAIWorkLumberjack generateAI() {
        return new EntityAIWorkLumberjack(this);
    }

    @Override
    public double getSaturationFactor() {
        return 1.2;
    }
}

