/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid;

import com.ldtteam.structurize.api.RotationMirror;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.happiness.ExpirationBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingGuardTower;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.colony.events.raid.AbstractShipRaidEvent;
import com.minecolonies.core.colony.events.raid.HordeRaidEvent;
import com.minecolonies.core.colony.events.raid.amazonevent.AmazonRaidEvent;
import com.minecolonies.core.colony.events.raid.barbarianEvent.BarbarianRaidEvent;
import com.minecolonies.core.colony.events.raid.barbarianEvent.Horde;
import com.minecolonies.core.colony.events.raid.egyptianevent.EgyptianRaidEvent;
import com.minecolonies.core.colony.events.raid.norsemenevent.NorsemenRaidEvent;
import com.minecolonies.core.colony.events.raid.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.DrownedPirateRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.PirateRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipSize;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSkillHandler;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobRaiderPathing;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.network.messages.client.PlayAudioMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaidManager
implements IRaiderManager {
    public static final double SPAWN_MODIFIER = 60.0;
    private static final int MIN_BUILDING_SPAWN_DIST = 35;
    private static final double LOST_CITIZEN_DIFF_REDUCE_PCT = 0.15;
    private static final double LOST_CITIZEN_DIFF_INCREASE_PCT = 0.05;
    private static final int MIN_RAID_DIFFICULTY = 1;
    private static final int MAX_RAID_DIFFICULTY = 14;
    private static final double MIN_DIFFICULTY_MODIFIER = 0.2;
    private static final String TAG_RAID_DIFFICULTY = "difficulty";
    private static final String TAG_RAID_DELAY = "delay";
    private static final String TAG_LOST_CITIZENS = "lostCitizens";
    public static final int MIN_REQUIRED_RAIDLEVEL = 75;
    private static final double INCREASE_PER_PLAYER = 0.05;
    private static final int IGNORE_BIOME_CHANCE = 2;
    private static final int INITIAL_RAID_DIFFICULTY = 7;
    private int raidDifficulty = 7;
    private double spawnCountAdjustedDifficulty = 1.0;
    private static final boolean INITIAL_CAN_HAVE_BARB_EVENTS = true;
    private boolean haveRaiderEvents = true;
    private static final int INITIAL_NIGHTS_SINCE_LAST_RAID = 0;
    private int nightsSinceLastRaid = 0;
    private final Colony colony;
    private boolean spiesEnabled;
    private BlockPos lastBuilding;
    private int buildingPosUsage = 0;
    @Nullable
    private IRaiderManager.RaidSettings nextRaid = null;
    private final List<RaidHistory> raidHistories = new ArrayList<RaidHistory>();
    private long passingThroughRaidTime = 0L;
    private int extraDaysToNextRaid = 0;

    public RaidManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public boolean canHaveRaiderEvents() {
        return this.haveRaiderEvents;
    }

    @Override
    public boolean willRaidTonight() {
        return this.nextRaid != null;
    }

    @Override
    public void setCanHaveRaiderEvents(boolean canHave) {
        this.haveRaiderEvents = canHave;
    }

    @Override
    public void setRaidNextNight(IRaiderManager.RaidSettings raidSettings) {
        this.nextRaid = raidSettings;
    }

    @Override
    public boolean areSpiesEnabled() {
        return this.spiesEnabled;
    }

    @Override
    public void setSpiesEnabled(boolean enabled) {
        if (this.spiesEnabled != enabled) {
            this.colony.markDirty();
        }
        this.spiesEnabled = enabled;
    }

    @Override
    public IRaiderManager.RaidSpawnResult raiderEvent(@NotNull IRaiderManager.RaidSettings raidSettings) {
        int amount;
        if (this.colony.getWorld() == null) {
            return IRaiderManager.RaidSpawnResult.ERROR;
        }
        if (!raidSettings.forcedSpawn() && !this.canRaid()) {
            return IRaiderManager.RaidSpawnResult.CANNOT_RAID;
        }
        int raidLevel = this.getColonyRaidLevel();
        if (raidSettings.raiderAmount() != null) {
            this.spawnCountAdjustedDifficulty = 1.0;
            amount = raidSettings.raiderAmount();
        } else {
            amount = this.calculateRaiderAmount(raidLevel);
            if (amount <= 0 || raidLevel < 75) {
                return IRaiderManager.RaidSpawnResult.TOO_SMALL;
            }
            this.spawnCountAdjustedDifficulty = 1.0;
            if (amount >= (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxRaiders.get()) {
                this.spawnCountAdjustedDifficulty = (double)amount / (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxRaiders.get()).intValue();
            }
        }
        HashSet<BlockPos> spawnPoints = new HashSet<BlockPos>();
        if (raidSettings.location() != null) {
            spawnPoints.add(raidSettings.location());
        } else {
            int raidCount = Math.max(1, amount / 20);
            int retries = 0;
            for (int i = 0; i < raidCount; ++i) {
                BlockPos targetSpawnPoint = this.calculateSpawnLocation();
                if (targetSpawnPoint == null || targetSpawnPoint.equals((Object)this.colony.getCenter()) || !this.colony.getWorld().getWorldBorder().isWithinBounds(targetSpawnPoint)) {
                    if (retries >= 10) continue;
                    ++retries;
                    --i;
                    continue;
                }
                spawnPoints.add(targetSpawnPoint);
            }
        }
        if (spawnPoints.isEmpty()) {
            return IRaiderManager.RaidSpawnResult.NO_SPAWN_POINT;
        }
        this.raidHistories.add(new RaidHistory(amount, this.colony.getWorld().getGameTime()));
        this.nightsSinceLastRaid = 0;
        this.nextRaid = null;
        amount = (int)Math.ceil((float)amount / (float)spawnPoints.size());
        for (BlockPos targetSpawnPoint : spawnPoints) {
            IColonyRaidEvent raidEvent;
            if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableInDevelopmentFeatures.get()).booleanValue()) {
                MessageUtils.format((Component)Component.literal((String)("Horde Spawn Point: " + String.valueOf(targetSpawnPoint)))).sendTo(this.colony).forAllPlayers();
            }
            BlockState aboveState = this.colony.getWorld().getBlockState(targetSpawnPoint.above());
            BlockState spawnState = this.colony.getWorld().getBlockState(targetSpawnPoint);
            BlockState belowState = this.colony.getWorld().getBlockState(targetSpawnPoint.below());
            if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).skyRaiders.get()).booleanValue() && spawnState.isAir() && belowState.isAir()) {
                raidSettings = raidSettings.withExplicitType(PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.getPath());
            } else if ((raidSettings.raidType() == null || Objects.equals(raidSettings.raidType(), DrownedPirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.getPath())) && (PathfindingUtils.isWater((BlockGetter)this.colony.getWorld(), targetSpawnPoint.above(), aboveState, null) || ColonyConstants.rand.nextInt(100) <= 20) && PathfindingUtils.isWater((BlockGetter)this.colony.getWorld(), targetSpawnPoint, spawnState, null) && PathfindingUtils.isWater((BlockGetter)this.colony.getWorld(), targetSpawnPoint.below(), belowState, null)) {
                raidSettings = raidSettings.withExplicitType(DrownedPirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.getPath());
                for (int i = 0; i < 13 && PathfindingUtils.isLiquid(this.colony.getWorld().getBlockState(targetSpawnPoint.above())); ++i) {
                    targetSpawnPoint = targetSpawnPoint.above();
                }
            }
            RotationMirror shipRotMir = RotationMirror.of((Rotation)Rotation.values()[this.colony.getWorld().random.nextInt(4)], (Mirror)Mirror.NONE);
            Holder biome = this.colony.getWorld().getBiome(this.colony.getCenter());
            int rand = this.colony.getWorld().random.nextInt(100);
            if (raidSettings.allowShips() && (raidSettings.raidType() == null && (biome.is(BiomeTags.IS_TAIGA) || rand < 2) || Objects.equals(raidSettings.raidType(), NorsemenRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.getPath())) && ShipBasedRaiderUtils.canSpawnShipAt(this.colony, targetSpawnPoint, amount, shipRotMir, "norsemen_ship")) {
                event = new NorsemenShipRaidEvent(this.colony);
                ((AbstractShipRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((AbstractShipRaidEvent)event).setShipSize(ShipSize.getShipForRaiderAmount(amount));
                ((AbstractShipRaidEvent)event).setShipRotation(shipRotMir);
                ((AbstractShipRaidEvent)event).setSpawnPath(this.createSpawnPath(targetSpawnPoint, false));
                ((AbstractShipRaidEvent)event).setMaxRaiderCount(amount * 2);
                raidEvent = event;
                this.colony.getEventManager().addEvent(event);
            } else if (raidSettings.allowShips() && (raidSettings.raidType() == null && biome.is(BiomeTags.IS_OCEAN) || Objects.equals(raidSettings.raidType(), DrownedPirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.getPath())) && ShipBasedRaiderUtils.canSpawnShipAt(this.colony, targetSpawnPoint, amount, shipRotMir, "sunk_ship", 13)) {
                event = new DrownedPirateRaidEvent(this.colony);
                ((AbstractShipRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((AbstractShipRaidEvent)event).setShipSize(ShipSize.getShipForRaiderAmount(amount));
                ((AbstractShipRaidEvent)event).setShipRotation(shipRotMir);
                ((AbstractShipRaidEvent)event).setSpawnPath(this.createSpawnPath(targetSpawnPoint, true));
                ((AbstractShipRaidEvent)event).setMaxRaiderCount(amount * 2);
                raidEvent = event;
                this.colony.getEventManager().addEvent(event);
            } else if (raidSettings.allowShips() && ShipBasedRaiderUtils.canSpawnShipAt(this.colony, targetSpawnPoint, amount, shipRotMir, "pirate_ship") && (raidSettings.raidType() == null || raidSettings.raidType().equals(PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.getPath()))) {
                event = new PirateRaidEvent(this.colony);
                ((AbstractShipRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((AbstractShipRaidEvent)event).setShipSize(ShipSize.getShipForRaiderAmount(amount));
                ((AbstractShipRaidEvent)event).setShipRotation(shipRotMir);
                ((AbstractShipRaidEvent)event).setSpawnPath(this.createSpawnPath(targetSpawnPoint, false));
                ((AbstractShipRaidEvent)event).setMaxRaiderCount(amount * 2);
                raidEvent = event;
                this.colony.getEventManager().addEvent(event);
            } else {
                if ((biome.is(BiomeTags.HAS_DESERT_PYRAMID) || rand > 2 && rand < 4) && raidSettings.raidType() == null || Objects.equals(raidSettings.raidType(), EgyptianRaidEvent.EGYPTIAN_RAID_EVENT_TYPE_ID.getPath())) {
                    event = new EgyptianRaidEvent(this.colony);
                } else if ((biome.is(BiomeTags.IS_JUNGLE) || rand > 4 && rand < 6) && raidSettings.raidType() == null || Objects.equals(raidSettings.raidType(), AmazonRaidEvent.AMAZON_RAID_EVENT_TYPE_ID.getPath())) {
                    event = new AmazonRaidEvent(this.colony);
                } else if ((biome.is(BiomeTags.IS_TAIGA) || rand > 6 && rand < 8) && raidSettings.raidType() == null || Objects.equals(raidSettings.raidType(), NorsemenRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.getPath())) {
                    event = new NorsemenRaidEvent(this.colony);
                } else if (Objects.equals(raidSettings.raidType(), PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.getPath())) {
                    event = new PirateGroundRaidEvent(this.colony);
                } else if (raidSettings.raidType() == null || raidSettings.raidType().equals(BarbarianRaidEvent.BARBARIAN_RAID_EVENT_TYPE_ID.getPath())) {
                    event = new BarbarianRaidEvent(this.colony);
                } else {
                    return IRaiderManager.RaidSpawnResult.NO_SPAWN_POINT;
                }
                ((HordeRaidEvent)event).setSpawnPoint(targetSpawnPoint);
                ((HordeRaidEvent)event).setHorde(new Horde(amount));
                ((HordeRaidEvent)event).setSpawnPath(this.createSpawnPath(targetSpawnPoint, false));
                raidEvent = event;
                this.colony.getEventManager().addEvent(event);
            }
            this.getLastRaid().spawnData.add(new RaidSpawnInfo(raidEvent.getEventTypeID(), targetSpawnPoint));
            this.getLastRaid().difficulty = (double)((int)(this.getRaidDifficultyModifier() * 100.0)) / 100.0;
        }
        this.colony.markDirty();
        return IRaiderManager.RaidSpawnResult.SUCCESS;
    }

    private PathResult<?> createSpawnPath(BlockPos targetSpawnPoint, boolean underwater) {
        BlockPos closestBuildingPos = this.colony.getBuildingManager().getBestBuilding(targetSpawnPoint, IBuilding.class);
        PathJobRaiderPathing job = new PathJobRaiderPathing(new ArrayList<IBuilding>(this.colony.getBuildingManager().getBuildings().values()), (Level)this.colony.getWorld(), closestBuildingPos, targetSpawnPoint);
        job.getPathingOptions().withWalkUnderWater(underwater);
        job.getResult().startJob(Pathfinding.getExecutor());
        return job.getResult();
    }

    @Override
    public BlockPos calculateSpawnLocation() {
        BlockPos locationSum = new BlockPos(0, 0, 0);
        int amount = 0;
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            if (!WorldUtil.isEntityBlockLoaded((LevelAccessor)this.colony.getWorld(), building.getPosition())) continue;
            ++amount;
            locationSum = locationSum.offset((Vec3i)building.getPosition());
        }
        if (amount == 0) {
            Log.getLogger().info("Trying to spawn raid on colony with no loaded buildings, aborting! Colony:" + this.colony.getID() + " buildings:" + this.colony.getBuildingManager().getBuildings().size() + " isActive:" + this.colony.isActive() + " colony state:" + String.valueOf(this.colony.getState()));
            return null;
        }
        BlockPos calcCenter = new BlockPos(locationSum.getX() / amount, locationSum.getY() / amount, locationSum.getZ() / amount);
        int degree = this.colony.getWorld().random.nextInt(360);
        int x = (int)Math.round(500.0 * Math.cos(Math.toRadians(degree)));
        int z = (int)Math.round(500.0 * Math.sin(Math.toRadians(degree)));
        BlockPos advanceTowards = calcCenter.offset(x, 0, z);
        BlockPos spawnPos = null;
        BlockPos closestBuilding = this.colony.getBuildingManager().getBestBuilding(advanceTowards, IBuilding.class);
        if (closestBuilding == null) {
            return null;
        }
        BlockPos worldSpawnPos = null;
        for (int i = 0; i < 8; ++i) {
            spawnPos = this.findSpawnPointInDirections(new BlockPos(closestBuilding.getX(), calcCenter.getY(), closestBuilding.getZ()), advanceTowards);
            if (spawnPos == null) continue;
            worldSpawnPos = BlockPosUtil.findAround((Level)this.colony.getWorld(), BlockPosUtil.getFloor(spawnPos, (Level)this.colony.getWorld()), 30, 3, BlockPosUtil.SOLID_AIR_POS_SELECTOR);
            if (worldSpawnPos == null && this.colony.getWorld().getBlockState(spawnPos).getBlock() == Blocks.WATER) {
                worldSpawnPos = spawnPos;
                break;
            }
            if (worldSpawnPos != null || ((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).skyRaiders.get()).booleanValue()) break;
        }
        if (spawnPos == null) {
            return null;
        }
        if (worldSpawnPos == null && ((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).skyRaiders.get()).booleanValue()) {
            worldSpawnPos = BlockPosUtil.findAround((Level)this.colony.getWorld(), BlockPosUtil.getFloor(spawnPos, (Level)this.colony.getWorld()), 15, 10, BlockPosUtil.DOUBLE_AIR_POS_SELECTOR);
        }
        return worldSpawnPos;
    }

    private BlockPos findSpawnPointInDirections(BlockPos start, BlockPos advancePos) {
        BlockPos spawnPos = new BlockPos((Vec3i)start);
        BlockPos tempPos = new BlockPos(spawnPos.getX(), spawnPos.getY(), spawnPos.getZ());
        Collection<IBuilding> buildings = this.colony.getBuildingManager().getBuildings().values();
        int xDiff = Math.abs(start.getX() - advancePos.getX());
        int zDiff = Math.abs(start.getZ() - advancePos.getZ());
        Vec3 xzRatio = new Vec3((double)(xDiff * (start.getX() < advancePos.getX() ? 1 : -1)), 0.0, (double)(zDiff * (start.getZ() < advancePos.getZ() ? 1 : -1)));
        xzRatio = xzRatio.normalize().scale(3.0);
        int validChunkCount = 0;
        for (int i = 0; i < 10 && WorldUtil.isEntityBlockLoaded((LevelAccessor)this.colony.getWorld(), tempPos); ++i) {
            tempPos = tempPos.offset((int)(16.0 * xzRatio.x), 0, (int)(16.0 * xzRatio.z));
            if (!WorldUtil.isEntityBlockLoaded((LevelAccessor)this.colony.getWorld(), tempPos)) break;
            if (!RaidManager.isValidSpawnPoint(buildings, tempPos) || this.isOtherColony(tempPos.getX(), tempPos.getZ())) continue;
            spawnPos = tempPos;
            if (++validChunkCount <= 2 && i <= 2) continue;
            return spawnPos;
        }
        if (!spawnPos.equals((Object)start)) {
            return spawnPos;
        }
        return null;
    }

    private boolean isOtherColony(int x, int z) {
        int owningColonyId = ColonyUtils.getOwningColony((ChunkAccess)this.colony.getWorld().getChunk(x >> 4, z >> 4));
        return owningColonyId != 0 && owningColonyId != this.colony.getID();
    }

    public static boolean isValidSpawnPoint(Collection<IBuilding> buildings, BlockPos spawnPos) {
        for (IBuilding building : buildings) {
            if (building.getBuildingLevel() == 0) continue;
            int minDist = 35;
            minDist = building instanceof BuildingGuardTower ? (minDist += building.getBuildingLevel() * 7) : (building.hasModule(LivingBuildingModule.class) ? (minDist += building.getBuildingLevel() * 4) : (building instanceof BuildingTownHall ? (minDist += building.getBuildingLevel() * 8) : (minDist += building.getBuildingLevel() * 2)));
            if (BlockPosUtil.getDistance2D(building.getPosition(), spawnPos) >= (long)minDist) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        if (this.raidHistories.isEmpty()) {
            return List.of();
        }
        RaidHistory last = this.raidHistories.getLast();
        return last.spawnData.stream().map(raidSpawnInfo -> raidSpawnInfo.spawnpos).collect(Collectors.toList());
    }

    @Override
    public int calculateRaiderAmount(int raidLevel) {
        int nearbyColonyPlayers = 0;
        for (Player player : this.colony.getMessagePlayerEntities()) {
            if (player.isSpectator()) continue;
            ++nearbyColonyPlayers;
        }
        return 1 + Math.min((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxRaiders.get(), (int)((double)raidLevel / 60.0 * this.getRaidDifficultyModifier() * (1.0 + (double)nearbyColonyPlayers * 0.05) * (ColonyConstants.rand.nextDouble() * 0.3 + 0.85)));
    }

    @Override
    public boolean isRaided() {
        if (this.colony.getWorld().getGameTime() <= this.passingThroughRaidTime) {
            return true;
        }
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            IColonyRaidEvent raidEvent;
            if (!(event instanceof IColonyRaidEvent) || !(raidEvent = (IColonyRaidEvent)event).isRaidActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNightFall() {
        if (!this.isRaided() || this.passingThroughRaidTime > 0L) {
            if (this.nightsSinceLastRaid == 0 && !this.raidHistories.isEmpty()) {
                RaidHistory history = this.raidHistories.get(this.raidHistories.size() - 1);
                double lostPct = (double)history.lostCitizens / (double)this.colony.getCitizenManager().getMaxCitizens();
                if (lostPct > 0.15) {
                    this.raidDifficulty = Math.max(1, this.raidDifficulty - (int)(lostPct / 0.15));
                    this.extraDaysToNextRaid = Mth.ceil((double)((double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).averageNumberOfNightsBetweenRaids.get()).intValue() * 0.4));
                } else if (lostPct < 0.05) {
                    this.raidDifficulty = Math.min(14, this.raidDifficulty + 1);
                }
            }
            ++this.nightsSinceLastRaid;
        } else {
            this.nightsSinceLastRaid = 0;
        }
        if (this.nextRaid != null) {
            IRaiderManager.RaidSpawnResult result = this.raiderEvent(this.nextRaid);
            if (result == IRaiderManager.RaidSpawnResult.SUCCESS || result == IRaiderManager.RaidSpawnResult.TOO_SMALL) {
                this.extraDaysToNextRaid = 0;
                this.nextRaid = null;
            }
        } else {
            this.determineRaidForNextDay();
        }
    }

    @Override
    public int getNightsSinceLastRaid() {
        return this.nightsSinceLastRaid;
    }

    @Override
    public void setNightsSinceLastRaid(int nightsSinceLastRaid) {
        this.nightsSinceLastRaid = nightsSinceLastRaid;
    }

    @Override
    public boolean canRaid() {
        return !WorldUtil.isPeaceful((Level)this.colony.getWorld()) && (Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableColonyRaids.get() != false && this.colony.getRaiderManager().canHaveRaiderEvents() && !this.colony.getPackageManager().getImportantColonyPlayers().isEmpty();
    }

    private void determineRaidForNextDay() {
        boolean raid;
        boolean bl = raid = this.canRaid() && this.raidThisNight((Level)this.colony.getWorld(), this.colony);
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).enableInDevelopmentFeatures.get()).booleanValue()) {
            MessageUtils.format((Component)Component.literal((String)("Will raid tomorrow: " + raid))).sendTo(this.colony).forAllPlayers();
        }
        this.setRaidNextNight(raid ? IRaiderManager.RaidSettings.defaultRaidSettings() : null);
    }

    @Override
    public int getColonyRaidLevel() {
        int levels = 0;
        for (ICitizenData data : this.colony.getCitizenManager().getCitizens()) {
            if (data.isChild()) continue;
            levels += 5;
            int skillSum = 0;
            for (CitizenSkillHandler.SkillData skillData : data.getCitizenSkillHandler().getSkills().values()) {
                skillSum += skillData.getLevel();
            }
            levels += skillSum / 100;
        }
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            if (building.getBuildingLevel() <= 0) continue;
            levels += 5 + building.getBuildingLevel() * building.getBuildingLevel() / 5;
        }
        double populationFactor = Math.min(1.0, (double)this.colony.getCitizenManager().getCurrentCitizenCount() / (double)this.colony.getCitizenManager().getMaxCitizens());
        return (int)((double)(levels += this.colony.getResearchManager().getResearchTree().getCompletedList().size() * 3) * populationFactor);
    }

    private boolean raidThisNight(Level world, IColony colony) {
        if (this.nightsSinceLastRaid < (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minimumNumberOfNightsBetweenRaids.get() + this.extraDaysToNextRaid) {
            return false;
        }
        if (this.nightsSinceLastRaid > (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).averageNumberOfNightsBetweenRaids.get() + 2) {
            return true;
        }
        return world.random.nextDouble() < 1.0 / (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).averageNumberOfNightsBetweenRaids.get() - (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minimumNumberOfNightsBetweenRaids.get());
    }

    @Override
    @NotNull
    public BlockPos getRandomBuilding() {
        ++this.buildingPosUsage;
        if (this.buildingPosUsage > Math.max(6, this.getLastRaid().raiderAmount / 3) || this.lastBuilding == null) {
            this.buildingPosUsage = 0;
            Collection<IBuilding> buildingList = this.colony.getBuildingManager().getBuildings().values();
            Object[] buildingArray = buildingList.toArray();
            if (buildingArray.length != 0) {
                int rand = this.colony.getWorld().random.nextInt(buildingArray.length);
                IBuilding building = (IBuilding)buildingArray[rand];
                if (this.lastBuilding != null) {
                    ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
                    for (ICitizenData entry : this.colony.getCitizenManager().getCitizens()) {
                        if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || BlockPosUtil.getDistanceSquared(entry.getEntity().get().blockPosition(), this.lastBuilding) >= 5625L || entry.getJob().getWorkerAI() == null || !((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).canHelp(building.getPosition())) continue;
                        possibleGuards.add(entry.getEntity().get());
                    }
                    possibleGuards.sort(Comparator.comparingInt(guard -> (int)this.lastBuilding.distSqr((Vec3i)guard.blockPosition())));
                    for (int i = 0; i < possibleGuards.size() && i <= 3; ++i) {
                        ((AbstractBuildingGuards)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getWorkBuilding()).setTempNextPatrolPoint(this.lastBuilding);
                    }
                }
                this.lastBuilding = building.getPosition();
            } else {
                this.lastBuilding = this.colony.getCenter();
            }
        }
        return this.lastBuilding;
    }

    @Override
    public double getRaidDifficultyModifier() {
        return ((double)this.raidDifficulty / 10.0 + 0.2) * ((double)((Integer)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).raidDifficulty.get()).intValue() / 5.0) * ((double)this.colony.getWorld().getDifficulty().getId() / 2.0) * this.spawnCountAdjustedDifficulty;
    }

    @Override
    public void onLostCitizen(ICitizenData citizen) {
        if (!this.isRaided()) {
            return;
        }
        if (this.raidHistories.isEmpty()) {
            return;
        }
        RaidHistory history = this.raidHistories.get(this.raidHistories.size() - 1);
        history.lostCitizens = citizen.getJob() instanceof AbstractJobGuard ? ++history.lostCitizens : (history.lostCitizens += 2);
        if ((double)history.lostCitizens / (double)this.colony.getCitizenManager().getMaxCitizens() > 0.5) {
            for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
                if (!(event instanceof IColonyRaidEvent)) continue;
                IColonyRaidEvent raidEvent = (IColonyRaidEvent)event;
                raidEvent.setStatus(EventStatus.DONE);
            }
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.putBoolean("raidable", this.canHaveRaiderEvents());
        compound.putInt("nightsRaid", this.getNightsSinceLastRaid());
        compound.putInt(TAG_RAID_DIFFICULTY, this.raidDifficulty);
        compound.putInt(TAG_RAID_DELAY, this.extraDaysToNextRaid);
        ListTag nbtList = new ListTag();
        for (RaidHistory history : this.raidHistories) {
            nbtList.add((Object)history.write());
        }
        compound.put("raidhistory", (Tag)nbtList);
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.contains("raidable")) {
            this.setCanHaveRaiderEvents(compound.getBoolean("raidable"));
        } else {
            this.setCanHaveRaiderEvents(true);
        }
        if (compound.contains("nightsRaid")) {
            this.setNightsSinceLastRaid(compound.getInt("nightsRaid"));
        }
        if (compound.contains(TAG_RAID_DELAY)) {
            this.extraDaysToNextRaid = compound.getInt(TAG_RAID_DELAY);
        }
        this.raidDifficulty = Mth.clamp((int)compound.getInt(TAG_RAID_DIFFICULTY), (int)1, (int)14);
        if (compound.contains("raidhistory")) {
            this.raidHistories.clear();
            ListTag nbtList = compound.getList("raidhistory", 10);
            for (Tag tag : nbtList) {
                this.raidHistories.add(RaidHistory.fromNBT((CompoundTag)tag));
            }
        }
    }

    @Override
    public int getLostCitizen() {
        if (this.raidHistories.isEmpty()) {
            return 0;
        }
        return this.raidHistories.get((int)(this.raidHistories.size() - 1)).lostCitizens;
    }

    @Override
    public void onRaiderDeath(AbstractEntityMinecoloniesRaider entity) {
        RaidHistory last = this.getLastRaid();
        if (last != null) {
            ++last.deadRaiders;
        }
    }

    @Override
    public void onRaidEventFinished(IColonyRaidEvent finishedRaid) {
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            IColonyRaidEvent raidEvent;
            if (!(event instanceof IColonyRaidEvent) || (raidEvent = (IColonyRaidEvent)event).getStatus() != EventStatus.PROGRESSING) continue;
            return;
        }
        if ((double)this.raidHistories.get((int)0).lostCitizens / (double)this.colony.getCitizenManager().getMaxCitizens() > 0.5) {
            MessageUtils.format("com.minecolonies.core.barbarians.mercy", this.colony.getName()).sendTo(this.colony).forManagers();
            this.extraDaysToNextRaid = (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).averageNumberOfNightsBetweenRaids.get() * 2;
        } else {
            Object msgID = "com.minecolonies.coremod.barbarians.killed";
            int rng = ColonyConstants.rand.nextInt(3);
            if (rng > 0) {
                msgID = (String)msgID + rng;
            }
            MessageUtils.format((String)msgID, this.colony.getName()).sendTo(this.colony).forManagers();
        }
        PlayAudioMessage audio = new PlayAudioMessage(this.raidHistories.get((int)0).raiderAmount <= 5 ? RaidSounds.VICTORY_EARLY : RaidSounds.VICTORY, SoundSource.HOSTILE);
        PlayAudioMessage.sendToAll(this.colony, false, true, audio);
        if (this.colony.getRaiderManager().getLostCitizen() == 0) {
            this.colony.getCitizenManager().injectModifier(new ExpirationBasedHappinessModifier("raidwithoutdeath", 1.0, new StaticHappinessSupplier(2.0), 3));
        }
    }

    public RaidHistory getLastRaid() {
        if (this.raidHistories.isEmpty()) {
            return null;
        }
        return this.raidHistories.get(this.raidHistories.size() - 1);
    }

    @Override
    public void setPassThroughRaid() {
        this.passingThroughRaidTime = this.colony.getWorld().getGameTime() + 400L;
    }

    public List<RaidHistory> getAllRaids() {
        return new ArrayList<RaidHistory>(this.raidHistories);
    }

    public static class RaidHistory {
        static final String TAG_LOSTCITIZENS = "lostCitizens";
        static final String TAG_RAIDERAMOUNT = "raiderAmount";
        static final String TAG_RAIDTIME = "raidTime";
        static final String TAG_DIFFICULTY = "difficulty";
        static final String TAG_SPAWNINFO = "spawnInfo";
        public int lostCitizens = 0;
        public final int raiderAmount;
        public int deadRaiders = 0;
        public final long raidTime;
        public double difficulty = 0.0;
        public final List<RaidSpawnInfo> spawnData = new ArrayList<RaidSpawnInfo>();

        public RaidHistory(int raiderAmount, long raidTime) {
            this.raidTime = raidTime;
            this.raiderAmount = raiderAmount;
        }

        private CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("lostCitizens", this.lostCitizens);
            tag.putInt(TAG_RAIDERAMOUNT, this.raiderAmount);
            tag.putLong(TAG_RAIDTIME, this.raidTime);
            tag.putDouble("difficulty", this.difficulty);
            ListTag nbtList = new ListTag();
            for (RaidSpawnInfo raidSpawnInfo : this.spawnData) {
                nbtList.add((Object)raidSpawnInfo.write());
            }
            tag.put(TAG_SPAWNINFO, (Tag)nbtList);
            return tag;
        }

        private static RaidHistory fromNBT(CompoundTag tag) {
            RaidHistory history = new RaidHistory(tag.getInt(TAG_RAIDERAMOUNT), tag.getLong(TAG_RAIDTIME));
            history.lostCitizens = tag.getInt("lostCitizens");
            history.difficulty = tag.getDouble("difficulty");
            ListTag nbtList = tag.getList(TAG_SPAWNINFO, 10);
            for (Tag entry : nbtList) {
                history.spawnData.add(RaidSpawnInfo.fromNBT((CompoundTag)entry));
            }
            return history;
        }

        public String toString() {
            return "Raid on: " + this.raidTime / 24000L + "\nRaiders spawned: " + this.raiderAmount + "\nRaiders killed: " + this.deadRaiders + "\nCitizens lost: " + this.lostCitizens + "\nDifficulty: " + this.difficulty + "\nSpawns:" + this.spawnData.stream().map(Object::toString).collect(Collectors.joining("\n"));
        }
    }

    public static class RaidSpawnInfo {
        static final String TAG_RAIDTYPE = "raidtype";
        public final ResourceLocation raidType;
        public final BlockPos spawnpos;

        public RaidSpawnInfo(ResourceLocation raidType, BlockPos spawnpos) {
            this.raidType = raidType;
            this.spawnpos = spawnpos;
        }

        private CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.putString(TAG_RAIDTYPE, this.raidType.toString());
            tag.putInt("x", this.spawnpos.getX());
            tag.putInt("y", this.spawnpos.getY());
            tag.putInt("z", this.spawnpos.getZ());
            return tag;
        }

        public static RaidSpawnInfo fromNBT(CompoundTag tag) {
            return new RaidSpawnInfo(ResourceLocation.parse((String)tag.getString(TAG_RAIDTYPE)), new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z")));
        }

        public String toString() {
            return "Type: " + this.raidType.toString() + " pos: " + this.spawnpos.toShortString();
        }
    }
}

