/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.core.colony.crafting.CustomRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class GenericRecipeUtils {
    private GenericRecipeUtils() {
    }

    @NotNull
    public static List<Component> calculateRestrictions(@NotNull CustomRecipe customRecipe) {
        Component researchName;
        ArrayList<Component> restrictions = new ArrayList<Component>();
        if (customRecipe.getMinBuildingLevel() == customRecipe.getMaxBuildingLevel()) {
            restrictions.add((Component)Component.translatableEscape((String)"com.minecolonies.coremod.jei.onelevelrestriction", (Object[])new Object[]{customRecipe.getMinBuildingLevel()}));
        } else if (customRecipe.getMinBuildingLevel() > 1 || customRecipe.getMaxBuildingLevel() < 5) {
            restrictions.add((Component)Component.translatableEscape((String)"com.minecolonies.coremod.jei.levelrestriction", (Object[])new Object[]{customRecipe.getMinBuildingLevel(), customRecipe.getMaxBuildingLevel()}));
        }
        for (ResourceLocation researchId : customRecipe.getRequiredResearchIds()) {
            researchName = GenericRecipeUtils.getResearchDisplayName(researchId);
            restrictions.add((Component)Component.translatableEscape((String)"com.minecolonies.coremod.jei.minresearch", (Object[])new Object[]{researchName}));
        }
        for (ResourceLocation researchId : customRecipe.getExcludedResearchIds()) {
            researchName = GenericRecipeUtils.getResearchDisplayName(researchId);
            restrictions.add((Component)Component.translatableEscape((String)"com.minecolonies.coremod.jei.maxresearch", (Object[])new Object[]{researchName}));
        }
        return restrictions;
    }

    @NotNull
    public static IGenericRecipe create(@NotNull CustomRecipe customRecipe, @NotNull IRecipeStorage storage) {
        return GenericRecipe.builder(storage).withRestrictions(GenericRecipeUtils.calculateRestrictions(customRecipe)).withLevelSort(customRecipe.getMinBuildingLevel()).build();
    }

    @NotNull
    public static IGenericRecipe filterInputs(@NotNull IGenericRecipe recipe, @NotNull OptionalPredicate<ItemStack> predicate) {
        boolean fallbackAccept = !GenericRecipeUtils.isDomumRecipe(recipe);
        ArrayList<List<ItemStack>> newInputs = new ArrayList<List<ItemStack>>();
        boolean modified = false;
        for (List<ItemStack> slot : recipe.getInputs()) {
            List<ItemStack> newSlot = GenericRecipeUtils.filterList(slot, predicate, fallbackAccept);
            if (newSlot.isEmpty() && !slot.isEmpty()) {
                newInputs.add(slot);
                continue;
            }
            modified |= newSlot.size() != slot.size();
            newInputs.add(newSlot);
        }
        if (!modified) {
            return recipe;
        }
        return GenericRecipe.builder(recipe).withInputs(newInputs).build();
    }

    private static <T> List<T> filterList(@NotNull List<T> input, @NotNull OptionalPredicate<T> predicate, boolean fallbackAccept) {
        ArrayList<T> newList = new ArrayList<T>();
        for (T stack : input) {
            if (!predicate.test(stack).orElse(fallbackAccept).booleanValue()) continue;
            newList.add(stack);
        }
        return newList;
    }

    private static boolean isDomumRecipe(@NotNull IGenericRecipe recipe) {
        ItemStack output = recipe.getPrimaryOutput();
        if (output.isEmpty()) {
            return false;
        }
        Item item = output.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock() instanceof IMateriallyTexturedBlock;
        }
        return false;
    }

    @NotNull
    private static Component getResearchDisplayName(@NotNull ResourceLocation researchId) {
        IGlobalResearchTree researchTree = IGlobalResearchTree.getInstance();
        IGlobalResearch research = researchTree.getResearch(researchId);
        if (research != null) {
            return MutableComponent.create((ComponentContents)research.getName());
        }
        Set<IGlobalResearch> researches = researchTree.getResearchForEffect(researchId);
        if (researches != null && !researches.isEmpty()) {
            return MutableComponent.create((ComponentContents)researches.iterator().next().getName());
        }
        return Component.literal((String)"???");
    }
}

