/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class BuildingSifter
extends AbstractBuilding {
    private static final double BUILDING_LEVEL_MULTIPLIER = 64.0;
    private static final String SIFTER_DESC = "sifter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private int currentDailyQuantity = 0;

    public BuildingSifter(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.is(ModTags.meshes), new Tuple((Object)4, (Object)false));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SIFTER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 64.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.currentDailyQuantity = compound.getInt("currentDaily");
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.putInt("currentDaily", this.currentDailyQuantity);
        return compound;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

