/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.client.gui.modules.building.FarmFieldsModuleWindow;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.BuildingExtensionsModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.buildings.moduleviews.FieldsModuleView;
import com.minecolonies.core.items.ItemCrop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFarmer
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> FERTILIZE = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "fertilize"));
    private static final String FARMER = "farmer";
    private static final int MAX_BUILDING_LEVEL = 5;
    @Nullable
    private BlockPos workingOffset;
    @Nullable
    private BlockPos prevPos;
    private int cell = -1;

    public BuildingFarmer(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (BuildingExtensionsModule module : this.getModulesByType(BuildingExtensionsModule.class)) {
            for (IBuildingExtension extension : module.getOwnedExtensions()) {
                FarmField farmField;
                if (!(extension instanceof FarmField) || (farmField = (FarmField)extension).getSeed().isEmpty()) continue;
                toKeep.put(stack -> ItemStack.isSameItem((ItemStack)farmField.getSeed(), (ItemStack)stack), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
            }
        }
        return toKeep;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        for (BuildingExtensionsModule module : this.getModulesByType(BuildingExtensionsModule.class)) {
            for (IBuildingExtension field : module.getOwnedExtensions()) {
                FarmField farmField;
                if (!(field instanceof FarmField) || (farmField = (FarmField)field).getSeed().isEmpty() || !ItemStackUtils.compareItemStacksIgnoreStackSize(farmField.getSeed(), stack).booleanValue()) continue;
                return false;
            }
        }
        if (stack.getItem() == Items.WHEAT) {
            return false;
        }
        return super.canEat(stack);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FARMER;
    }

    public boolean requestFertilizer() {
        return this.getSetting(FERTILIZE).getValue();
    }

    public BlockPos getWorkingOffset() {
        return this.workingOffset;
    }

    public int setCell(int i) {
        this.cell = i;
        return this.cell;
    }

    public int getCell() {
        return this.cell;
    }

    public void setPrevPos(BlockPos position) {
        this.prevPos = position;
    }

    public void setWorkingOffset(BlockPos blockPos) {
        this.workingOffset = blockPos;
    }

    public BlockPos getPrevPos() {
        return this.prevPos;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = super.serializeNBT(provider);
        compoundTag.putInt("cell", this.cell);
        if (this.workingOffset != null) {
            BlockPosUtil.write(compoundTag, "workingoffset", this.workingOffset);
        }
        if (this.prevPos != null) {
            BlockPosUtil.write(compoundTag, "prevpos", this.prevPos);
        }
        return compoundTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        if (compound.contains("cell")) {
            this.cell = compound.getInt("cell");
        }
        if (compound.contains("workingoffset")) {
            this.workingOffset = BlockPosUtil.read(compound, "workingoffset");
        }
        if (compound.contains("prevpos")) {
            this.prevPos = BlockPosUtil.read(compound, "prevpos");
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_FARMER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_FARMER).orElse(false);
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            for (ItemStack stack : IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems()) {
                BlockItem item;
                BlockItem item2;
                TagKey<Biome> preferredBiome;
                ItemCrop cropItem;
                Item item3 = stack.getItem();
                if (item3 instanceof ItemCrop && (item3 = (cropItem = (ItemCrop)item3).getBlock()) instanceof MinecoloniesCropBlock) {
                    MinecoloniesCropBlock crop = (MinecoloniesCropBlock)item3;
                    preferredBiome = crop.getPreferredBiome();
                    Supplier<List<Component>> restrictions = preferredBiome == null ? ArrayList::new : () -> this.provideBiomeList(preferredBiome);
                    recipes.add(GenericRecipe.builder().withInputs(List.of(List.of(cropItem.getDefaultInstance()))).withIntermediate(crop.getPreferredFarmland()).withLootTable((ResourceKey<LootTable>)crop.getLootTable()).withRequiredTool((EquipmentTypeEntry)ModEquipmentTypes.hoe.get()).withRestrictions(restrictions).build());
                    continue;
                }
                preferredBiome = stack.getItem();
                if (preferredBiome instanceof BlockItem && (preferredBiome = (item2 = (BlockItem)preferredBiome).getBlock()) instanceof CropBlock) {
                    CropBlock crop = (CropBlock)preferredBiome;
                    recipes.add(GenericRecipe.builder().withInputs(List.of(List.of(crop.getCloneItemStack((LevelReader)world, BlockPos.ZERO, crop.defaultBlockState())))).withIntermediate(Blocks.FARMLAND).withLootTable((ResourceKey<LootTable>)crop.getLootTable()).withRequiredTool((EquipmentTypeEntry)ModEquipmentTypes.hoe.get()).build());
                    continue;
                }
                if (!stack.is(Tags.Items.SEEDS)) continue;
                Item item4 = stack.getItem();
                if (item4 instanceof BlockItem && (item4 = (item = (BlockItem)item4).getBlock()) instanceof StemBlock) {
                    StemBlock stem = (StemBlock)item4;
                    recipes.add(GenericRecipe.builder().withOutput((ItemLike)BuiltInRegistries.BLOCK.get(stem.fruit)).withInputs(List.of(List.of(stack))).withIntermediate(Blocks.FARMLAND).withRequiredTool((EquipmentTypeEntry)ModEquipmentTypes.hoe.get()).build());
                    continue;
                }
                recipes.add(GenericRecipe.builder().withInputs(List.of(List.of(stack))).withIntermediate(Blocks.FARMLAND).withRequiredTool((EquipmentTypeEntry)ModEquipmentTypes.hoe.get()).build());
            }
            return recipes;
        }

        @NotNull
        private List<Component> provideBiomeList(@NotNull TagKey<Biome> preferredBiome) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null || mc.player == null) {
                return List.of();
            }
            Biome currentBiome = (Biome)mc.level.getBiome(mc.player.blockPosition()).value();
            Registry biomeRegistry = mc.level.registryAccess().registryOrThrow(preferredBiome.registry());
            Object[] biomes = StreamSupport.stream(biomeRegistry.getTagOrEmpty(preferredBiome).spliterator(), false).map(b -> {
                MutableComponent name = Component.translatable((String)((ResourceKey)b.unwrapKey().get()).location().toLanguageKey("biome"));
                return b.value() == currentBiome ? name.withStyle(ChatFormatting.DARK_GREEN) : name;
            }).toArray();
            return List.of(Component.translatable((String)"com.minecolonies.coremod.jei.biomerestriction", (Object[])new Object[]{Component.translatable((String)String.join((CharSequence)", ", Collections.nCopies(biomes.length, "%s")), (Object[])biomes)}));
        }

        @Override
        @NotNull
        public List<ResourceKey<LootTable>> getAdditionalLootTables() {
            ArrayList<ResourceKey<LootTable>> tables = new ArrayList<ResourceKey<LootTable>>(super.getAdditionalLootTables());
            for (ItemStack stack : IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems()) {
                BlockItem item;
                ItemCrop cropItem;
                Item item2 = stack.getItem();
                if (item2 instanceof ItemCrop && (item2 = (cropItem = (ItemCrop)item2).getBlock()) instanceof MinecoloniesCropBlock) {
                    MinecoloniesCropBlock crop = (MinecoloniesCropBlock)item2;
                    tables.add((ResourceKey<LootTable>)crop.getLootTable());
                    continue;
                }
                item2 = stack.getItem();
                if (!(item2 instanceof BlockItem) || !((item2 = (item = (BlockItem)item2).getBlock()) instanceof CropBlock)) continue;
                CropBlock crop = (CropBlock)item2;
                tables.add((ResourceKey<LootTable>)crop.getLootTable());
            }
            return tables;
        }
    }

    public static class FarmerFieldsModuleView
    extends FieldsModuleView {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BOWindow getWindow() {
            return new FarmFieldsModuleWindow(this);
        }

        @Override
        public boolean canAssignFieldOverride(IBuildingExtension field) {
            FarmField farmField;
            return field instanceof FarmField && !(farmField = (FarmField)field).getSeed().isEmpty();
        }

        @Override
        protected List<IBuildingExtension> getFieldsInColony() {
            return this.getColony().getBuildingExtensions(field -> field.getBuildingExtensionType().equals(BuildingExtensionRegistries.farmField.get()));
        }

        @Override
        @Nullable
        public MutableComponent getFieldWarningTooltip(IBuildingExtension field) {
            FarmField farmField;
            MutableComponent result = super.getFieldWarningTooltip(field);
            if (result != null) {
                return result;
            }
            if (field instanceof FarmField && (farmField = (FarmField)field).getSeed().isEmpty()) {
                return Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.fields.farmer.noseed", (Object[])new Object[0]);
            }
            return null;
        }
    }

    public static class FarmerFieldsModule
    extends BuildingExtensionsModule {
        @Override
        protected int getMaxExtensionCount() {
            return this.building.getBuildingLevel();
        }

        @Override
        public Class<?> getExpectedExtensionType() {
            return FarmField.class;
        }

        @Override
        @NotNull
        public List<IBuildingExtension> getMatchingExtension(Predicate<IBuildingExtension> predicateToMatch) {
            return this.building.getColony().getBuildingManager().getBuildingExtensions(field -> field.getBuildingExtensionType() == BuildingExtensionRegistries.farmField.get() && predicateToMatch.test((IBuildingExtension)field));
        }

        @Override
        public boolean canAssignExtensionOverride(IBuildingExtension extension) {
            FarmField farmField;
            return extension instanceof FarmField && !(farmField = (FarmField)extension).getSeed().isEmpty();
        }
    }
}

