/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.AllTowersTrigger;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBarracks;
import com.minecolonies.core.util.AdvancementUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracksTower
extends AbstractBuildingGuards {
    private static final String TAG_POS = "pos";
    private static final String SCHEMATIC_NAME = "barrackstower";
    private BlockPos barracks = null;

    public BuildingBarracksTower(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void requestUpgrade(Player player, BlockPos builder) {
        int buildingLevel = this.getBuildingLevel();
        IBuilding building = this.getColony().getBuildingManager().getBuilding(this.barracks);
        if (building != null && buildingLevel < this.getMaxBuildingLevel() && buildingLevel < building.getBuildingLevel()) {
            if (buildingLevel == 0) {
                this.requestWorkOrder(WorkOrderType.BUILD, builder);
            } else {
                this.requestWorkOrder(WorkOrderType.UPGRADE, builder);
            }
        } else {
            MessageUtils.format("com.minecolonies.coremod.worker.needbarracks", new Object[0]).sendTo(player);
        }
    }

    @Override
    public boolean canDeconstruct() {
        return false;
    }

    @Override
    public int getClaimRadius(int newLevel) {
        return 0;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        IBuilding barrack = this.colony.getBuildingManager().getBuilding(this.barracks);
        if (barrack == null) {
            return;
        }
        if (newLevel == barrack.getMaxBuildingLevel()) {
            boolean allUpgraded = true;
            for (BlockPos tower : ((BuildingBarracks)barrack).getTowers()) {
                if (this.colony.getBuildingManager().getBuilding(tower).getBuildingLevel() == barrack.getMaxBuildingLevel()) continue;
                allUpgraded = false;
            }
            if (allUpgraded) {
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, ((AllTowersTrigger)((Object)AdvancementTriggers.ALL_TOWERS.get()))::trigger);
            }
        }
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.barracks = NBTUtils.readBlockPos(compound, TAG_POS);
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        if (this.barracks != null) {
            compound.put(TAG_POS, NBTUtils.writeBlockPos(this.barracks));
        }
        return compound;
    }

    public void addBarracks(BlockPos pos) {
        this.barracks = pos;
    }
}

