/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IEntityListModuleView;
import com.minecolonies.core.client.gui.modules.building.EntityListModuleWindow;
import com.minecolonies.core.network.messages.server.colony.building.AssignFilterableEntityMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EntityListModuleView
extends AbstractBuildingModuleView
implements IEntityListModuleView {
    private final List<ResourceLocation> listOfEntities = new ArrayList<ResourceLocation>();
    private final String id;
    private final boolean inverted;
    private final Component desc;

    public EntityListModuleView(String id, Component desc, boolean inverted) {
        this.id = id;
        this.desc = desc;
        this.inverted = inverted;
    }

    @Override
    public void addEntity(ResourceLocation entity) {
        new AssignFilterableEntityMessage(this.buildingView, this.getProducer().getRuntimeID(), entity, true).sendToServer();
        this.listOfEntities.add(entity);
    }

    @Override
    public boolean isAllowedEntity(ResourceLocation entity) {
        return this.listOfEntities.contains(entity);
    }

    @Override
    public int getSize() {
        return this.listOfEntities.size();
    }

    @Override
    public void removeEntity(ResourceLocation entity) {
        new AssignFilterableEntityMessage(this.buildingView, this.getProducer().getRuntimeID(), entity, false).sendToServer();
        this.listOfEntities.remove(entity);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void clearEntities() {
        this.listOfEntities.clear();
    }

    @Override
    public Component getDesc() {
        return this.desc;
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        this.listOfEntities.clear();
        int size = buf.readInt();
        for (int j = 0; j < size; ++j) {
            this.listOfEntities.add(buf.readResourceLocation());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new EntityListModuleWindow(this);
    }

    @Override
    public ResourceLocation getIconResourceLocation() {
        return new ResourceLocation("minecolonies", "textures/gui/modules/workers.png");
    }
}

