/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules.settings;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.modules.settings.IBlockSettingFactory;
import com.minecolonies.api.colony.buildings.modules.settings.IBoolSettingFactory;
import com.minecolonies.api.colony.buildings.modules.settings.IIntSettingFactory;
import com.minecolonies.api.colony.buildings.modules.settings.IRecipeSettingFactory;
import com.minecolonies.api.colony.buildings.modules.settings.IStringSettingFactory;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.buildings.modules.settings.BeekeeperCollectionSetting;
import com.minecolonies.core.colony.buildings.modules.settings.BlockSetting;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.core.colony.buildings.modules.settings.CrafterRecipeSetting;
import com.minecolonies.core.colony.buildings.modules.settings.DynamicTreesSetting;
import com.minecolonies.core.colony.buildings.modules.settings.GuardFollowModeSetting;
import com.minecolonies.core.colony.buildings.modules.settings.GuardPatrolModeSetting;
import com.minecolonies.core.colony.buildings.modules.settings.GuardTaskSetting;
import com.minecolonies.core.colony.buildings.modules.settings.IntSetting;
import com.minecolonies.core.colony.buildings.modules.settings.RecipeSetting;
import com.minecolonies.core.colony.buildings.modules.settings.StringSetting;
import com.minecolonies.core.colony.buildings.modules.settings.StringSettingWithDesc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SettingsFactories {

    public static class RecipeSettingFactory
    implements IRecipeSettingFactory<RecipeSetting> {
        private static final String TAG_MODULE = "value";
        private static final String TAG_TOKEN = "token";

        @Override
        @NotNull
        public TypeToken<RecipeSetting> getFactoryOutputType() {
            return TypeToken.of(RecipeSetting.class);
        }

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public RecipeSetting getNewInstance(IToken<?> index, String craftingModuleId) {
            return new RecipeSetting(index, craftingModuleId);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull RecipeSetting storage) {
            CompoundTag compound = new CompoundTag();
            if (storage.selectedRecipe != null) {
                compound.put(TAG_TOKEN, (Tag)StandardFactoryController.getInstance().serializeTag(provider, storage.selectedRecipe));
            }
            compound.putString(TAG_MODULE, storage.craftingModuleId);
            return compound;
        }

        @Override
        @NotNull
        public RecipeSetting deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            IToken token = null;
            if (nbt.contains(TAG_TOKEN)) {
                token = (IToken)StandardFactoryController.getInstance().deserializeTag(provider, nbt.getCompound(TAG_TOKEN));
            }
            String moduleId = nbt.getString(TAG_MODULE);
            return this.getNewInstance(token, moduleId);
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull RecipeSetting input, @NotNull RegistryFriendlyByteBuf packetBuffer) {
            packetBuffer.writeBoolean(input.selectedRecipe != null);
            if (input.selectedRecipe != null) {
                StandardFactoryController.getInstance().serialize(packetBuffer, input.selectedRecipe);
            }
            packetBuffer.writeUtf(input.craftingModuleId);
        }

        @Override
        @NotNull
        public RecipeSetting deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            IToken token = null;
            if (buffer.readBoolean()) {
                token = (IToken)StandardFactoryController.getInstance().deserialize(buffer);
            }
            String moduleId = buffer.readUtf(Short.MAX_VALUE);
            return this.getNewInstance(token, moduleId);
        }

        @Override
        public short getSerializationId() {
            return 59;
        }
    }

    public static class BeekeeperCollectionSettingsFactory
    extends AbstractStringSettingsFactory<BeekeeperCollectionSetting> {
        @Override
        @NotNull
        public TypeToken<BeekeeperCollectionSetting> getFactoryOutputType() {
            return TypeToken.of(BeekeeperCollectionSetting.class);
        }

        @Override
        @NotNull
        public BeekeeperCollectionSetting getNewInstance(List<String> value, int curr) {
            return new BeekeeperCollectionSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 54;
        }
    }

    public static class DynamicTreesSettingFactory
    extends AbstractIntSettingFactory<DynamicTreesSetting> {
        @Override
        @NotNull
        public DynamicTreesSetting getNewInstance(int def, int current) {
            return new DynamicTreesSetting(def, current);
        }

        @Override
        @NotNull
        public TypeToken<DynamicTreesSetting> getFactoryOutputType() {
            return TypeToken.of(DynamicTreesSetting.class);
        }

        @Override
        public short getSerializationId() {
            return 57;
        }
    }

    public static class BuilderModeSettingFactory
    extends AbstractStringSettingsFactory<BuilderModeSetting> {
        @Override
        @NotNull
        public TypeToken<BuilderModeSetting> getFactoryOutputType() {
            return TypeToken.of(BuilderModeSetting.class);
        }

        @Override
        @NotNull
        public BuilderModeSetting getNewInstance(List<String> value, int curr) {
            return new BuilderModeSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 56;
        }
    }

    public static class CrafterRecipeSettingFactory
    extends AbstractStringSettingsFactory<CrafterRecipeSetting> {
        @Override
        @NotNull
        public TypeToken<CrafterRecipeSetting> getFactoryOutputType() {
            return TypeToken.of(CrafterRecipeSetting.class);
        }

        @Override
        @NotNull
        public CrafterRecipeSetting getNewInstance(List<String> value, int curr) {
            return new CrafterRecipeSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 55;
        }
    }

    public static class GuardFollowModeSettingFactory
    extends AbstractStringSettingsFactory<GuardFollowModeSetting> {
        @Override
        @NotNull
        public TypeToken<GuardFollowModeSetting> getFactoryOutputType() {
            return TypeToken.of(GuardFollowModeSetting.class);
        }

        @Override
        @NotNull
        public GuardFollowModeSetting getNewInstance(List<String> value, int curr) {
            return new GuardFollowModeSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 53;
        }
    }

    public static class GuardTaskSettingFactory
    extends AbstractStringSettingsFactory<GuardTaskSetting> {
        @Override
        @NotNull
        public TypeToken<GuardTaskSetting> getFactoryOutputType() {
            return TypeToken.of(GuardTaskSetting.class);
        }

        @Override
        @NotNull
        public GuardTaskSetting getNewInstance(List<String> value, int curr) {
            return new GuardTaskSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 52;
        }
    }

    public static class GuardPatrolModeSettingFactory
    extends AbstractStringSettingsFactory<GuardPatrolModeSetting> {
        @Override
        @NotNull
        public TypeToken<GuardPatrolModeSetting> getFactoryOutputType() {
            return TypeToken.of(GuardPatrolModeSetting.class);
        }

        @Override
        @NotNull
        public GuardPatrolModeSetting getNewInstance(List<String> value, int curr) {
            return new GuardPatrolModeSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 51;
        }
    }

    public static class StringWithDescSettingsFactory
    extends AbstractStringSettingsFactory<StringSettingWithDesc> {
        @Override
        @NotNull
        public TypeToken<StringSettingWithDesc> getFactoryOutputType() {
            return TypeToken.of(StringSettingWithDesc.class);
        }

        @Override
        @NotNull
        public StringSettingWithDesc getNewInstance(List<String> value, int curr) {
            return new StringSettingWithDesc(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 50;
        }
    }

    public static class IntSettingFactory
    extends AbstractIntSettingFactory<IntSetting> {
        @Override
        @NotNull
        public TypeToken<IntSetting> getFactoryOutputType() {
            return TypeToken.of(IntSetting.class);
        }

        @Override
        @NotNull
        public IntSetting getNewInstance(int value, int def) {
            return new IntSetting(value, def);
        }

        @Override
        public short getSerializationId() {
            return 48;
        }
    }

    public static abstract class AbstractIntSettingFactory<T extends IntSetting>
    implements IIntSettingFactory<T> {
        private static final String TAG_VALUE = "value";
        private static final String TAG_DEFAULT = "default";

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull IntSetting storage) {
            CompoundTag compound = new CompoundTag();
            compound.putInt(TAG_VALUE, storage.getValue().intValue());
            compound.putInt(TAG_DEFAULT, storage.getDefault());
            return compound;
        }

        @Override
        @NotNull
        public T deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return (T)((IntSetting)this.getNewInstance(nbt.getInt(TAG_VALUE), nbt.getInt(TAG_DEFAULT)));
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull IntSetting input, @NotNull RegistryFriendlyByteBuf packetBuffer) {
            packetBuffer.writeInt(input.getValue().intValue());
            packetBuffer.writeInt(input.getDefault());
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            return (T)((IntSetting)this.getNewInstance(buffer.readInt(), buffer.readInt()));
        }
    }

    public static class BlockSettingFactory
    implements IBlockSettingFactory<BlockSetting> {
        private static final String TAG_VALUE = "value";
        private static final String TAG_DEF = "default";

        @Override
        @NotNull
        public TypeToken<BlockSetting> getFactoryOutputType() {
            return TypeToken.of(BlockSetting.class);
        }

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public BlockSetting getNewInstance(BlockItem value, BlockItem def) {
            return new BlockSetting(value, def);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull BlockSetting storage) {
            CompoundTag compound = new CompoundTag();
            compound.putString(TAG_VALUE, BuiltInRegistries.ITEM.getKey((Object)storage.getValue()).toString());
            compound.putString(TAG_DEF, BuiltInRegistries.ITEM.getKey((Object)storage.getDefault()).toString());
            return compound;
        }

        @Override
        @NotNull
        public BlockSetting deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            BlockItem value = (BlockItem)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString(TAG_VALUE)));
            BlockItem def = (BlockItem)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString(TAG_DEF)));
            return this.getNewInstance(value, def);
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull BlockSetting input, @NotNull RegistryFriendlyByteBuf packetBuffer) {
            Utils.serializeCodecMess(packetBuffer, new ItemStack((ItemLike)input.getValue()));
            Utils.serializeCodecMess(packetBuffer, new ItemStack((ItemLike)input.getDefault()));
        }

        @Override
        @NotNull
        public BlockSetting deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            BlockItem value = (BlockItem)Utils.deserializeCodecMess(buffer).getItem();
            BlockItem def = (BlockItem)Utils.deserializeCodecMess(buffer).getItem();
            return this.getNewInstance(value, def);
        }

        @Override
        public short getSerializationId() {
            return 47;
        }
    }

    public static class StringSettingsFactory
    extends AbstractStringSettingsFactory<StringSetting> {
        @Override
        @NotNull
        public TypeToken<StringSetting> getFactoryOutputType() {
            return TypeToken.of(StringSetting.class);
        }

        @Override
        @NotNull
        public StringSetting getNewInstance(List<String> value, int curr) {
            return new StringSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 46;
        }
    }

    public static abstract class AbstractStringSettingsFactory<T extends StringSetting>
    implements IStringSettingFactory<T> {
        private static final String TAG_VALUE = "value";
        private static final String TAG_LIST = "settings";

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StringSetting storage) {
            CompoundTag compound = new CompoundTag();
            compound.putInt(TAG_VALUE, storage.getCurrentIndex());
            ListTag list = new ListTag();
            for (String setting : storage.getSettings()) {
                CompoundTag compoundNBT = new CompoundTag();
                compoundNBT.putString(TAG_VALUE, setting);
                list.add((Object)compoundNBT);
            }
            compound.put(TAG_LIST, (Tag)list);
            return compound;
        }

        @Override
        @NotNull
        public T deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            int current = nbt.getInt(TAG_VALUE);
            ArrayList<String> settings = new ArrayList<String>();
            ListTag list = nbt.getList(TAG_LIST, 10);
            for (int i = 0; i < list.size(); ++i) {
                settings.add(list.getCompound(i).getString(TAG_VALUE));
            }
            return (T)((StringSetting)this.getNewInstance(settings, current));
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull StringSetting input, @NotNull RegistryFriendlyByteBuf packetBuffer) {
            packetBuffer.writeInt(input.getCurrentIndex());
            packetBuffer.writeInt(input.getSettings().size());
            for (String setting : input.getSettings()) {
                packetBuffer.writeUtf(setting);
            }
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            int currentIndex = buffer.readInt();
            int size = buffer.readInt();
            ArrayList<String> settings = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                settings.add(buffer.readUtf(Short.MAX_VALUE));
            }
            return (T)((StringSetting)this.getNewInstance(settings, currentIndex));
        }
    }

    public static class BoolSettingFactory
    extends AbstractBoolSettingFactory<BoolSetting> {
        @Override
        @NotNull
        public TypeToken<BoolSetting> getFactoryOutputType() {
            return TypeToken.of(BoolSetting.class);
        }

        @Override
        @NotNull
        public BoolSetting getNewInstance(boolean value, boolean def) {
            return new BoolSetting(value, def);
        }

        @Override
        public short getSerializationId() {
            return 43;
        }
    }

    public static abstract class AbstractBoolSettingFactory<T extends BoolSetting>
    implements IBoolSettingFactory<T> {
        private static final String TAG_VALUE = "value";
        private static final String TAG_DEFAULT = "default";

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public T deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return (T)((BoolSetting)this.getNewInstance(nbt.getBoolean(TAG_VALUE), nbt.getBoolean(TAG_DEFAULT)));
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull T storage) {
            CompoundTag compound = new CompoundTag();
            compound.putBoolean(TAG_VALUE, ((BoolSetting)storage).getValue().booleanValue());
            compound.putBoolean(TAG_DEFAULT, ((BoolSetting)storage).getDefault());
            return compound;
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull T input, @NotNull RegistryFriendlyByteBuf packetBuffer) {
            packetBuffer.writeBoolean(((BoolSetting)input).getValue().booleanValue());
            packetBuffer.writeBoolean(((BoolSetting)input).getDefault());
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            return (T)((BoolSetting)this.getNewInstance(buffer.readBoolean(), buffer.readBoolean()));
        }
    }
}

