/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.colony.managers.StatisticsManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class BuildingStatisticsModule
extends AbstractBuildingModule
implements IPersistentModule {
    private IStatisticsManager statisticsManager = new StatisticsManager();

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.statisticsManager.readFromNBT(compound);
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.statisticsManager.writeToNBT(compound);
    }

    @Override
    public void serializeToView(RegistryFriendlyByteBuf buf, boolean fullSync) {
        this.statisticsManager.serialize(buf, fullSync);
    }

    public IStatisticsManager getBuildingStatisticsManager() {
        return this.statisticsManager;
    }

    public void increment(String s) {
        this.statisticsManager.increment(s, this.building.getColony().getDay());
        if (MathUtils.RANDOM.nextInt(10) == 0) {
            this.markDirty();
        }
    }

    public void incrementBy(String s, int count) {
        this.statisticsManager.incrementBy(s, count, this.building.getColony().getDay());
        if (MathUtils.RANDOM.nextInt(10) <= count) {
            this.markDirty();
        }
    }
}

