/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IHasRequiredItemsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ClassicRecipe;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.MultiOutputRecipe;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.CraftingWorkerBuildingModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.modules.settings.CrafterRecipeSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.crafting.CustomRecipe;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import com.minecolonies.core.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingBuildingModule
extends AbstractBuildingModule
implements ICraftingBuildingModule,
IPersistentModule,
ICreatesResolversModule,
IHasRequiredItemsModule,
ITickingModule {
    public static final ISettingKey<CrafterRecipeSetting> RECIPE_MODE = new SettingKey<CrafterRecipeSetting>(CrafterRecipeSetting.class, new ResourceLocation("minecolonies", "recipemode"));
    private static final double BASE_CHANCE = 0.0625;
    private static final int EXTRA_RECIPE_MULTIPLIER = 5;
    protected final List<IToken<?>> recipes = new ArrayList();
    protected final List<IToken<?>> disabledRecipes = new ArrayList();
    protected final JobEntry jobEntry;
    protected AbstractBuilding building;
    private boolean recipesDirty = true;

    public AbstractCraftingBuildingModule(JobEntry jobEntry) {
        this.jobEntry = jobEntry;
    }

    @Override
    public List<IToken<?>> getRecipes() {
        return this.recipes;
    }

    @Override
    public IBuildingModule setBuilding(IBuilding building) {
        this.building = (AbstractBuilding)building;
        return super.setBuilding(building);
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        return this.hasSpaceForMoreRecipes() && this.isRecipeCompatibleWithCraftingModule(token);
    }

    private boolean hasSpaceForMoreRecipes() {
        return this.getMaxRecipes() > this.getActiveRecipes();
    }

    private int getActiveRecipes() {
        return Math.max(0, this.recipes.size() - this.disabledRecipes.size());
    }

    protected int getMaxRecipes() {
        double increase = 1.0 + this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RECIPES);
        if (this.canLearnManyRecipes()) {
            increase *= 5.0;
        }
        return (int)(Math.pow(2.0, this.building.getBuildingLevel()) * increase);
    }

    protected boolean isRecipeCompatibleWithCraftingModule(IToken<?> token) {
        IGenericRecipe recipe = GenericRecipe.of(token);
        if (recipe == null) {
            return false;
        }
        return this.isRecipeCompatible(recipe);
    }

    protected boolean isPreTaughtRecipe(IRecipeStorage storage, Map<ResourceLocation, CustomRecipe> crafterRecipes) {
        ItemStack one = storage.getPrimaryOutput();
        for (CustomRecipe rec : crafterRecipes.values()) {
            ItemStack two = rec.getRecipeStorage().getPrimaryOutput();
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(one, two).booleanValue() || one.getCount() != two.getCount()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        @NotNull ListTag recipesTagList = this.recipes.stream().map(iToken -> StandardFactoryController.getInstance().serializeTag(provider, iToken)).collect(NBTUtils.toListNBT());
        compound.put("recipes", (Tag)recipesTagList);
        @NotNull ListTag disabledRecipesTag = new ListTag();
        for (IToken<?> recipe : this.disabledRecipes) {
            if (!this.disabledRecipes.contains(recipe)) continue;
            disabledRecipesTag.add((Object)StandardFactoryController.getInstance().serializeTag(provider, recipe));
        }
        compound.put("disabledrecipes", (Tag)disabledRecipesTag);
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        if (compound.contains(this.getId())) {
            compound = compound.getCompound(this.getId());
        }
        ListTag recipesTags = new ListTag();
        if (compound.contains("recipes")) {
            recipesTags = compound.getList("recipes", 10);
        }
        for (int i = 0; i < recipesTags.size(); ++i) {
            IToken token = (IToken)StandardFactoryController.getInstance().deserializeTag(provider, recipesTags.getCompound(i));
            if (this.recipes.contains(token)) continue;
            this.recipes.add(token);
            IColonyManager.getInstance().getRecipeManager().registerUse(token);
        }
        if (compound.contains("disabledrecipes")) {
            ListTag disabledRecipeTag = compound.getList("disabledrecipes", 10);
            for (int i = 0; i < disabledRecipeTag.size(); ++i) {
                IToken token = (IToken)StandardFactoryController.getInstance().deserializeTag(provider, disabledRecipeTag.getCompound(i));
                if (this.disabledRecipes.contains(token)) continue;
                this.disabledRecipes.add(token);
            }
        }
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf, boolean fullSync) {
        if (this.jobEntry != null) {
            buf.writeBoolean(true);
            buf.writeById(arg_0 -> IMinecoloniesAPI.getInstance().getJobRegistry().getIdOrThrow(arg_0), (Object)this.jobEntry);
        } else {
            buf.writeBoolean(false);
        }
        Set<CraftingType> craftingTypes = this.getSupportedCraftingTypes();
        buf.writeVarInt(craftingTypes.size());
        for (CraftingType type : craftingTypes) {
            buf.writeById(arg_0 -> MinecoloniesAPIProxy.getInstance().getCraftingTypeRegistry().getIdOrThrow(arg_0), (Object)type);
        }
        buf.writeBoolean(this.recipesDirty || fullSync);
        if (this.recipesDirty || fullSync) {
            ArrayList<IRecipeStorage> storages = new ArrayList<IRecipeStorage>();
            ArrayList<IRecipeStorage> disabledStorages = new ArrayList<IRecipeStorage>();
            Map<ResourceLocation, CustomRecipe> crafterRecipes = CustomRecipeManager.getInstance().getAllRecipes().getOrDefault(this.getCustomRecipeKey(), Collections.emptyMap());
            for (IToken<?> token : new ArrayList(this.recipes)) {
                IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
                if (storage == null || storage.getRecipeSource() != null && !crafterRecipes.containsKey(storage.getRecipeSource()) || !this.isRecipeCompatibleWithCraftingModule(token) && !this.isPreTaughtRecipe(storage, crafterRecipes)) {
                    this.removeRecipe(token);
                    continue;
                }
                storages.add(storage);
                if (!this.disabledRecipes.contains(token)) continue;
                disabledStorages.add(storage);
            }
            buf.writeInt(storages.size());
            for (IRecipeStorage storage : storages) {
                StandardFactoryController.getInstance().serialize(buf, storage);
            }
            buf.writeInt(disabledStorages.size());
            for (IRecipeStorage storage : disabledStorages) {
                StandardFactoryController.getInstance().serialize(buf, storage);
            }
        }
        this.recipesDirty = false;
        buf.writeInt(this.getMaxRecipes());
        buf.writeUtf(this.getId());
        buf.writeBoolean(this.isVisible());
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<ItemStorage, Tuple> requiredItems = new HashMap<ItemStorage, Tuple>();
        for (Tuple<IRecipeStorage, Integer> recipeStorage : this.getPendingRequestQueueExcluding(null)) {
            for (ItemStorage itemStorage : ((IRecipeStorage)recipeStorage.getA()).getCleanedInput()) {
                int amount = itemStorage.getAmount() * (Integer)recipeStorage.getB();
                if (requiredItems.containsKey(itemStorage)) {
                    amount += ((Integer)((Tuple)requiredItems.get(itemStorage)).getA()).intValue();
                }
                requiredItems.put(itemStorage, new Tuple((Object)amount, (Object)false));
            }
            ItemStorage output = new ItemStorage(((IRecipeStorage)recipeStorage.getA()).getPrimaryOutput());
            int amount = output.getAmount() * (Integer)recipeStorage.getB();
            if (requiredItems.containsKey(output)) {
                amount += ((Integer)((Tuple)requiredItems.get(output)).getA()).intValue();
            }
            requiredItems.put(output, new Tuple((Object)amount, (Object)false));
        }
        return new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(requiredItems.entrySet().stream().collect(Collectors.toMap(key -> stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, ((ItemStorage)key.getKey()).getItemStack(), false, true), Map.Entry::getValue)));
    }

    @Override
    public Map<ItemStorage, Integer> reservedStacksExcluding(@Nullable IRequest<? extends IDeliverable> request) {
        HashMap<ItemStorage, Integer> recipeOutputs = new HashMap<ItemStorage, Integer>();
        for (Tuple<IRecipeStorage, Integer> recipeStorage : this.getPendingRequestQueueExcluding(request)) {
            for (ItemStorage itemStorage : ((IRecipeStorage)recipeStorage.getA()).getCleanedInput()) {
                int amount = itemStorage.getAmount() * (Integer)recipeStorage.getB();
                if (recipeOutputs.containsKey(itemStorage)) {
                    amount += ((Integer)recipeOutputs.get(itemStorage)).intValue();
                }
                recipeOutputs.put(itemStorage, amount);
            }
        }
        return recipeOutputs;
    }

    private List<Tuple<IRecipeStorage, Integer>> getPendingRequestQueueExcluding(@Nullable IRequest<? extends IDeliverable> excluded) {
        ArrayList<Tuple<IRecipeStorage, Integer>> recipes = new ArrayList<Tuple<IRecipeStorage, Integer>>();
        for (ICitizenData citizen : this.building.getAllAssignedCitizen()) {
            if (!(citizen.getJob() instanceof AbstractJobCrafter)) continue;
            ArrayList assignedTasks = new ArrayList(citizen.getJob(AbstractJobCrafter.class).getAssignedTasks());
            assignedTasks.addAll(citizen.getJob(AbstractJobCrafter.class).getTaskQueue());
            for (IToken iToken : assignedTasks) {
                IRequest<?> request = this.building.getColony().getRequestManager().getRequestForToken(iToken);
                if (request == null || excluded != null && AbstractCraftingBuildingModule.anyChildRequestIs(this.building.getColony().getRequestManager(), request, excluded)) continue;
                IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(((PublicCrafting)request.getRequest()).getRecipeID());
                if (!this.holdsRecipe(((PublicCrafting)request.getRequest()).getRecipeID()) || recipeStorage == null) continue;
                recipes.add((Tuple<IRecipeStorage, Integer>)new Tuple((Object)recipeStorage, (Object)((PublicCrafting)request.getRequest()).getCount()));
            }
        }
        return recipes;
    }

    private static boolean anyChildRequestIs(@NotNull IRequestManager requestManager, @NotNull IRequest<?> parent, @NotNull IRequest<?> target) {
        return parent.getChildren().stream().anyMatch(childToken -> {
            IRequest<?> childRequest = requestManager.getRequestForToken((IToken<?>)childToken);
            if (childRequest == target) {
                return true;
            }
            if (childRequest != null) {
                return AbstractCraftingBuildingModule.anyChildRequestIs(requestManager, childRequest, target);
            }
            return false;
        });
    }

    @Override
    public boolean isVisible() {
        return !this.getSupportedCraftingTypes().isEmpty() || !this.recipes.isEmpty();
    }

    @Override
    public boolean addRecipe(IToken<?> token) {
        if (this.canRecipeBeAdded(token)) {
            this.addRecipeToList(token, false);
            this.markDirty();
            if (this.building.getAllAssignedCitizen().isEmpty()) {
                return true;
            }
            this.handleRecipeUpdate(token);
            return true;
        }
        return false;
    }

    public void handleRecipeUpdate(IToken<?> token) {
        IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        if (recipeStorage != null) {
            if (recipeStorage.getAlternateOutputs().isEmpty()) {
                this.building.getColony().getRequestManager().onColonyUpdate(request -> {
                    IDeliverable iDeliverable;
                    Object patt0$temp = request.getRequest();
                    return patt0$temp instanceof IDeliverable && (iDeliverable = (IDeliverable)patt0$temp).matches(recipeStorage.getPrimaryOutput());
                });
                return;
            }
            List<ItemStack> allOutputs = Stream.concat(Stream.of(recipeStorage.getPrimaryOutput()), recipeStorage.getAlternateOutputs().stream()).filter(stack -> !stack.isEmpty()).toList();
            this.building.getColony().getRequestManager().onColonyUpdate(request -> {
                Object patt0$temp = request.getRequest();
                if (!(patt0$temp instanceof IDeliverable)) return false;
                IDeliverable delivery = (IDeliverable)patt0$temp;
                if (!allOutputs.stream().anyMatch(i -> delivery.matches((ItemStack)i))) return false;
                return true;
            });
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        this.checkForWorkerSpecificRecipes();
    }

    @Override
    public void checkForWorkerSpecificRecipes() {
        IRecipeManager recipeManager = IColonyManager.getInstance().getRecipeManager();
        for (CustomRecipe newRecipe : CustomRecipeManager.getInstance().getRecipes(this.getCustomRecipeKey())) {
            IRecipeStorage recipeStorage = newRecipe.getRecipeStorage();
            IToken<?> recipeToken = recipeManager.checkOrAddRecipe(recipeStorage);
            if (newRecipe.isValidForBuilding(this.building)) {
                IToken<?> duplicateFound = null;
                boolean forceReplace = false;
                for (IToken<?> token : this.recipes) {
                    if (token == recipeToken) {
                        duplicateFound = token;
                        break;
                    }
                    IRecipeStorage storage = (IRecipeStorage)recipeManager.getRecipes().get(token);
                    if (storage == null || !ItemStack.matches((ItemStack)storage.getPrimaryOutput(), (ItemStack)recipeStorage.getPrimaryOutput())) continue;
                    List<ItemStorage> recipeInput1 = storage.getCleanedInput();
                    List<ItemStorage> recipeInput2 = recipeStorage.getCleanedInput();
                    if (recipeInput1.size() != recipeInput2.size()) continue;
                    if (recipeInput1.size() > 1) {
                        recipeInput1.sort(Comparator.comparing(item -> Objects.hash(item.hashCode(), item.getAmount())));
                        recipeInput2.sort(Comparator.comparing(item -> Objects.hash(item.hashCode(), item.getAmount())));
                    }
                    boolean allMatch = true;
                    for (int i = 0; i < recipeInput1.size(); ++i) {
                        if (recipeInput1.get(i).getItem().equals(recipeInput2.get(i).getItem())) continue;
                        allMatch = false;
                        break;
                    }
                    if (!allMatch) continue;
                    duplicateFound = token;
                    if (storage.getRecipeType() instanceof ClassicRecipe && recipeStorage.getRecipeType() instanceof MultiOutputRecipe) {
                        forceReplace = true;
                    }
                    if (storage.getRecipeSource() == null || !storage.getRecipeSource().equals((Object)recipeStorage.getRecipeSource())) break;
                    forceReplace = true;
                    break;
                }
                if (duplicateFound == null) {
                    this.addRecipeToList(recipeToken, true);
                    this.building.getColony().getRequestManager().onColonyUpdate(request -> {
                        IDeliverable iDeliverable;
                        Object patt0$temp = request.getRequest();
                        return patt0$temp instanceof IDeliverable && (iDeliverable = (IDeliverable)patt0$temp).matches(recipeStorage.getPrimaryOutput());
                    });
                    this.markDirty();
                    continue;
                }
                if (!forceReplace && !newRecipe.getMustExist() || duplicateFound.equals(recipeToken)) continue;
                this.replaceRecipe(duplicateFound, recipeToken);
                this.building.getColony().getRequestManager().onColonyUpdate(request -> {
                    IDeliverable iDeliverable;
                    Object patt0$temp = request.getRequest();
                    return patt0$temp instanceof IDeliverable && (iDeliverable = (IDeliverable)patt0$temp).matches(recipeStorage.getPrimaryOutput());
                });
                List<ItemStack> alternates = recipeStorage.getAlternateOutputs();
                for (IToken<?> token : this.recipes) {
                    IRecipeStorage storage = (IRecipeStorage)recipeManager.getRecipes().get(token);
                    if (!(storage.getRecipeType() instanceof ClassicRecipe) || !ItemStackUtils.compareItemStackListIgnoreStackSize(alternates, storage.getPrimaryOutput(), false, true)) continue;
                    this.removeRecipe(token);
                }
                this.building.getColony().getRequestManager().onColonyUpdate(request -> {
                    IDeliverable iDeliverable;
                    Object patt0$temp = request.getRequest();
                    return patt0$temp instanceof IDeliverable && (iDeliverable = (IDeliverable)patt0$temp).matches(recipeStorage.getPrimaryOutput());
                });
                this.markDirty();
                continue;
            }
            if (!this.recipes.contains(recipeToken)) continue;
            this.removeRecipe(recipeToken);
            this.markDirty();
        }
    }

    @Override
    public void clearRecipes() {
        this.recipes.clear();
        this.recipesDirty = true;
    }

    @Override
    public void improveRecipe(IRecipeStorage recipe, int count, ICitizenData citizen) {
        List inputs = recipe.getCleanedInput().stream().sorted(Comparator.comparingInt(ItemStorage::getAmount).reversed()).collect(Collectors.toList());
        double actualChance = Math.min(5.0, 0.0625 * (double)count + 0.0625 * (double)citizen.getCitizenSkillHandler().getLevel(((CraftingWorkerBuildingModule)this.building.getModuleMatching(CraftingWorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry)).getRecipeImprovementSkill()));
        double roll = citizen.getRandom().nextDouble() * 100.0;
        ItemStorage reducedItem = null;
        if (roll <= actualChance && ModTags.crafterProductExclusions.containsKey("reduceable") && !recipe.getPrimaryOutput().is(ModTags.crafterProductExclusions.get("reduceable"))) {
            ArrayList<ItemStorage> newRecipe = new ArrayList<ItemStorage>();
            boolean didReduction = false;
            for (ItemStorage input : inputs) {
                if (input.getAmount() > 1 && ModTags.crafterIngredient.containsKey("reduceable") && input.getItemStack().is(ModTags.crafterIngredient.get("reduceable"))) {
                    reducedItem = input.copy();
                    reducedItem.setAmount(input.getAmount() - 1);
                    newRecipe.add(reducedItem.toImmutable());
                    didReduction = true;
                    continue;
                }
                newRecipe.add(input.copy().toImmutable());
            }
            if (didReduction) {
                RecipeStorage storage = RecipeStorage.builder(recipe).withInputs(newRecipe).withRecipeId(null).build();
                IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(storage);
                if (this.isRecipeCompatibleWithCraftingModule(token)) {
                    this.replaceRecipe(recipe.getToken(), token);
                    MutableComponent jobComponent = MessageUtils.format(citizen.getJob().getJobRegistryEntry().getTranslationKey(), new Object[0]).create();
                    MessageUtils.format("com.minecolonies.coremod.crafters.recipeimproved." + citizen.getRandom().nextInt(3), jobComponent, recipe.getPrimaryOutput().getHoverName(), reducedItem.getItemStack().getHoverName(), citizen.getName()).sendTo(this.building.getColony()).forAllPlayers();
                }
            }
        }
    }

    @Override
    @Nullable
    public IRecipeStorage getFirstRecipe(ItemStack stack) {
        return this.getFirstRecipe((ItemStack itemStack) -> !itemStack.isEmpty() && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, true, true));
    }

    @Override
    @Nullable
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
        IRecipeStorage foundRecipe = null;
        HashMap<IRecipeStorage, Integer> candidates = new HashMap<IRecipeStorage, Integer>();
        for (IToken<?> iToken : this.recipes) {
            IRecipeStorage storage;
            if (this.disabledRecipes.contains(iToken) || (storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(iToken)) == null || !stackPredicate.test(storage.getPrimaryOutput()) && InventoryUtils.getFirstMatch(storage.getAlternateOutputs(), stackPredicate) == null || storage.getRecipeType() instanceof MultiOutputRecipe && storage.getClassicForMultiOutput(stackPredicate) == null) continue;
            if (foundRecipe == null) {
                foundRecipe = storage;
            }
            candidates.put(storage, 0);
        }
        if (candidates.size() > 1 && this.building.hasModule(ISettingsModule.class) && this.building.getSetting(RECIPE_MODE).getValue().equals("com.minecolonies.core.crafting.setting.maxstock")) {
            for (Map.Entry entry : candidates.entrySet()) {
                ItemStorage checkItem = ((IRecipeStorage)entry.getKey()).getCleanedInput().stream().max(Comparator.comparingInt(ItemStorage::getAmount)).get();
                candidates.put((IRecipeStorage)entry.getKey(), this.getWarehouseCount(checkItem));
            }
            foundRecipe = (IRecipeStorage)candidates.entrySet().stream().min(Map.Entry.comparingByValue(Comparator.reverseOrder())).get().getKey();
        }
        if (foundRecipe != null && foundRecipe.getRecipeType() instanceof MultiOutputRecipe) {
            IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(foundRecipe.getClassicForMultiOutput(stackPredicate));
            foundRecipe = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        }
        return foundRecipe;
    }

    @Override
    public boolean holdsRecipe(IToken<?> token) {
        if (this.disabledRecipes.contains(token)) {
            return false;
        }
        if (this.recipes.contains(token)) {
            return true;
        }
        IRecipeStorage storageIn = IColonyManager.getInstance().getRecipeManager().getRecipe(token);
        if (storageIn == null) {
            return false;
        }
        for (IToken<?> localToken : this.recipes) {
            IRecipeStorage storage = IColonyManager.getInstance().getRecipeManager().getRecipe(localToken);
            if (storage == null || !(storage.getRecipeType() instanceof MultiOutputRecipe) || !storageIn.equals(storage.getClassicForMultiOutput(storageIn.getPrimaryOutput()))) continue;
            return true;
        }
        return false;
    }

    protected int getWarehouseCount(ItemStorage item) {
        int count = 0;
        List<IWareHouse> wareHouses = this.building.getColony().getBuildingManager().getWareHouses();
        for (IWareHouse wareHouse : wareHouses) {
            count += InventoryUtils.getCountFromBuilding((IBuilding)wareHouse, item);
        }
        return count;
    }

    @Override
    public IRecipeStorage getFirstFulfillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
        for (IToken<?> token : this.recipes) {
            IRecipeStorage storage;
            if (this.disabledRecipes.contains(token) || (storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token)) == null || !stackPredicate.test(storage.getPrimaryOutput()) && !storage.getAlternateOutputs().stream().anyMatch(i -> stackPredicate.test((ItemStack)i))) continue;
            HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
            for (ICitizenData workerEntity : this.building.getAllAssignedCitizen()) {
                handlers.add(workerEntity.getInventory());
            }
            IRecipeStorage toTest = storage.getRecipeType() instanceof MultiOutputRecipe ? storage.getClassicForMultiOutput(stackPredicate) : storage;
            if (!toTest.canFullFillRecipe(count, considerReservation ? this.reservedStacks() : Collections.emptyMap(), new ArrayList<IItemHandler>(handlers), this.building)) continue;
            return toTest;
        }
        return null;
    }

    @Override
    public boolean fullFillRecipe(IRecipeStorage storage) {
        List<IItemHandler> handlers = this.building.getHandlers();
        ICitizenData data = ((WorkerBuildingModule)this.building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry)).getFirstCitizen();
        if (data == null || !data.getEntity().isPresent()) {
            return storage.fullfillRecipe(this.building.getColony().getWorld(), handlers);
        }
        AbstractEntityCitizen worker = data.getEntity().get();
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.building.getColony().getWorld()).withParameter(LootContextParams.ORIGIN, (Object)worker.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)worker).withParameter(LootContextParams.TOOL, (Object)this.getCraftingTool(worker)).withLuck(this.getCraftingLuck(worker));
        return storage.fullfillRecipe(builder.create(RecipeStorage.recipeLootParameters), handlers);
    }

    @Override
    public ItemStack getCraftingTool(AbstractEntityCitizen worker) {
        return worker != null ? worker.getMainHandItem() : ItemStack.EMPTY;
    }

    @Override
    public float getCraftingLuck(AbstractEntityCitizen worker) {
        if (worker != null) {
            WorkerBuildingModule workerModule = (WorkerBuildingModule)this.building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry);
            int primarySkill = worker.getCitizenData().getCitizenSkillHandler().getLevel(workerModule.getPrimarySkill());
            return (int)((double)((primarySkill + 1) * 2) - Math.pow((double)(primarySkill + 1) / 10.0, 2.0));
        }
        return 0.0f;
    }

    @Override
    @Nullable
    public IJob<?> getCraftingJob() {
        if (this.jobEntry == null) {
            return null;
        }
        return this.jobEntry.produceJob(null);
    }

    @Override
    public void updateWorkerAvailableForRecipes() {
        for (IToken<?> token : this.recipes) {
            IRecipeStorage recipeStorage;
            if (this.disabledRecipes.contains(token) || (recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token)) == null) continue;
            this.building.getColony().getRequestManager().onColonyUpdate(request -> {
                IDeliverable iDeliverable;
                Object patt0$temp = request.getRequest();
                return patt0$temp instanceof IDeliverable && (iDeliverable = (IDeliverable)patt0$temp).matches(recipeStorage.getPrimaryOutput());
            });
        }
    }

    @Override
    public void replaceRecipe(IToken<?> oldRecipe, IToken<?> newRecipe) {
        if (this.recipes.contains(oldRecipe)) {
            this.recipesDirty = true;
            int oldIndex = this.recipes.indexOf(oldRecipe);
            this.recipes.add(oldIndex, newRecipe);
            this.recipes.remove(oldRecipe);
            this.markDirty();
        }
    }

    @Override
    public void removeRecipe(IToken<?> token) {
        if (this.recipes.remove(token)) {
            this.recipesDirty = true;
            this.disabledRecipes.remove(token);
            this.markDirty();
            this.handleRecipeUpdate(token);
        } else {
            Log.getLogger().warn("Failure to remove recipe, please tell the mod authors about this");
            this.recipes.clear();
        }
    }

    @Override
    public void addRecipeToList(IToken<?> token, boolean atTop) {
        if (!this.recipes.contains(token)) {
            this.recipesDirty = true;
            if (atTop) {
                this.recipes.add(0, token);
            } else {
                this.recipes.add(token);
            }
        }
    }

    @Override
    public void switchOrder(int i, int j, boolean fullMove) {
        this.recipesDirty = true;
        if (fullMove) {
            if (i > j) {
                this.recipes.add(0, this.recipes.remove(i));
            } else {
                this.recipes.add(this.recipes.remove(i));
            }
        } else if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
            IToken<?> storage = this.recipes.get(i);
            this.recipes.set(i, this.recipes.get(j));
            this.recipes.set(j, storage);
            this.markDirty();
        }
    }

    @Override
    public void toggle(int recipeLocation) {
        IToken<?> key = this.recipes.get(recipeLocation);
        if (this.disabledRecipes.contains(key)) {
            this.disabledRecipes.remove(key);
            IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(key);
            if (recipeStorage != null) {
                this.building.getColony().getRequestManager().onColonyUpdate(request -> {
                    IDeliverable iDeliverable;
                    Object patt0$temp = request.getRequest();
                    return patt0$temp instanceof IDeliverable && (iDeliverable = (IDeliverable)patt0$temp).matches(recipeStorage.getPrimaryOutput());
                });
            }
        } else {
            this.disabledRecipes.add(key);
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
        return Collections.emptyList();
    }

    @Override
    public List<IRequestResolver<?>> createResolvers() {
        ArrayList resolvers = new ArrayList();
        resolvers.add(new PublicWorkerCraftingRequestResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN), this.jobEntry));
        resolvers.add(new PublicWorkerCraftingProductionResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN), this.jobEntry));
        return resolvers;
    }

    @Override
    @Deprecated
    @NotNull
    public abstract String getId();

    @Override
    @NotNull
    public String getCustomRecipeKey() {
        if (this.jobEntry == null) {
            return "";
        }
        return this.jobEntry.getKey().getPath() + "_" + this.getId();
    }

    @Override
    @NotNull
    public OptionalPredicate<ItemStack> getIngredientValidator() {
        return stack -> Optional.empty();
    }

    @Override
    public boolean canLearnManyRecipes() {
        return true;
    }

    @Override
    public boolean isDisabled(IToken<?> token) {
        return this.disabledRecipes.contains(token);
    }

    public static abstract class Custom
    extends AbstractCraftingBuildingModule {
        public Custom(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return Set.of();
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return false;
        }

        @Override
        @NotNull
        public String getId() {
            return "custom";
        }
    }

    public static abstract class Domum
    extends AbstractCraftingBuildingModule {
        public Domum(@NotNull JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return Set.of((CraftingType)ModCraftingTypes.ARCHITECTS_CUTTER.get());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            OptionalPredicate<ItemStack> validator = this.getIngredientValidator();
            ItemStack stack = recipe.getPrimaryOutput();
            if (BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace().equals("domum_ornamentum")) {
                for (List<ItemStack> slot : recipe.getInputs()) {
                    for (ItemStack ingredientStack : slot) {
                        if (ItemStackUtils.isEmpty(stack) || !validator.test(ingredientStack).orElse(false).booleanValue()) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        @NotNull
        public String getId() {
            return "domum";
        }
    }

    public static abstract class Brewing
    extends AbstractCraftingBuildingModule {
        public Brewing(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return ImmutableSet.of((Object)((CraftingType)ModCraftingTypes.BREWING.get()));
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return this.canLearn((CraftingType)ModCraftingTypes.BREWING.get()) && recipe.getIntermediate() == Blocks.BREWING_STAND;
        }

        @Override
        @NotNull
        public String getId() {
            return "brewing";
        }
    }

    public static abstract class Smelting
    extends AbstractCraftingBuildingModule {
        public Smelting(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return Set.of((CraftingType)ModCraftingTypes.SMELTING.get());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return this.canLearn((CraftingType)ModCraftingTypes.SMELTING.get()) && recipe.getIntermediate() == Blocks.FURNACE;
        }

        @Override
        @NotNull
        public String getId() {
            return "smelting";
        }
    }

    public static abstract class Crafting
    extends AbstractCraftingBuildingModule {
        public Crafting(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return Set.of((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get(), (CraftingType)ModCraftingTypes.LARGE_CRAFTING.get());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return this.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get()) && recipe.getIntermediate() == Blocks.AIR;
        }

        @Override
        @NotNull
        public String getId() {
            return "crafting";
        }
    }
}

