/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildingextensions;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildingextensions.AbstractBuildingExtension;
import com.minecolonies.core.tileentities.TileEntityScarecrow;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FarmField
extends AbstractBuildingExtension {
    public static final int MAX_RANGE = 20;
    public static final int DEFAULT_RANGE = 5;
    private static final String TAG_SEED = "seed";
    public static final String TAG_RADIUS = "radius";
    private static final String TAG_MAX_RANGE = "maxRange";
    private static final String TAG_STAGE = "stage";
    private ItemStack seed = ItemStack.EMPTY;
    private int[] radii = new int[]{5, 5, 5, 5};
    private Stage fieldStage = Stage.EMPTY;

    public FarmField(BuildingExtensionRegistries.BuildingExtensionEntry fieldType, BlockPos position) {
        super(fieldType, position);
    }

    public static FarmField create(BlockPos position, Level worldIn) {
        BlockEntity fieldBlock;
        FarmField farmField = (FarmField)((BuildingExtensionRegistries.BuildingExtensionEntry)BuildingExtensionRegistries.farmField.get()).produceExtension(position);
        if (farmField != null && (fieldBlock = worldIn.getBlockEntity(position)) instanceof TileEntityScarecrow) {
            TileEntityScarecrow scarecrow = (TileEntityScarecrow)fieldBlock;
            farmField.radii = scarecrow.getFieldSize();
        }
        return farmField;
    }

    @Override
    public boolean isValidPlacement(IColony colony) {
        BlockState blockState = colony.getWorld().getBlockState(this.getPosition());
        return blockState.is(ModBlocks.blockScarecrow);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.put(TAG_SEED, this.seed.saveOptional(provider));
        compound.putIntArray(TAG_RADIUS, this.radii);
        compound.putString(TAG_STAGE, this.fieldStage.name());
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.setSeed(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound(TAG_SEED)));
        this.radii = compound.getIntArray(TAG_RADIUS);
        this.fieldStage = Stage.valueOf(compound.getString(TAG_STAGE));
    }

    @Override
    public void serialize(@NotNull RegistryFriendlyByteBuf buf) {
        super.serialize(buf);
        Utils.serializeCodecMess(buf, this.getSeed());
        buf.writeVarIntArray(this.radii);
        buf.writeEnum((Enum)this.fieldStage);
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        super.deserialize(buf);
        this.setSeed(Utils.deserializeCodecMess(buf));
        this.radii = buf.readVarIntArray();
        this.fieldStage = (Stage)buf.readEnum(Stage.class);
    }

    @NotNull
    public ItemStack getSeed() {
        this.seed.setCount(1);
        return this.seed;
    }

    public void setSeed(ItemStack seed) {
        this.seed = seed.copy();
        this.seed.setCount(1);
    }

    public void nextState() {
        if (this.getFieldStage().ordinal() + 1 >= Stage.values().length) {
            this.setFieldStage(Stage.values()[0]);
            return;
        }
        this.setFieldStage(Stage.values()[this.getFieldStage().ordinal() + 1]);
    }

    public Stage getFieldStage() {
        return this.fieldStage;
    }

    public void setFieldStage(Stage fieldStage) {
        this.fieldStage = fieldStage;
    }

    public int getRadius(Direction direction) {
        return this.radii[direction.get2DDataValue()];
    }

    public void setRadius(Direction direction, int radius) {
        this.radii[direction.get2DDataValue()] = Math.min(radius, 20);
    }

    public boolean isNoPartOfField(@NotNull Level world, @NotNull BlockPos position) {
        return world.isEmptyBlock(position) || FarmField.isValidDelimiter(world.getBlockState(position.above()).getBlock());
    }

    private static boolean isValidDelimiter(Block block) {
        return block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock;
    }

    public static enum Stage {
        EMPTY(new ResourceLocation("minecraft", "textures/item/iron_hoe.png")),
        HOED(new ResourceLocation("minecraft", "textures/item/wheat_seeds.png")),
        PLANTED(new ResourceLocation("minecolonies", "textures/item/crops/durum.png"));

        protected final ResourceLocation stageIcon;

        private Stage(ResourceLocation stageIcon) {
            this.stageIcon = stageIcon;
        }

        public ResourceLocation getStageIcon() {
            return this.stageIcon;
        }

        public Component getStageText() {
            return Component.translatable((String)("com.minecolonies.coremod.gui.field.status." + this.name().toLowerCase(Locale.ROOT)));
        }

        public Stage getNextStage() {
            if (this.ordinal() + 1 >= Stage.values().length) {
                return Stage.values()[0];
            }
            return Stage.values()[this.ordinal() + 1];
        }
    }
}

