/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent.highlightmanager;

import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.client.render.worldevent.highlightmanager.IHighlightRenderData;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;

public class TimedBoxRenderData
implements IHighlightRenderData {
    private final List<String> text = new ArrayList<String>();
    private final BlockPos pos;
    private Duration duration;
    private int argbColor = -1;

    public TimedBoxRenderData(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void render(WorldEventContext context) {
        context.pushPoseCameraToPos(this.pos);
        context.renderLineBoxWithShadow(BlockPos.ZERO, this.argbColor, 0.025f);
        if (!this.text.isEmpty()) {
            context.renderDebugText(BlockPos.ZERO, this.text, true, 3);
        }
        context.popPose();
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    public TimedBoxRenderData setDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public TimedBoxRenderData addText(String text) {
        this.text.add(text);
        return this;
    }

    public TimedBoxRenderData setColor(int argbColor) {
        this.argbColor = argbColor;
        return this;
    }
}

