/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render.worldevent;

import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ItemOverlayBoxesRenderer {
    static void render(WorldEventContext ctx) {
        Item item = ctx.mainHandItem.getItem();
        if (item instanceof IBlockOverlayItem) {
            IBlockOverlayItem overlayItem = (IBlockOverlayItem)item;
            List<IBlockOverlayItem.OverlayBox> boxes = overlayItem.getOverlayBoxes((Level)ctx.clientLevel, (Player)ctx.clientPlayer, ctx.mainHandItem);
            for (IBlockOverlayItem.OverlayBox box : boxes) {
                BlockPos pos = box.pos();
                AABB bounds = box.bounds();
                if (pos == null) {
                    ctx.poseStack.pushPose();
                    ctx.poseStack.translate(bounds.minX - ctx.cameraPosition.x(), bounds.minY - ctx.cameraPosition.y(), bounds.minZ - ctx.cameraPosition.z());
                    bounds = bounds.move(-bounds.minX, -bounds.minY, -bounds.minZ);
                } else {
                    ctx.pushPoseCameraToPos(pos);
                    if (bounds != null) {
                        bounds = bounds.move(pos.multiply(-1));
                    }
                }
                if (box.showThroughBlocks()) {
                    if (pos != null) {
                        ctx.renderLineBoxWithShadow(BlockPos.ZERO, box.color(), box.width());
                    }
                    if (bounds != null) {
                        ctx.renderLineAABBWithShadow(bounds, box.color(), box.width());
                    }
                } else {
                    if (pos != null) {
                        ctx.renderLineBox(WorldEventContext.LINES_WITH_WIDTH, BlockPos.ZERO, box.color(), box.width());
                    }
                    if (bounds != null) {
                        ctx.renderLineAABB(WorldEventContext.LINES_WITH_WIDTH, bounds, box.color(), box.width());
                    }
                }
                ctx.popPose();
            }
        }
    }
}

