/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;

public class SleepingParticle
extends TextureSheetParticle {
    private final double coordX;
    private final double coordY;
    private final double coordZ;
    private static final int LIGHT_LEVEL = 0xF000F0;
    public static final ResourceLocation SLEEPING_TEXTURE = new ResourceLocation("minecolonies", "particle/sleeping");

    public SleepingParticle(SpriteSet spriteSet, ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.setSpriteFromAge(spriteSet);
        this.xd = xSpeedIn * 0.5;
        this.yd = ySpeedIn;
        this.zd = zSpeedIn;
        this.coordX = xCoordIn;
        this.coordY = yCoordIn;
        this.coordZ = zCoordIn;
        this.xo = xCoordIn;
        this.yo = yCoordIn;
        this.zo = zCoordIn;
        this.x = this.xo;
        this.y = this.yo;
        this.z = this.zo;
        float f = this.random.nextFloat() * 0.6f + 0.4f;
        this.rCol = 0.9f * f;
        this.gCol = 0.9f * f;
        this.bCol = f;
        this.lifetime = (int)(Math.random() * 30.0) + 40;
        this.quadSize = (float)((0.8 * Math.sin(0.0) + 1.3) * 0.1);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float f = (float)this.age / (float)this.lifetime;
        this.quadSize = (float)((0.8 * Math.sin(f * 4.0f) + 1.3) * 0.1);
        this.x = this.coordX + this.xd * (double)f;
        this.y = this.coordY + this.yd * (double)f;
        this.z = this.coordZ + this.zd * (double)f;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SleepingParticle(this.spriteSet, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

