/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.network.messages.server.GetColonyInfoMessage;
import com.minecolonies.core.network.messages.server.PickupBlockMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyAbandonOwnMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyDeleteOwnMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class WindowTownHallDeleteAbandonColony
extends AbstractWindowSkeleton {
    private static final String DELETE_PROCEED = "com.minecolonies.core.gui.colony.delete.proceed";
    private static final String ABANDON_PROCEED = "com.minecolonies.core.gui.colony.abandon.proceed";
    private static final String DELETE_WARNING = "com.minecolonies.core.gui.colony.delete.warning";
    private static final String ABANDON_WARNING = "com.minecolonies.core.gui.colony.abandon.warning";
    private final BlockPos pos;

    public WindowTownHallDeleteAbandonColony(BlockPos pos, String oldColonyName, BlockPos oldColonyPos) {
        super(new ResourceLocation("minecolonies", "gui/townhall/windowdeleteabandoncolony.xml"));
        this.pos = pos;
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        this.registerButton("cancel", this::close);
        this.registerButton("pickup", this::pickup);
        this.registerButton("delete", this::deleteColony);
        this.registerButton("abandon", this::abandonColony);
        this.registerButton("cancelaction", this::cancel);
        this.registerButton("confirmdelete", this::confirmDeleteColony);
        this.registerButton("confirmabandon", this::confirmAbandonColony);
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).allowInfiniteColonies.get()).booleanValue()) {
            ((ButtonImage)this.findPaneOfTypeByID("abandon", ButtonImage.class)).show();
            ((Text)this.findPaneOfTypeByID("warningtext", Text.class)).setText(Component.translatable((String)ABANDON_WARNING, (Object[])new Object[]{oldColonyPos.getX(), oldColonyPos.getY(), oldColonyPos.getZ(), Component.literal((String)oldColonyName).withStyle(ChatFormatting.DARK_RED)}));
        } else {
            ((ButtonImage)this.findPaneOfTypeByID("abandon", ButtonImage.class)).hide();
            ((Text)this.findPaneOfTypeByID("warningtext", Text.class)).setText(Component.translatable((String)DELETE_WARNING, (Object[])new Object[]{oldColonyPos.getX(), oldColonyPos.getY(), oldColonyPos.getZ(), Component.literal((String)oldColonyName).withStyle(ChatFormatting.DARK_RED)}));
        }
    }

    private void confirmAbandonColony() {
        new ColonyAbandonOwnMessage().sendToServer();
        new GetColonyInfoMessage(this.pos).sendToServer();
        this.close();
    }

    private void confirmDeleteColony() {
        new ColonyDeleteOwnMessage().sendToServer();
        new GetColonyInfoMessage(this.pos).sendToServer();
        this.close();
    }

    private void abandonColony() {
        ((Image)this.findPaneOfTypeByID("dialog", Image.class)).show();
        Text confirmText = (Text)this.findPaneOfTypeByID("confirmtext", Text.class);
        confirmText.show();
        confirmText.setText(Component.translatable((String)ABANDON_PROCEED));
        ((ButtonImage)this.findPaneOfTypeByID("confirmdelete", ButtonImage.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("confirmabandon", ButtonImage.class)).show();
        ((ButtonImage)this.findPaneOfTypeByID("cancelaction", ButtonImage.class)).show();
    }

    private void deleteColony() {
        ((Image)this.findPaneOfTypeByID("dialog", Image.class)).show();
        Text confirmText = (Text)this.findPaneOfTypeByID("confirmtext", Text.class);
        confirmText.show();
        confirmText.setText(Component.translatable((String)DELETE_PROCEED));
        ((ButtonImage)this.findPaneOfTypeByID("confirmdelete", ButtonImage.class)).show();
        ((ButtonImage)this.findPaneOfTypeByID("confirmabandon", ButtonImage.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("cancelaction", ButtonImage.class)).show();
    }

    private void cancel() {
        ((Image)this.findPaneOfTypeByID("dialog", Image.class)).hide();
        ((Text)this.findPaneOfTypeByID("confirmtext", Text.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("confirmdelete", ButtonImage.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("confirmabandon", ButtonImage.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("cancelaction", ButtonImage.class)).hide();
    }

    private void pickup() {
        new PickupBlockMessage(this.pos).sendToServer();
        this.close();
    }
}

