/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IItemListModuleView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemListModuleWindow
extends AbstractModuleWindow<IItemListModuleView> {
    protected final ScrollingList resourceList;
    private String filter = "";
    protected final boolean isInverted;
    protected List<ItemStorage> groupedItemList;
    protected final List<ItemStorage> currentDisplayedList = new ArrayList<ItemStorage>();
    private int tick;

    public ItemListModuleWindow(IItemListModuleView moduleView, ResourceLocation resource) {
        super(moduleView, resource);
        this.isInverted = moduleView.isInverted();
        this.id = moduleView.getId();
        this.registerButton("switch", this::switchClicked);
        this.registerButton("resetDefault", this::reset);
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        this.groupedItemList = new ArrayList<ItemStorage>((Collection)moduleView.getAllItems().apply(this.buildingView));
        ((TextField)this.window.findPaneOfTypeByID("input", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
    }

    @Override
    public void onOpened() {
        this.updateResources();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private void switchClicked(@NotNull Button button) {
        boolean add;
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ItemStorage item = this.currentDisplayedList.get(row);
        boolean on = button.getText().equals((Object)Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]));
        boolean bl = add = on && this.isInverted || !on && !this.isInverted;
        if (add) {
            ((IItemListModuleView)this.moduleView).addItem(item);
        } else {
            ((IItemListModuleView)this.moduleView).removeItem(item);
        }
        this.resourceList.refreshElementPanes();
    }

    private void reset() {
        ((IItemListModuleView)this.moduleView).clearItems();
        this.resourceList.refreshElementPanes();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.getDescriptionId().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.getHoverName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.currentDisplayedList.clear();
        for (ItemStorage storage : this.groupedItemList) {
            if (!filterPredicate.test(storage.getItemStack())) continue;
            this.currentDisplayedList.add(storage);
        }
        this.applySorting(this.currentDisplayedList);
        this.updateResourceList();
    }

    protected void applySorting(List<ItemStorage> displayedList) {
        displayedList.sort((o1, o2) -> {
            boolean o1Allowed = ((IItemListModuleView)this.moduleView).isAllowedItem((ItemStorage)o1);
            boolean o2Allowed = ((IItemListModuleView)this.moduleView).isAllowedItem((ItemStorage)o2);
            if (!o1Allowed && o2Allowed) {
                return this.isInverted ? -1 : 1;
            }
            if (o1Allowed && !o2Allowed) {
                return this.isInverted ? 1 : -1;
            }
            return 0;
        });
    }

    protected void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ItemListModuleWindow.this.currentDisplayedList.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ItemListModuleWindow.this.currentDisplayedList.get(index).getItemStack();
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.getHoverName());
                resourceLabel.setColors(7);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
                boolean isAllowedItem = ((IItemListModuleView)ItemListModuleWindow.this.moduleView).isAllowedItem(new ItemStorage(resource));
                Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                if (ItemListModuleWindow.this.isInverted && !isAllowedItem || !ItemListModuleWindow.this.isInverted && isAllowedItem) {
                    switchButton.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]));
                } else {
                    switchButton.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff", (Object[])new Object[0]));
                }
            }
        });
    }
}

