/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.connections.ColonyConnection;
import com.minecolonies.api.colony.connections.DiplomacyStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.AbstractBuildingWindow;
import com.minecolonies.core.commands.ClickEventWithExecutable;
import com.minecolonies.core.network.messages.server.colony.TeleportToColonyMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ConnectionModuleWindow
extends AbstractBuildingWindow<IBuildingView> {
    private static final String TRAVEL = "travel";
    private static final String LIST_DIRECT = "directcolonylist";
    private static final String LIST_INDIRECT = "indirectcolonylist";
    private final ScrollingList directConnections;
    private final ScrollingList indirectConnections;
    private final List<ColonyConnection> directConnectionData;
    private final List<ColonyConnection> indirectConnectionData;
    private final boolean externalPlayer;

    public ConnectionModuleWindow(IBuildingView buildingView, boolean externalPlayer) {
        super(buildingView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutcolonyconnection.xml"));
        if (externalPlayer) {
            for (Pane child : this.children) {
                if (!child.getID().contains("modules")) continue;
                child.setVisible(false);
            }
        }
        this.externalPlayer = externalPlayer;
        this.directConnections = (ScrollingList)this.findPaneOfTypeByID(LIST_DIRECT, ScrollingList.class);
        this.indirectConnections = (ScrollingList)this.findPaneOfTypeByID(LIST_INDIRECT, ScrollingList.class);
        this.directConnectionData = new ArrayList<ColonyConnection>(this.buildingView.getColony().getConnectionManager().getDirectlyConnectedColonies().values());
        this.indirectConnectionData = new ArrayList<ColonyConnection>(this.buildingView.getColony().getConnectionManager().getIndirectlyConnectedColonies().values());
        this.registerButton(TRAVEL, this::teleportToColony);
        this.updateConnections(this.directConnections, this.directConnectionData);
        this.updateConnections(this.indirectConnections, this.indirectConnectionData);
    }

    private ColonyConnection getColonyDataFromPane(@NotNull Button button) {
        int directRow = this.directConnections.getListElementIndexByPane((Pane)button);
        if (directRow != -1) {
            return this.directConnectionData.get(directRow);
        }
        int indirectRow = this.indirectConnections.getListElementIndexByPane((Pane)button);
        return this.indirectConnectionData.get(indirectRow);
    }

    private void teleportToColony(@NotNull Button button) {
        ColonyConnection connectedColonyData = this.getColonyDataFromPane(button);
        int dist = (int)BlockPosUtil.dist(connectedColonyData.pos, this.buildingView.getPosition());
        int itemCount = this.externalPlayer ? dist / 125 : 0;
        MessageUtils.format("com.minecolonies.core.gui.colonylist.travel.really", connectedColonyData.name).withPriority(MessageUtils.MessagePriority.IMPORTANT).withClickEvent(new ClickEventWithExecutable(() -> new TeleportToColonyMessage((ResourceKey<Level>)this.mc.level.dimension(), connectedColonyData.id, connectedColonyData.pos, this.buildingView.getColony().getID(), itemCount).sendToServer())).sendTo(new Player[]{Minecraft.getInstance().player});
        this.close();
    }

    private void updateConnections(ScrollingList connectionScrollList, final List<ColonyConnection> connectionData) {
        connectionScrollList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return connectionData.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ColonyConnection colonyData = (ColonyConnection)connectionData.get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)colonyData.name));
                ((Text)rowPane.findPaneOfTypeByID("distance", Text.class)).setText(Component.translatable((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{(int)BlockPosUtil.dist(colonyData.pos, ConnectionModuleWindow.this.buildingView.getColony().getCenter())}));
                ((Text)rowPane.findPaneOfTypeByID("state", Text.class)).setText(Component.translatable((String)colonyData.diplomacyStatus.translationKey()));
                int dist = (int)BlockPosUtil.dist(colonyData.pos, ConnectionModuleWindow.this.buildingView.getPosition());
                int itemCount = dist / 125;
                ItemIcon itemIcon = (ItemIcon)rowPane.findPaneOfTypeByID("icon", ItemIcon.class);
                if (ConnectionModuleWindow.this.externalPlayer) {
                    itemIcon.setItem(new ItemStack((ItemLike)Items.GOLD_NUGGET, itemCount));
                    itemIcon.show();
                } else {
                    itemIcon.hide();
                }
                Button button = (Button)rowPane.findPaneOfTypeByID(ConnectionModuleWindow.TRAVEL, Button.class);
                if (ConnectionModuleWindow.this.externalPlayer && InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)Minecraft.getInstance().player.getInventory()), Items.GOLD_NUGGET) <= itemCount) {
                    button.setEnabled(false);
                    PaneBuilders.tooltipBuilder().hoverPane((Pane)button).build().setText(Component.translatable((String)"com.ldtteam.gatehouse.travel.cost"));
                } else {
                    button.setEnabled(colonyData.diplomacyStatus == DiplomacyStatus.ALLIES && !colonyData.pos.equals((Object)BlockPos.ZERO));
                }
            }
        });
    }
}

