/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.structurize.client.gui.WindowExtendedBuildTool;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.network.messages.server.DirectPlaceMessage;
import com.minecolonies.core.network.messages.server.SwitchBuildingWithToolMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowSuggestBuildTool
extends AbstractWindowSkeleton {
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final BlockState building;
    @NotNull
    private ItemStack stack;

    public WindowSuggestBuildTool(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull ItemStack stack) {
        super(new ResourceLocation("minecolonies", "gui/windowsuggestbuildtool.xml"));
        this.pos = pos;
        this.building = state;
        this.stack = stack;
        this.registerButton("buildtool", this::buildToolClicked);
        this.registerButton("direct", this::directClicked);
        this.registerButton("cancel", this::cancelClicked);
    }

    private void directClicked() {
        new DirectPlaceMessage(this.building, this.pos, this.stack).sendToServer();
        this.close();
    }

    private void buildToolClicked() {
        if (InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)Minecraft.getInstance().player.getInventory()), (Item)ModItems.buildTool.get()) != -1) {
            new SwitchBuildingWithToolMessage(this.stack).sendToServer();
            new WindowExtendedBuildTool(this.pos, 1, (HolderLookup.Provider)this.mc.level.registryAccess()).open();
            return;
        }
        MessageUtils.format("item.buildtool.missing", new Object[0]).sendTo(new Player[]{Minecraft.getInstance().player});
        this.close();
    }

    private void cancelClicked() {
        this.close();
    }
}

