/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingBuilderView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildDecoration
extends AbstractWindowSkeleton {
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    @NotNull
    private final List<Tuple<String, BlockPos>> builders = new ArrayList<Tuple<String, BlockPos>>();
    private final String path;
    private final RotationMirror rotationMirror;
    private final Function<BlockPos, AbstractServerPlayMessage> buildRequestMessage;
    private DropDownList buildersDropDownList;
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private final BlockPos structurePos;
    private Future<Blueprint> blueprintFuture;

    public WindowBuildDecoration(BlockPos pos, String packMeta, String path, RotationMirror rotationMirror, Function<BlockPos, AbstractServerPlayMessage> buildRequestMessage) {
        super(new ResourceLocation("minecolonies", "gui/windowbuildbuilding.xml"));
        this.path = path;
        this.structurePos = pos;
        this.registerButton("build", this::confirmedBuild);
        this.registerButton("cancel", this::close);
        ((Button)this.findPaneOfTypeByID("build", Button.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.build", (Object[])new Object[0]));
        ((Button)this.findPaneOfTypeByID("build", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("deconstruct", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("repair", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("nextStyle", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("previousStyle", Button.class)).hide();
        ((DropDownList)this.findPaneOfTypeByID("style", DropDownList.class)).disable();
        ((DropDownList)this.findPaneOfTypeByID("style", DropDownList.class)).hide();
        String cleanedPackName = packMeta.replace(Minecraft.getInstance().player.getUUID().toString(), "");
        this.blueprintFuture = StructurePacks.getBlueprintFuture((String)cleanedPackName, (String)path, (HolderLookup.Provider)this.mc.level.registryAccess());
        this.rotationMirror = rotationMirror;
        this.buildRequestMessage = buildRequestMessage;
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateBuilders();
        this.updateResources();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateResources();
    }

    private void updateBuilders() {
        IColonyView colony = (IColonyView)IColonyManager.getInstance().getIColony((Level)Minecraft.getInstance().level, this.structurePos);
        if (colony == null) {
            MessageUtils.format("com.minecolonies.coremod.workorder.outofcolony", this.path, this.structurePos.getX(), this.structurePos.getZ()).sendTo(new Player[]{Minecraft.getInstance().player});
            this.close();
            return;
        }
        this.builders.clear();
        this.builders.add((Tuple<String, BlockPos>)new Tuple((Object)(Component.translatableEscape((String)((JobEntry)ModJobs.builder.get()).getTranslationKey(), (Object[])new Object[0]).getString() + ":"), (Object)BlockPos.ZERO));
        this.builders.addAll(colony.getBuildings().stream().filter(build -> build instanceof AbstractBuildingBuilderView && !((AbstractBuildingBuilderView)build).getWorkerName().isEmpty() && build.getBuildingType() != ModBuildings.miner.get() && build.getBuildingLevel() > 0).map(build -> new Tuple((Object)((AbstractBuildingBuilderView)build).getWorkerName(), (Object)build.getPosition())).sorted(Comparator.comparing(item -> ((BlockPos)item.getB()).distSqr((Vec3i)this.structurePos))).collect(Collectors.toList()));
        this.initBuilderNavigation();
    }

    private void initBuilderNavigation() {
        this.buildersDropDownList = (DropDownList)this.findPaneOfTypeByID("worker", DropDownList.class);
        this.buildersDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowBuildDecoration.this.builders.size();
            }

            public MutableComponent getLabel(int index) {
                if (index >= 0 && index < WindowBuildDecoration.this.builders.size()) {
                    return Component.literal((String)((String)WindowBuildDecoration.this.builders.get(index).getA()));
                }
                return Component.empty();
            }
        });
        this.buildersDropDownList.setSelectedIndex(0);
    }

    private void updateResources() {
        if (this.blueprintFuture == null || !this.blueprintFuture.isDone()) {
            return;
        }
        ClientLevel world = Minecraft.getInstance().level;
        this.resources.clear();
        try {
            StructurePhasePlacementResult result;
            if (this.blueprintFuture.get() == null) {
                this.blueprintFuture = null;
                return;
            }
            LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler((Level)world, this.structurePos, this.blueprintFuture.get(), RotationMirror.NONE, true);
            structure.getBluePrint().setRotationMirror(this.rotationMirror, (Level)Minecraft.getInstance().level);
            StructurePlacer placer = new StructurePlacer((IStructureHandler)structure);
            BlockPos progressPos = AbstractBlueprintIterator.NULL_POS;
            do {
                result = placer.executeStructureStep((Level)world, null, progressPos, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(), true);
                progressPos = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    this.addNeededResource(stack, stack.getCount());
                }
            } while (result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED);
            ((Button)this.findPaneOfTypeByID("build", Button.class)).show();
            ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
            this.updateResourceList();
            this.blueprintFuture = null;
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res) || amount == 0) {
            return;
        }
        int hashCode = res.getComponentsPatch().hashCode();
        String key = res.getDescriptionId() + "-" + hashCode;
        ItemStorage resource = this.resources.get(key);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.resources.put(key, resource);
    }

    public void updateResourceList() {
        ScrollingList recourseList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        recourseList.enable();
        recourseList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        recourseList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(Component.literal((String)resource.getItemStack().getHoverName().getString()));
                quantityLabel.setText(Component.literal((String)Integer.toString(resource.getAmount())));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack itemIcon = resource.getItemStack().copy();
                itemIcon.setCount(1);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(itemIcon);
            }
        });
    }

    private void confirmedBuild() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.ZERO : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).getB();
        this.buildRequestMessage.apply(builder).sendToServer();
        this.close();
    }
}

