/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks.huts;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BlockHutTavern
extends AbstractBlockHut<BlockHutTavern> {
    public static final String BLOCKHUT_TAVERN = "blockhuttavern";

    @Override
    @NotNull
    public String getHutName() {
        return BLOCKHUT_TAVERN;
    }

    @Override
    public BuildingEntry getBuildingEntry() {
        return (BuildingEntry)ModBuildings.tavern.get();
    }

    @Override
    public boolean canPlaceAt(BlockPos pos, Player player) {
        IColony colony = IColonyManager.getInstance().getIColony(player.level(), pos);
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            if (colony.getWorld() == null || colony.getWorld().isClientSide || !building.hasModule(BuildingModules.TAVERN_VISITOR)) continue;
            MessageUtils.format("tile.blockhut.tavern.limit", building.getPosition().toShortString()).sendTo(player);
            return false;
        }
        return true;
    }
}

