/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks.decorative;

import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockConstructionTape
extends AbstractBlockMinecoloniesConstructionTape<BlockConstructionTape> {
    public static final MapCodec<BlockConstructionTape> CODEC = BlockConstructionTape.simpleCodec(BlockConstructionTape::new);
    private static final String BLOCK_NAME = "blockconstructiontape";

    public BlockConstructionTape() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.WOOD).replaceable().pushReaction(PushReaction.DESTROY).isRedstoneConductor((state, getter, pos) -> false).forceSolidOff().strength(0.0f).noCollission().noLootTable());
    }

    public BlockConstructionTape(BlockBehaviour.Properties properties) {
        super(properties);
        this.shapes = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)CORNER, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<BlockConstructionTape> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    @Override
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return super.getShape(state, worldIn, pos, context);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] faces = context.getNearestLookingDirections();
        return BlockConstructionTape.getPlacementState(super.getStateForPlacement(context), (BlockGetter)context.getLevel(), context.getClickedPos(), faces[0].get2DDataValue() >= 0 ? faces[0] : faces[1]);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, Direction dir, BlockState state, LevelAccessor worldIn, @NotNull BlockPos currentPos, BlockPos pos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return BlockConstructionTape.getPlacementState(super.updateShape(stateIn, dir, state, worldIn, currentPos, pos), (BlockGetter)worldIn, currentPos, (Direction)stateIn.getValue((Property)FACING));
    }

    public static BlockState getPlacementState(@Nullable BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        Fluid fluid = world.getFluidState(pos).getType();
        List<Direction> connections = BlockConstructionTape.getConnections(world, pos, face, (Boolean)state.getValue((Property)CORNER));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(connections.contains(Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(connections.contains(Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(connections.contains(Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(connections.contains(Direction.WEST)))).setValue((Property)FACING, (Comparable)face)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.WATER));
    }

    public static List<Direction> getConnections(BlockGetter world, BlockPos pos, Direction face, boolean corner) {
        ArrayList<Direction> connections = new ArrayList<Direction>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!BlockConstructionTape.canConnect(world, pos, direction)) continue;
            connections.add(direction);
        }
        if (connections.size() == 0 || connections.size() == 1 && corner) {
            if (corner) {
                connections.clear();
                connections.add(face);
                connections.add(face.getClockWise());
            } else {
                connections.add(face.getAxis() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST);
                connections.add(face.getAxis() == Direction.Axis.X ? Direction.NORTH : Direction.WEST);
            }
        } else if (connections.size() == 1) {
            connections.add(((Direction)connections.get(0)).getOpposite());
        } else if (connections.size() == 3) {
            Direction stem = Direction.NORTH;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (connections.contains(direction)) continue;
                stem = direction.getOpposite();
            }
            if (BlockConstructionTape.canRemoveTStem(world, pos, stem)) {
                connections.remove(connections.indexOf(stem));
            }
        }
        return connections;
    }

    protected static boolean canConnect(BlockGetter world, BlockPos pos, Direction face) {
        return world.getBlockState(switch (face) {
            default -> pos.north();
            case Direction.EAST -> pos.east();
            case Direction.SOUTH -> pos.south();
            case Direction.WEST -> pos.west();
        }).getBlock() instanceof BlockConstructionTape;
    }

    protected static boolean canRemoveTStem(BlockGetter world, BlockPos pos, Direction face) {
        BlockState neighbor = world.getBlockState(pos.relative(face));
        switch (face) {
            case NORTH: {
                return (Boolean)neighbor.getValue((Property)NORTH) == false && (Boolean)neighbor.getValue((Property)EAST) != false && (Boolean)neighbor.getValue((Property)WEST) != false;
            }
            case EAST: {
                return (Boolean)neighbor.getValue((Property)EAST) == false && (Boolean)neighbor.getValue((Property)NORTH) != false && (Boolean)neighbor.getValue((Property)SOUTH) != false;
            }
            case SOUTH: {
                return (Boolean)neighbor.getValue((Property)SOUTH) == false && (Boolean)neighbor.getValue((Property)EAST) != false && (Boolean)neighbor.getValue((Property)WEST) != false;
            }
            case WEST: {
                return (Boolean)neighbor.getValue((Property)WEST) == false && (Boolean)neighbor.getValue((Property)NORTH) != false && (Boolean)neighbor.getValue((Property)SOUTH) != false;
            }
        }
        return false;
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    public void onLand(Level worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity blockEntity) {
        worldIn.setBlockAndUpdate(pos, BlockConstructionTape.getPlacementState(fallingState, (BlockGetter)worldIn, pos, (Direction)fallingState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, FACING, CORNER, WATERLOGGED});
    }
}

